/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.authentication.server;

import java.util.Map;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.http.FilterContainer;
import oadd.org.apache.hadoop.http.FilterInitializer;
import oadd.org.apache.hadoop.security.AuthenticationFilterInitializer;
import oadd.org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilter;

public class ProxyUserAuthenticationFilterInitializer
extends FilterInitializer {
    private String configPrefix = "hadoop.http.authentication.";

    protected Map<String, String> createFilterConfig(Configuration conf) {
        Map<String, String> filterConfig = AuthenticationFilterInitializer.getFilterConfigMap(conf, this.configPrefix);
        for (Map.Entry<String, String> entry : conf.getPropsWithPrefix("hadoop.proxyuser").entrySet()) {
            filterConfig.put("proxyuser" + entry.getKey(), entry.getValue());
        }
        return filterConfig;
    }

    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = this.createFilterConfig(conf);
        container.addFilter("ProxyUserAuthenticationFilter", ProxyUserAuthenticationFilter.class.getName(), filterConfig);
    }
}

