/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.alias;

import java.io.IOException;
import java.net.URI;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.security.alias.CredentialProvider;
import oadd.org.apache.hadoop.security.alias.CredentialProviderFactory;
import oadd.org.apache.hadoop.security.alias.KeyStoreProvider;

@InterfaceAudience.Private
public final class BouncyCastleFipsKeyStoreProvider
extends KeyStoreProvider {
    public static final String SCHEME_NAME = "bcfks";
    public static final String KEYSTORE_TYPE = "bcfks";
    public static final String ALGORITHM = "HMACSHA512";

    private BouncyCastleFipsKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        super(uri, conf);
    }

    @Override
    protected String getSchemeName() {
        return "bcfks";
    }

    @Override
    protected String getKeyStoreType() {
        return "bcfks";
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }

    public static class Factory
    extends CredentialProviderFactory {
        @Override
        public CredentialProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if ("bcfks".equals(providerName.getScheme())) {
                return new BouncyCastleFipsKeyStoreProvider(providerName, conf);
            }
            return null;
        }
    }
}

