/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.impl;

import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import oadd.org.apache.hadoop.metrics2.AbstractMetric;
import oadd.org.apache.hadoop.metrics2.MetricsInfo;
import oadd.org.apache.hadoop.metrics2.MetricsTag;
import oadd.org.apache.hadoop.metrics2.MetricsVisitor;
import oadd.org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import oadd.org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import oadd.org.apache.hadoop.thirdparty.com.google.common.collect.Lists;

class MBeanInfoBuilder
implements MetricsVisitor {
    private final String name;
    private final String description;
    private List<MBeanAttributeInfo> attrs;
    private Iterable<MetricsRecordImpl> recs;
    private int curRecNo;

    MBeanInfoBuilder(String name, String desc) {
        this.name = name;
        this.description = desc;
        this.attrs = Lists.newArrayList();
    }

    MBeanInfoBuilder reset(Iterable<MetricsRecordImpl> recs) {
        this.recs = recs;
        this.attrs.clear();
        return this;
    }

    MBeanAttributeInfo newAttrInfo(String name, String desc, String type) {
        return new MBeanAttributeInfo(this.getAttrName(name), type, desc, true, false, false);
    }

    MBeanAttributeInfo newAttrInfo(MetricsInfo info, String type) {
        return this.newAttrInfo(info.name(), info.description(), type);
    }

    @Override
    public void gauge(MetricsInfo info, int value) {
        this.attrs.add(this.newAttrInfo(info, "java.lang.Integer"));
    }

    @Override
    public void gauge(MetricsInfo info, long value) {
        this.attrs.add(this.newAttrInfo(info, "java.lang.Long"));
    }

    @Override
    public void gauge(MetricsInfo info, float value) {
        this.attrs.add(this.newAttrInfo(info, "java.lang.Float"));
    }

    @Override
    public void gauge(MetricsInfo info, double value) {
        this.attrs.add(this.newAttrInfo(info, "java.lang.Double"));
    }

    @Override
    public void counter(MetricsInfo info, int value) {
        this.attrs.add(this.newAttrInfo(info, "java.lang.Integer"));
    }

    @Override
    public void counter(MetricsInfo info, long value) {
        this.attrs.add(this.newAttrInfo(info, "java.lang.Long"));
    }

    String getAttrName(String name) {
        return this.curRecNo > 0 ? name + "." + this.curRecNo : name;
    }

    MBeanInfo get() {
        this.curRecNo = 0;
        for (MetricsRecordImpl rec : this.recs) {
            for (MetricsTag t : rec.tags()) {
                this.attrs.add(this.newAttrInfo("tag." + t.name(), t.description(), "java.lang.String"));
            }
            for (AbstractMetric m3 : rec.metrics()) {
                m3.visit(this);
            }
            ++this.curRecNo;
        }
        MetricsSystemImpl.LOG.debug("{}", (Object)this.attrs);
        MBeanAttributeInfo[] attrsArray = new MBeanAttributeInfo[this.attrs.size()];
        return new MBeanInfo(this.name, this.description, this.attrs.toArray(attrsArray), null, null, null);
    }
}

