/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import oadd.org.apache.hadoop.fs.impl.prefetch.BlockData;
import oadd.org.apache.hadoop.fs.impl.prefetch.BufferData;
import oadd.org.apache.hadoop.fs.impl.prefetch.Validate;

public final class FilePosition {
    private BlockData blockData;
    private BufferData data;
    private ByteBuffer buffer;
    private long bufferStartOffset;
    private long readStartOffset;
    private int numSingleByteReads;
    private int numBytesRead;
    private int numBufferReads;

    public FilePosition(long fileSize, int blockSize) {
        Validate.checkNotNegative(fileSize, "fileSize");
        if (fileSize == 0L) {
            Validate.checkNotNegative(blockSize, "blockSize");
        } else {
            Validate.checkPositiveInteger(blockSize, "blockSize");
        }
        this.blockData = new BlockData(fileSize, blockSize);
        this.invalidate();
    }

    public void setData(BufferData bufferData, long startOffset, long readOffset) {
        Validate.checkNotNull(bufferData, "bufferData");
        Validate.checkNotNegative(startOffset, "startOffset");
        Validate.checkNotNegative(readOffset, "readOffset");
        Validate.checkWithinRange(readOffset, "readOffset", startOffset, startOffset + (long)bufferData.getBuffer().limit());
        this.data = bufferData;
        this.buffer = bufferData.getBuffer().duplicate();
        this.bufferStartOffset = startOffset;
        this.readStartOffset = readOffset;
        this.setAbsolute(readOffset);
        this.resetReadStats();
    }

    public ByteBuffer buffer() {
        this.throwIfInvalidBuffer();
        return this.buffer;
    }

    public BufferData data() {
        this.throwIfInvalidBuffer();
        return this.data;
    }

    public long absolute() {
        this.throwIfInvalidBuffer();
        return this.bufferStartOffset + (long)this.relative();
    }

    public boolean setAbsolute(long pos) {
        if (this.isValid() && this.isWithinCurrentBuffer(pos)) {
            int relativePos = (int)(pos - this.bufferStartOffset);
            this.buffer.position(relativePos);
            return true;
        }
        return false;
    }

    public int relative() {
        this.throwIfInvalidBuffer();
        return this.buffer.position();
    }

    public boolean isWithinCurrentBuffer(long pos) {
        this.throwIfInvalidBuffer();
        long bufferEndOffset = this.bufferStartOffset + (long)this.buffer.limit();
        return pos >= this.bufferStartOffset && pos <= bufferEndOffset;
    }

    public int blockNumber() {
        this.throwIfInvalidBuffer();
        return this.blockData.getBlockNumber(this.bufferStartOffset);
    }

    public boolean isLastBlock() {
        return this.blockData.isLastBlock(this.blockNumber());
    }

    public boolean isValid() {
        return this.buffer != null;
    }

    public void invalidate() {
        this.buffer = null;
        this.bufferStartOffset = -1L;
        this.data = null;
    }

    public long bufferStartOffset() {
        this.throwIfInvalidBuffer();
        return this.bufferStartOffset;
    }

    public boolean bufferFullyRead() {
        this.throwIfInvalidBuffer();
        return this.bufferStartOffset == this.readStartOffset && this.relative() == this.buffer.limit() && this.numBytesRead == this.buffer.limit();
    }

    public void incrementBytesRead(int n) {
        this.numBytesRead += n;
        if (n == 1) {
            ++this.numSingleByteReads;
        } else {
            ++this.numBufferReads;
        }
    }

    public int numBytesRead() {
        return this.numBytesRead;
    }

    public int numSingleByteReads() {
        return this.numSingleByteReads;
    }

    public int numBufferReads() {
        return this.numBufferReads;
    }

    private void resetReadStats() {
        this.numBytesRead = 0;
        this.numSingleByteReads = 0;
        this.numBufferReads = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.buffer == null) {
            sb.append("currentBuffer = null");
        } else {
            int pos = this.buffer.position();
            int val = pos >= this.buffer.limit() ? -1 : (int)this.buffer.get(pos);
            String currentBufferState = String.format("%d at pos: %d, lim: %d", val, pos, this.buffer.limit());
            sb.append(String.format("block: %d, pos: %d (CBuf: %s)%n", this.blockNumber(), this.absolute(), currentBufferState));
            sb.append("\n");
        }
        return sb.toString();
    }

    private void throwIfInvalidBuffer() {
        Validate.checkState(this.buffer != null, "'buffer' must not be null", new Object[0]);
    }
}

