/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.zip.CRC32;
import oadd.org.apache.hadoop.fs.impl.prefetch.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferData {
    private static final Logger LOG = LoggerFactory.getLogger(BufferData.class);
    private final int blockNumber;
    private ByteBuffer buffer;
    private volatile State state;
    private Future<Void> action;
    private long checksum = 0L;

    public BufferData(int blockNumber, ByteBuffer buffer) {
        Validate.checkNotNegative(blockNumber, "blockNumber");
        Validate.checkNotNull(buffer, "buffer");
        this.blockNumber = blockNumber;
        this.buffer = buffer;
        this.state = State.BLANK;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public State getState() {
        return this.state;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public static long getChecksum(ByteBuffer buffer) {
        ByteBuffer tempBuffer = buffer.duplicate();
        tempBuffer.rewind();
        CRC32 crc32 = new CRC32();
        crc32.update(tempBuffer);
        return crc32.getValue();
    }

    public synchronized Future<Void> getActionFuture() {
        return this.action;
    }

    public synchronized void setPrefetch(Future<Void> actionFuture) {
        Validate.checkNotNull(actionFuture, "actionFuture");
        this.updateState(State.PREFETCHING, State.BLANK);
        this.action = actionFuture;
    }

    public synchronized void setCaching(Future<Void> actionFuture) {
        Validate.checkNotNull(actionFuture, "actionFuture");
        this.throwIfStateIncorrect(State.PREFETCHING, State.READY);
        this.state = State.CACHING;
        this.action = actionFuture;
    }

    public synchronized void setReady(State ... expectedCurrentState) {
        if (this.checksum != 0L) {
            throw new IllegalStateException("Checksum cannot be changed once set");
        }
        this.buffer = this.buffer.asReadOnlyBuffer();
        this.checksum = BufferData.getChecksum(this.buffer);
        this.buffer.rewind();
        this.updateState(State.READY, expectedCurrentState);
    }

    public synchronized void setDone() {
        if (this.checksum != 0L && BufferData.getChecksum(this.buffer) != this.checksum) {
            throw new IllegalStateException("checksum changed after setReady()");
        }
        this.state = State.DONE;
        this.action = null;
    }

    public synchronized void updateState(State newState, State ... expectedCurrentState) {
        Validate.checkNotNull((Object)newState, "newState");
        Validate.checkNotNull(expectedCurrentState, "expectedCurrentState");
        this.throwIfStateIncorrect(expectedCurrentState);
        this.state = newState;
    }

    public void throwIfStateIncorrect(State ... states) {
        Validate.checkNotNull(states, "states");
        if (this.stateEqualsOneOf(states)) {
            return;
        }
        ArrayList<String> statesStr = new ArrayList<String>();
        for (State s2 : states) {
            statesStr.add(s2.toString());
        }
        String message = String.format("Expected buffer state to be '%s' but found: %s", String.join((CharSequence)" or ", statesStr), this);
        throw new IllegalStateException(message);
    }

    public boolean stateEqualsOneOf(State ... states) {
        State currentState = this.state;
        for (State s2 : states) {
            if (currentState != s2) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("[%03d] id: %03d, %s: buf: %s, checksum: %d, future: %s", new Object[]{this.blockNumber, System.identityHashCode(this), this.state, this.getBufferStr(this.buffer), this.checksum, this.getFutureStr(this.action)});
    }

    private String getFutureStr(Future<Void> f) {
        if (f == null) {
            return "--";
        }
        return this.action.isDone() ? "done" : "not done";
    }

    private String getBufferStr(ByteBuffer buf) {
        if (buf == null) {
            return "--";
        }
        return String.format("(id = %d, pos = %d, lim = %d)", System.identityHashCode(buf), buf.position(), buf.limit());
    }

    public static enum State {
        UNKNOWN,
        BLANK,
        PREFETCHING,
        CACHING,
        READY,
        DONE;

    }
}

