/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.impl;

import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.store.LogExactlyOnce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSBuilderSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FSBuilderSupport.class);
    public static final LogExactlyOnce LOG_PARSE_ERROR = new LogExactlyOnce(LOG);
    private final Configuration options;

    public FSBuilderSupport(Configuration options) {
        this.options = options;
    }

    public Configuration getOptions() {
        return this.options;
    }

    public long getPositiveLong(String key, long defVal) {
        long l = this.getLong(key, defVal);
        if (l < 0L) {
            LOG.debug("The option {} has a negative value {}, replacing with the default {}", key, l, defVal);
            l = defVal;
        }
        return l;
    }

    public long getLong(String key, long defVal) {
        String v = this.options.getTrimmed(key, "");
        if (v.isEmpty()) {
            return defVal;
        }
        try {
            return this.options.getLong(key, defVal);
        }
        catch (NumberFormatException e) {
            String msg = String.format("The option %s value \"%s\" is not a long integer; using the default value %s", key, v, defVal);
            LOG_PARSE_ERROR.warn(msg, new Object[0]);
            LOG.debug("{}", (Object)msg, (Object)e);
            return defVal;
        }
    }
}

