/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import oadd.org.apache.hadoop.fs.MultipartUploader;
import oadd.org.apache.hadoop.fs.PartHandle;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.UploadHandle;
import oadd.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public abstract class AbstractMultipartUploader
implements MultipartUploader {
    private final Path basePath;

    protected AbstractMultipartUploader(Path basePath) {
        this.basePath = Objects.requireNonNull(basePath, "null path");
    }

    @Override
    public void close() throws IOException {
    }

    protected Path getBasePath() {
        return this.basePath;
    }

    protected void checkPath(Path path) {
        Objects.requireNonNull(path, "null path");
        Preconditions.checkArgument(path.toString().startsWith(this.basePath.toString()), "Path %s is not under %s", (Object)path, (Object)this.basePath);
    }

    protected void checkUploadId(byte[] uploadId) throws IllegalArgumentException {
        Preconditions.checkArgument(uploadId != null, "null uploadId");
        Preconditions.checkArgument(uploadId.length > 0, "Empty UploadId is not valid");
    }

    protected void checkPartHandles(Map<Integer, PartHandle> partHandles) {
        Preconditions.checkArgument(!partHandles.isEmpty(), "Empty upload");
        partHandles.keySet().stream().forEach(key -> Preconditions.checkArgument(key > 0, "Invalid part handle index %s", key));
    }

    protected void checkPutArguments(Path filePath, InputStream inputStream, int partNumber, UploadHandle uploadId, long lengthInBytes) throws IllegalArgumentException {
        this.checkPath(filePath);
        Preconditions.checkArgument(inputStream != null, "null inputStream");
        Preconditions.checkArgument(partNumber > 0, "Invalid part number: %d", partNumber);
        Preconditions.checkArgument(uploadId != null, "null uploadId");
        Preconditions.checkArgument(lengthInBytes >= 0L, "Invalid part length: %d", lengthInBytes);
    }

    @Override
    public CompletableFuture<Integer> abortUploadsUnderPath(Path path) throws IOException {
        this.checkPath(path);
        CompletableFuture<Integer> f = new CompletableFuture<Integer>();
        f.complete(-1);
        return f;
    }
}

