/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.FSBuilder;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PathHandle;
import oadd.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class AbstractFSBuilderImpl<S, B extends FSBuilder<S, B>>
implements FSBuilder<S, B> {
    public static final String UNKNOWN_MANDATORY_KEY = "Unknown mandatory key";
    @VisibleForTesting
    static final String E_BOTH_A_PATH_AND_A_PATH_HANDLE = "Both a path and a pathHandle has been provided to the constructor";
    private final Optional<Path> optionalPath;
    private final Optional<PathHandle> optionalPathHandle;
    private final Configuration options = new Configuration(false);
    private final Set<String> mandatoryKeys = new HashSet<String>();
    private final Set<String> optionalKeys = new HashSet<String>();

    protected AbstractFSBuilderImpl(@Nonnull Optional<Path> optionalPath, @Nonnull Optional<PathHandle> optionalPathHandle) {
        Preconditions.checkArgument(!Preconditions.checkNotNull(optionalPath).isPresent() || !Preconditions.checkNotNull(optionalPathHandle).isPresent(), E_BOTH_A_PATH_AND_A_PATH_HANDLE);
        this.optionalPath = optionalPath;
        this.optionalPathHandle = optionalPathHandle;
    }

    protected AbstractFSBuilderImpl(@Nonnull Path path) {
        this(Optional.of(path), Optional.empty());
    }

    protected AbstractFSBuilderImpl(@Nonnull PathHandle pathHandle) {
        this(Optional.empty(), Optional.of(pathHandle));
    }

    public B getThisBuilder() {
        return (B)this;
    }

    public Optional<Path> getOptionalPath() {
        return this.optionalPath;
    }

    public Path getPath() {
        return this.optionalPath.get();
    }

    public Optional<PathHandle> getOptionalPathHandle() {
        return this.optionalPathHandle;
    }

    public PathHandle getPathHandle() {
        return this.optionalPathHandle.get();
    }

    @Override
    public B opt(@Nonnull String key, @Nonnull String value) {
        this.mandatoryKeys.remove(key);
        this.optionalKeys.add(key);
        this.options.set(key, value);
        return this.getThisBuilder();
    }

    @Override
    public B opt(@Nonnull String key, boolean value) {
        return this.opt(key, Boolean.toString(value));
    }

    @Override
    public B opt(@Nonnull String key, int value) {
        return this.optLong(key, value);
    }

    @Override
    public B opt(@Nonnull String key, long value) {
        return this.optLong(key, value);
    }

    @Override
    public B optLong(@Nonnull String key, long value) {
        return this.opt(key, Long.toString(value));
    }

    @Override
    public B opt(@Nonnull String key, float value) {
        return this.optLong(key, (long)value);
    }

    @Override
    public B opt(@Nonnull String key, double value) {
        return this.optLong(key, (long)value);
    }

    @Override
    public B optDouble(@Nonnull String key, double value) {
        return this.opt(key, Double.toString(value));
    }

    @Override
    public B opt(@Nonnull String key, String ... values) {
        this.mandatoryKeys.remove(key);
        this.optionalKeys.add(key);
        this.options.setStrings(key, values);
        return this.getThisBuilder();
    }

    @Override
    public B must(@Nonnull String key, @Nonnull String value) {
        this.mandatoryKeys.add(key);
        this.options.set(key, value);
        return this.getThisBuilder();
    }

    @Override
    public B must(@Nonnull String key, boolean value) {
        return this.must(key, Boolean.toString(value));
    }

    @Override
    public B mustLong(@Nonnull String key, long value) {
        return this.must(key, Long.toString(value));
    }

    @Override
    public B mustDouble(@Nonnull String key, double value) {
        return this.must(key, Double.toString(value));
    }

    @Override
    public B must(@Nonnull String key, int value) {
        return this.mustLong(key, value);
    }

    @Override
    public B must(@Nonnull String key, long value) {
        return this.mustLong(key, value);
    }

    @Override
    public B must(@Nonnull String key, float value) {
        return this.mustLong(key, (long)value);
    }

    @Override
    public B must(@Nonnull String key, double value) {
        return this.mustLong(key, (long)value);
    }

    @Override
    public B must(@Nonnull String key, String ... values) {
        this.mandatoryKeys.add(key);
        this.optionalKeys.remove(key);
        this.options.setStrings(key, values);
        return this.getThisBuilder();
    }

    public Configuration getOptions() {
        return this.options;
    }

    public Set<String> getMandatoryKeys() {
        return Collections.unmodifiableSet(this.mandatoryKeys);
    }

    public Set<String> getOptionalKeys() {
        return Collections.unmodifiableSet(this.optionalKeys);
    }

    protected void rejectUnknownMandatoryKeys(Collection<String> knownKeys, String extraErrorText) throws IllegalArgumentException {
        AbstractFSBuilderImpl.rejectUnknownMandatoryKeys(this.mandatoryKeys, knownKeys, extraErrorText);
    }

    public static void rejectUnknownMandatoryKeys(Set<String> mandatory, Collection<String> knownKeys, String extraErrorText) throws IllegalArgumentException {
        String eText = extraErrorText.isEmpty() ? "" : extraErrorText + " ";
        mandatory.forEach(key -> Preconditions.checkArgument(knownKeys.contains(key), "Unknown mandatory key %s\"%s\"", (Object)eText, key));
    }
}

