/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.FSDataInputStream;
import oadd.org.apache.hadoop.fs.FSDataOutputStream;
import oadd.org.apache.hadoop.fs.FileStatus;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PositionedReadable;
import oadd.org.apache.hadoop.fs.Seekable;
import oadd.org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import oadd.org.apache.hadoop.fs.permission.FsPermission;
import oadd.org.apache.hadoop.util.Progressable;

abstract class AbstractHttpFileSystem
extends FileSystem {
    private static final long DEFAULT_BLOCK_SIZE = 4096L;
    private static final Path WORKING_DIR = new Path("/");
    private URI uri;

    AbstractHttpFileSystem() {
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.uri = name;
    }

    @Override
    public abstract String getScheme();

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        URI pathUri = this.makeQualified(path).toUri();
        URLConnection conn = pathUri.toURL().openConnection();
        InputStream in = conn.getInputStream();
        return new FSDataInputStream(new HttpDataInputStream(in));
    }

    @Override
    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i1, long l, Progressable progressable) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FSDataOutputStream append(Path path, int i, Progressable progressable) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rename(Path path, Path path1) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete(Path path, boolean b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWorkingDirectory(Path path) {
    }

    @Override
    public Path getWorkingDirectory() {
        return WORKING_DIR;
    }

    @Override
    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        return false;
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        return new FileStatus(-1L, false, 1, 4096L, 0L, this.makeQualified(path));
    }

    @Override
    public boolean hasPathCapability(Path path, String capability) throws IOException {
        switch (PathCapabilitiesSupport.validatePathCapabilityArgs(path, capability)) {
            case "fs.capability.paths.read-only-connector": {
                return true;
            }
        }
        return super.hasPathCapability(path, capability);
    }

    private static class HttpDataInputStream
    extends FilterInputStream
    implements Seekable,
    PositionedReadable {
        HttpDataInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(long position, byte[] buffer) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seek(long pos) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getPos() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

