/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.util.Arrays;
import java.util.List;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.StorageType;
import oadd.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class QuotaUsage {
    private long fileAndDirectoryCount;
    private long quota;
    private long spaceConsumed;
    private long spaceQuota;
    private long[] typeConsumed;
    private long[] typeQuota;
    protected static final String QUOTA_STRING_FORMAT = "%12s %15s ";
    protected static final String SPACE_QUOTA_STRING_FORMAT = "%15s %15s ";
    protected static final String[] QUOTA_HEADER_FIELDS = new String[]{"QUOTA", "REM_QUOTA", "SPACE_QUOTA", "REM_SPACE_QUOTA"};
    protected static final String QUOTA_HEADER = String.format("%12s %15s %15s %15s ", QUOTA_HEADER_FIELDS);
    private static final String STORAGE_TYPE_SUMMARY_FORMAT = "%13s %17s ";
    private static final String QUOTA_NONE = "none";
    private static final String QUOTA_INF = "inf";

    protected QuotaUsage() {
    }

    protected QuotaUsage(Builder builder) {
        this.fileAndDirectoryCount = builder.fileAndDirectoryCount;
        this.quota = builder.quota;
        this.spaceConsumed = builder.spaceConsumed;
        this.spaceQuota = builder.spaceQuota;
        this.typeConsumed = builder.typeConsumed;
        this.typeQuota = builder.typeQuota;
    }

    protected void setQuota(long quota) {
        this.quota = quota;
    }

    protected void setSpaceConsumed(long spaceConsumed) {
        this.spaceConsumed = spaceConsumed;
    }

    protected void setSpaceQuota(long spaceQuota) {
        this.spaceQuota = spaceQuota;
    }

    public long getFileAndDirectoryCount() {
        return this.fileAndDirectoryCount;
    }

    public long getQuota() {
        return this.quota;
    }

    public long getSpaceConsumed() {
        return this.spaceConsumed;
    }

    public long getSpaceQuota() {
        return this.spaceQuota;
    }

    public long getTypeQuota(StorageType type) {
        return this.typeQuota != null ? this.typeQuota[type.ordinal()] : -1L;
    }

    public long getTypeConsumed(StorageType type) {
        return this.typeConsumed != null ? this.typeConsumed[type.ordinal()] : 0L;
    }

    public boolean isTypeQuotaSet() {
        if (this.typeQuota != null) {
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                if (this.typeQuota[t.ordinal()] <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTypeConsumedAvailable() {
        if (this.typeConsumed != null) {
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                if (this.typeConsumed[t.ordinal()] <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.fileAndDirectoryCount ^ this.fileAndDirectoryCount >>> 32);
        result = 31 * result + (int)(this.quota ^ this.quota >>> 32);
        result = 31 * result + (int)(this.spaceConsumed ^ this.spaceConsumed >>> 32);
        result = 31 * result + (int)(this.spaceQuota ^ this.spaceQuota >>> 32);
        result = 31 * result + Arrays.hashCode(this.typeConsumed);
        result = 31 * result + Arrays.hashCode(this.typeQuota);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuotaUsage)) {
            return false;
        }
        QuotaUsage other = (QuotaUsage)obj;
        if (this.fileAndDirectoryCount != other.fileAndDirectoryCount) {
            return false;
        }
        if (this.quota != other.quota) {
            return false;
        }
        if (this.spaceConsumed != other.spaceConsumed) {
            return false;
        }
        if (this.spaceQuota != other.spaceQuota) {
            return false;
        }
        if (!Arrays.equals(this.typeConsumed, other.typeConsumed)) {
            return false;
        }
        return Arrays.equals(this.typeQuota, other.typeQuota);
    }

    public static String getHeader() {
        return QUOTA_HEADER;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean hOption) {
        return this.toString(hOption, false, null);
    }

    public String toString(boolean hOption, boolean tOption, List<StorageType> types) {
        if (tOption) {
            return this.getTypesQuotaUsage(hOption, types);
        }
        return this.getQuotaUsage(hOption);
    }

    protected String getQuotaUsage(boolean hOption) {
        String quotaStr = QUOTA_NONE;
        String quotaRem = QUOTA_INF;
        String spaceQuotaStr = QUOTA_NONE;
        String spaceQuotaRem = QUOTA_INF;
        if (this.quota > 0L) {
            quotaStr = this.formatSize(this.quota, hOption);
            quotaRem = this.formatSize(this.quota - this.fileAndDirectoryCount, hOption);
        }
        if (this.spaceQuota >= 0L) {
            spaceQuotaStr = this.formatSize(this.spaceQuota, hOption);
            spaceQuotaRem = this.formatSize(this.spaceQuota - this.spaceConsumed, hOption);
        }
        return String.format("%12s %15s %15s %15s ", quotaStr, quotaRem, spaceQuotaStr, spaceQuotaRem);
    }

    protected String getTypesQuotaUsage(boolean hOption, List<StorageType> types) {
        StringBuilder content = new StringBuilder();
        for (StorageType st : types) {
            long typeQuota = this.getTypeQuota(st);
            long typeConsumed = this.getTypeConsumed(st);
            String quotaStr = QUOTA_NONE;
            String quotaRem = QUOTA_INF;
            if (typeQuota >= 0L) {
                quotaStr = this.formatSize(typeQuota, hOption);
                quotaRem = this.formatSize(typeQuota - typeConsumed, hOption);
            }
            content.append(String.format(STORAGE_TYPE_SUMMARY_FORMAT, quotaStr, quotaRem));
        }
        return content.toString();
    }

    public static String getStorageTypeHeader(List<StorageType> storageTypes) {
        StringBuilder header = new StringBuilder();
        for (StorageType st : storageTypes) {
            String storageName = st.toString();
            header.append(String.format(STORAGE_TYPE_SUMMARY_FORMAT, storageName + "_QUOTA", "REM_" + storageName + "_QUOTA"));
        }
        return header.toString();
    }

    private String formatSize(long size, boolean humanReadable) {
        return humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    public static class Builder {
        private long fileAndDirectoryCount;
        private long quota = -1L;
        private long spaceConsumed;
        private long spaceQuota = -1L;
        private long[] typeConsumed = new long[StorageType.values().length];
        private long[] typeQuota = new long[StorageType.values().length];

        public Builder() {
            Arrays.fill(this.typeQuota, -1L);
        }

        public Builder fileAndDirectoryCount(long count) {
            this.fileAndDirectoryCount = count;
            return this;
        }

        public Builder quota(long quota) {
            this.quota = quota;
            return this;
        }

        public Builder spaceConsumed(long spaceConsumed) {
            this.spaceConsumed = spaceConsumed;
            return this;
        }

        public Builder spaceQuota(long spaceQuota) {
            this.spaceQuota = spaceQuota;
            return this;
        }

        public Builder typeConsumed(long[] typeConsumed) {
            System.arraycopy(typeConsumed, 0, this.typeConsumed, 0, typeConsumed.length);
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            this.typeQuota[type.ordinal()] = quota;
            return this;
        }

        public Builder typeConsumed(StorageType type, long consumed) {
            this.typeConsumed[type.ordinal()] = consumed;
            return this;
        }

        public Builder typeQuota(long[] typeQuota) {
            System.arraycopy(typeQuota, 0, this.typeQuota, 0, typeQuota.length);
            return this;
        }

        public QuotaUsage build() {
            return new QuotaUsage(this);
        }
    }
}

