/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.IOException;
import javax.annotation.Nonnull;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public interface FSBuilder<S, B extends FSBuilder<S, B>> {
    public B opt(@Nonnull String var1, @Nonnull String var2);

    default public B opt(@Nonnull String key, boolean value) {
        return this.opt(key, Boolean.toString(value));
    }

    default public B opt(@Nonnull String key, int value) {
        return this.optLong(key, value);
    }

    @Deprecated
    default public B opt(@Nonnull String key, float value) {
        return this.optLong(key, (long)value);
    }

    default public B opt(@Nonnull String key, long value) {
        return this.optLong(key, value);
    }

    @Deprecated
    default public B opt(@Nonnull String key, double value) {
        return this.optLong(key, (long)value);
    }

    public B opt(@Nonnull String var1, String ... var2);

    default public B optLong(@Nonnull String key, long value) {
        return this.opt(key, Long.toString(value));
    }

    default public B optDouble(@Nonnull String key, double value) {
        return this.opt(key, Double.toString(value));
    }

    public B must(@Nonnull String var1, @Nonnull String var2);

    default public B must(@Nonnull String key, boolean value) {
        return this.must(key, Boolean.toString(value));
    }

    default public B must(@Nonnull String key, int value) {
        return this.mustLong(key, value);
    }

    @Deprecated
    default public B must(@Nonnull String key, float value) {
        return this.mustLong(key, (long)value);
    }

    @Deprecated
    default public B must(@Nonnull String key, long value) {
        return this.mustLong(key, value);
    }

    @Deprecated
    default public B must(@Nonnull String key, double value) {
        return this.mustLong(key, (long)value);
    }

    public B must(@Nonnull String var1, String ... var2);

    default public B mustLong(@Nonnull String key, long value) {
        return this.must(key, Long.toString(value));
    }

    default public B mustDouble(@Nonnull String key, double value) {
        return this.must(key, Double.toString(value));
    }

    public S build() throws IllegalArgumentException, UnsupportedOperationException, IOException;
}

