/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt1Holder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class UInt1WriterImpl
extends AbstractFieldWriter {
    private final UInt1Vector.Mutator mutator;
    final UInt1Vector vector;

    public UInt1WriterImpl(UInt1Vector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(UInt1Holder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableUInt1Holder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeUInt1(byte value) {
        this.mutator.setSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

