/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.time.LocalDateTime;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.TimeStampVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.TimeStampWriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TimeStampWriter;

public class TimeStampReaderImpl
extends AbstractFieldReader {
    private final TimeStampVector vector;

    public TimeStampReaderImpl(TimeStampVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(TimeStampWriter writer) {
        TimeStampWriterImpl impl = (TimeStampWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        TimeStampWriterImpl impl = (TimeStampWriterImpl)writer.timeStamp(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(TimeStampHolder h2) {
        this.vector.getAccessor().get(this.idx(), h2);
    }

    @Override
    public void read(ValueHolder h2) {
        if (h2 instanceof TimeStampHolder) {
            this.read((TimeStampHolder)h2);
        } else {
            this.read((NullableTimeStampHolder)h2);
        }
    }

    @Override
    public void read(NullableTimeStampHolder h2) {
        this.vector.getAccessor().get(this.idx(), h2);
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

