/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.Iterator;
import java.util.Map;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class SingleMapReaderImpl
extends AbstractFieldReader {
    private final MapVector vector;
    private final Map<String, FieldReader> fields = Maps.newHashMap();

    public SingleMapReaderImpl(MapVector vector) {
        this.vector = vector;
    }

    private void setChildrenPosition(int index) {
        for (FieldReader r : this.fields.values()) {
            r.setPosition(index);
        }
    }

    @Override
    public FieldReader reader(String name) {
        FieldReader reader = this.fields.get(name);
        if (reader == null) {
            ValueVector child = this.vector.getChild(name);
            reader = child == null ? NullReader.INSTANCE : child.getReader();
            this.fields.put(name, reader);
            reader.setPosition(this.idx());
        }
        return reader;
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        for (FieldReader r : this.fields.values()) {
            r.setPosition(index);
        }
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public Iterator<String> iterator() {
        return this.vector.fieldNameIterator();
    }

    @Override
    public void copyAsValue(BaseWriter.MapWriter writer) {
        SingleMapWriter impl = (SingleMapWriter)writer;
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        SingleMapWriter impl = (SingleMapWriter)writer.map(name);
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }
}

