/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.DictWriter;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.TupleWriter;
import oadd.org.apache.drill.exec.vector.accessor.VariantWriter;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.reader.MapReader;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTupleWriter
implements TupleWriter,
WriterEvents {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractTupleWriter.class);
    protected final TupleMetadata tupleSchema;
    protected final List<AbstractObjectWriter> writers;
    protected ColumnWriterIndex vectorIndex;
    protected ColumnWriterIndex childIndex;
    protected TupleWriterListener listener;
    protected WriterEvents.State state = WriterEvents.State.IDLE;

    protected AbstractTupleWriter(TupleMetadata schema, List<AbstractObjectWriter> writers) {
        this.tupleSchema = schema;
        this.writers = writers;
    }

    protected AbstractTupleWriter(TupleMetadata schema) {
        this(schema, new ArrayList<AbstractObjectWriter>());
    }

    @Override
    public ObjectType type() {
        return ObjectType.TUPLE;
    }

    protected void bindIndex(ColumnWriterIndex index, ColumnWriterIndex childIndex) {
        this.vectorIndex = index;
        this.childIndex = childIndex;
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().bindIndex(childIndex);
        }
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.bindIndex(index, index);
    }

    @Override
    public int rowStartIndex() {
        return this.vectorIndex.rowStartIndex();
    }

    public int addColumnWriter(AbstractObjectWriter colWriter) {
        assert (this.writers.size() == this.tupleSchema.size());
        int colIndex = this.tupleSchema.addColumn(colWriter.schema());
        this.writers.add(colWriter);
        colWriter.events().bindIndex(this.childIndex);
        if (this.state != WriterEvents.State.IDLE) {
            colWriter.events().startWrite();
            if (this.state == WriterEvents.State.IN_ROW) {
                colWriter.events().startRow();
            }
        }
        return colIndex;
    }

    @Override
    public boolean isProjected(String columnName) {
        return this.listener == null || this.listener.isProjected(columnName);
    }

    @Override
    public int addColumn(ColumnMetadata column) {
        this.verifyAddColumn(column.name());
        return this.addColumnWriter((AbstractObjectWriter)this.listener.addColumn((TupleWriter)this, column));
    }

    @Override
    public int addColumn(MaterializedField field) {
        this.verifyAddColumn(field.getName());
        return this.addColumnWriter((AbstractObjectWriter)this.listener.addColumn((TupleWriter)this, field));
    }

    private void verifyAddColumn(String colName) {
        if (this.listener == null) {
            throw new UnsupportedOperationException("addColumn");
        }
        if (this.tupleSchema().column(colName) != null) {
            throw UserException.validationError().message("Duplicate column name: %s", colName).build(logger);
        }
    }

    @Override
    public TupleMetadata tupleSchema() {
        return this.tupleSchema;
    }

    @Override
    public int size() {
        return this.tupleSchema().size();
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public void setNull() {
        throw new IllegalStateException("Not nullable");
    }

    @Override
    public void startWrite() {
        assert (this.state == WriterEvents.State.IDLE);
        this.state = WriterEvents.State.IN_WRITE;
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().startWrite();
        }
    }

    @Override
    public void startRow() {
        assert (this.state == WriterEvents.State.IN_WRITE);
        this.state = WriterEvents.State.IN_ROW;
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().startRow();
        }
    }

    @Override
    public void endArrayValue() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().endArrayValue();
        }
    }

    @Override
    public void restartRow() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().restartRow();
        }
    }

    @Override
    public void saveRow() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().saveRow();
        }
        this.state = WriterEvents.State.IN_WRITE;
    }

    @Override
    public void preRollover() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().preRollover();
        }
    }

    @Override
    public void postRollover() {
        assert (this.state == WriterEvents.State.IN_ROW);
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().postRollover();
        }
    }

    @Override
    public void endWrite() {
        assert (this.state != WriterEvents.State.IDLE);
        for (AbstractObjectWriter writer : this.writers) {
            writer.events().endWrite();
        }
        this.state = WriterEvents.State.IDLE;
    }

    @Override
    public void copy(ColumnReader from) {
        MapReader source = (MapReader)from;
        for (int i = 0; i < this.writers.size(); ++i) {
            this.writers.get(i).writer().copy(source.column(i).reader());
        }
    }

    @Override
    public ObjectWriter column(int colIndex) {
        return this.writers.get(colIndex);
    }

    @Override
    public ObjectWriter column(String colName) {
        int index = this.tupleSchema.index(colName);
        if (index == -1) {
            throw new TupleWriter.UndefinedColumnException(colName);
        }
        return this.writers.get(index);
    }

    @Override
    public void set(int colIndex, Object value) {
        this.column(colIndex).setObject(value);
    }

    @Override
    public void setObject(Object value) {
        Object[] values = (Object[])value;
        if (values.length != this.tupleSchema.size()) {
            if (this.schema() == null) {
                throw new IllegalArgumentException(String.format("Row has %d columns, but value array has  %d values.", this.tupleSchema.size(), values.length));
            }
            throw new IllegalArgumentException(String.format("Map %s has %d columns, but value array has  %d values.", this.schema().name(), this.tupleSchema.size(), values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Override
    public ScalarWriter scalar(int colIndex) {
        return this.column(colIndex).scalar();
    }

    @Override
    public ScalarWriter scalar(String colName) {
        return this.column(colName).scalar();
    }

    @Override
    public TupleWriter tuple(int colIndex) {
        return this.column(colIndex).tuple();
    }

    @Override
    public TupleWriter tuple(String colName) {
        return this.column(colName).tuple();
    }

    @Override
    public ArrayWriter array(int colIndex) {
        return this.column(colIndex).array();
    }

    @Override
    public ArrayWriter array(String colName) {
        return this.column(colName).array();
    }

    @Override
    public VariantWriter variant(int colIndex) {
        return this.column(colIndex).variant();
    }

    @Override
    public VariantWriter variant(String colName) {
        return this.column(colName).variant();
    }

    @Override
    public DictWriter dict(int colIndex) {
        return this.column(colIndex).dict();
    }

    @Override
    public DictWriter dict(String colName) {
        return this.column(colName).dict();
    }

    @Override
    public ObjectType type(int colIndex) {
        return this.column(colIndex).type();
    }

    @Override
    public ObjectType type(String colName) {
        return this.column(colName).type();
    }

    @Override
    public boolean isProjected() {
        return true;
    }

    @Override
    public int lastWriteIndex() {
        return this.vectorIndex.vectorIndex();
    }

    @Override
    public int writeIndex() {
        return this.vectorIndex.vectorIndex();
    }

    public void bindListener(TupleWriterListener listener) {
        this.listener = listener;
    }

    public TupleWriterListener listener() {
        return this.listener;
    }

    @Override
    public void bindListener(WriterEvents.ColumnWriterListener listener) {
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("vectorIndex", this.vectorIndex).attribute("state", (Object)this.state).attributeArray("writers");
        for (int i = 0; i < this.writers.size(); ++i) {
            format.element(i);
            this.writers.get(i).dump(format);
        }
        format.endArray().endObject();
    }

    public static interface TupleWriterListener {
        public ObjectWriter addColumn(TupleWriter var1, ColumnMetadata var2);

        public ObjectWriter addColumn(TupleWriter var1, MaterializedField var2);

        public boolean isProjected(String var1);
    }

    static class MemberWriterIndex
    implements ColumnWriterIndex {
        private final ColumnWriterIndex baseIndex;

        MemberWriterIndex(ColumnWriterIndex baseIndex) {
            this.baseIndex = baseIndex;
        }

        @Override
        public int rowStartIndex() {
            return this.baseIndex.rowStartIndex();
        }

        @Override
        public int vectorIndex() {
            return this.baseIndex.vectorIndex();
        }

        @Override
        public void nextElement() {
        }

        @Override
        public void prevElement() {
        }

        @Override
        public void rollover() {
        }

        @Override
        public ColumnWriterIndex outerIndex() {
            return this.baseIndex.outerIndex();
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " baseIndex = " + this.baseIndex.toString() + "]";
        }
    }

    public static class TupleObjectWriter
    extends AbstractObjectWriter {
        protected final AbstractTupleWriter tupleWriter;

        public TupleObjectWriter(AbstractTupleWriter tupleWriter) {
            this.tupleWriter = tupleWriter;
        }

        @Override
        public ColumnWriter writer() {
            return this.tupleWriter;
        }

        @Override
        public TupleWriter tuple() {
            return this.tupleWriter;
        }

        @Override
        public WriterEvents events() {
            return this.tupleWriter;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("tupleWriter");
            this.tupleWriter.dump(format);
            format.endObject();
        }
    }
}

