/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util.filereader;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Stopwatch;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.hadoop.fs.ByteBufferReadable;
import oadd.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectBufInputStream
extends FilterInputStream {
    private static final Logger logger = LoggerFactory.getLogger(DirectBufInputStream.class);
    protected boolean enableHints = true;
    protected String streamId;
    protected BufferAllocator allocator;
    protected final long totalByteSize;
    protected final boolean enforceTotalByteSize;
    protected final long startOffset;

    public DirectBufInputStream(InputStream in, BufferAllocator allocator, String id, long startOffset, long totalByteSize, boolean enforceTotalByteSize, boolean enableHints) {
        super(in);
        Preconditions.checkArgument(startOffset >= 0L);
        Preconditions.checkArgument(totalByteSize >= 0L);
        this.streamId = id;
        this.allocator = allocator;
        this.startOffset = startOffset;
        this.totalByteSize = totalByteSize;
        this.enforceTotalByteSize = enforceTotalByteSize;
        this.enableHints = enableHints;
    }

    public void init() throws IOException, UnsupportedOperationException {
        this.checkStreamSupportsByteBuffer();
        if (this.enableHints) {
            DirectBufInputStream.fadviseIfAvailable(this.getInputStream(), this.startOffset, this.totalByteSize);
        }
        this.getInputStream().seek(this.startOffset);
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    public synchronized int read(DrillBuf buf, int off, int len) throws IOException {
        int bytesRead;
        buf.clear();
        ByteBuffer directBuffer = buf.nioBuffer(0, len);
        SeekableInputStream seekableInputStream = HadoopStreams.wrap((FSDataInputStream)this.getInputStream());
        for (int lengthLeftToRead = len; lengthLeftToRead > 0; lengthLeftToRead -= bytesRead) {
            if (logger.isTraceEnabled()) {
                logger.trace("PERF: Disk read start. {}, StartOffset: {}, TotalByteSize: {}", this.streamId, this.startOffset, this.totalByteSize);
            }
            Stopwatch timer = Stopwatch.createStarted();
            bytesRead = seekableInputStream.read(directBuffer);
            if (bytesRead >= 0) continue;
            return bytesRead;
        }
        buf.writerIndex(len);
        return len;
    }

    public synchronized DrillBuf getNext(int bytes) throws IOException {
        DrillBuf b = this.allocator.buffer(bytes);
        int bytesRead = -1;
        try {
            bytesRead = this.read(b, 0, bytes);
        }
        catch (IOException e) {
            b.release();
            throw e;
        }
        if (bytesRead < 0) {
            b.release();
            return null;
        }
        return b;
    }

    public long getPos() throws IOException {
        return this.getInputStream().getPos();
    }

    public boolean hasRemainder() throws IOException {
        return this.getPos() < this.startOffset + this.totalByteSize;
    }

    protected FSDataInputStream getInputStream() throws IOException {
        this.checkInputStreamState();
        return (FSDataInputStream)this.in;
    }

    protected void checkInputStreamState() throws IOException {
        if (this.in == null) {
            throw new IOException("Input stream is closed.");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        InputStream inp = this.in;
        if (inp != null) {
            this.in = null;
            inp.close();
        }
    }

    protected void checkStreamSupportsByteBuffer() throws UnsupportedOperationException {
        if (!(this.in instanceof ByteBufferReadable)) {
            throw new UnsupportedOperationException("The input stream is not ByteBuffer readable.");
        }
    }

    protected static void fadviseIfAvailable(FSDataInputStream inputStream, long off, long n) {
        Method readAhead;
        Class<?> adviceType;
        try {
            adviceType = Class.forName("oadd.org.apache.hadoop.fs.FSDataInputStream$FadviseType");
        }
        catch (ClassNotFoundException e) {
            logger.info("Unable to call fadvise due to: {}", (Object)e.toString());
            Object readAhead2 = null;
            return;
        }
        try {
            Class<?> inputStreamClass = inputStream.getClass();
            readAhead = inputStreamClass.getMethod("adviseFile", adviceType, Long.TYPE, Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            logger.info("Unable to call fadvise due to: {}", (Object)e.toString());
            Object readAhead3 = null;
            return;
        }
        if (readAhead != null) {
            ?[] adviceTypeValues = adviceType.getEnumConstants();
            for (int idx = 0; idx < adviceTypeValues.length; ++idx) {
                if (!adviceTypeValues[idx].toString().contains("SEQUENTIAL")) continue;
                try {
                    readAhead.invoke((Object)inputStream, adviceTypeValues[idx], off, n);
                }
                catch (IllegalAccessException e) {
                    logger.info("Unable to call fadvise due to: {}", (Object)e.toString());
                }
                catch (InvocationTargetException e) {
                    logger.info("Unable to call fadvise due to: {}", (Object)e.toString());
                }
                break;
            }
        }
    }
}

