/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oadd.com.google.common.base.Preconditions;

public final class ExecutorServiceUtil {
    public static <T> Future<T> submit(ExecutorService service, Callable<T> callable) {
        CallableTaskWrapper<T> wrapper = new CallableTaskWrapper<T>(callable);
        wrapper.setFuture(service.submit(wrapper));
        return wrapper;
    }

    private ExecutorServiceUtil() {
    }

    public static final class CallableTaskWrapper<T>
    implements Callable<T>,
    Future<T> {
        private final Callable<T> callableTask;
        private volatile Future<T> future;
        private volatile STATE state = STATE.NOT_RUNNING;
        private final Object monitor = new Object();

        public CallableTaskWrapper(Callable<T> callableTask) {
            this.callableTask = callableTask;
            Preconditions.checkNotNull(this.callableTask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            try {
                this.state = STATE.RUNNING;
                T t = this.callableTask.call();
                return t;
            }
            finally {
                this.state = STATE.DONE;
                if (this.isCancelled()) {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.monitor.notifyAll();
                    }
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                boolean bl = this.future.cancel(mayInterruptIfRunning);
                return bl;
            }
            finally {
                if (mayInterruptIfRunning) {
                    this.waitTillDone();
                }
            }
        }

        @Override
        public boolean isCancelled() {
            return this.future != null && this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.state == STATE.DONE;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit);
        }

        public void setFuture(Future<T> feature) {
            this.future = feature;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitTillDone() {
            if (this.isRunning()) {
                boolean interrupted = Thread.interrupted();
                try {
                    Object object = this.monitor;
                    synchronized (object) {
                        while (this.isRunning()) {
                            try {
                                this.monitor.wait();
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                        }
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        private boolean isRunning() {
            return this.state == STATE.RUNNING;
        }

        private static enum STATE {
            NOT_RUNNING,
            RUNNING,
            DONE;

        }
    }
}

