/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SecureRandomStringUtils {
    private static SecureRandom RANDOM_INSTANCE;

    private static SecureRandom random() {
        if (RANDOM_INSTANCE != null) {
            return RANDOM_INSTANCE;
        }
        try {
            RANDOM_INSTANCE = SecureRandom.getInstanceStrong();
            return RANDOM_INSTANCE;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot create SecureRandom.getInstanceStrong()", e);
        }
    }

    public static String random(int count) {
        return SecureRandomStringUtils.random(count, false, false);
    }

    private static String random(int count, boolean letters, boolean numbers) {
        return SecureRandomStringUtils.random(count, 0, 0, letters, numbers);
    }

    private static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return SecureRandomStringUtils.random(count, start, end, letters, numbers, null, SecureRandomStringUtils.random());
    }

    private static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, SecureRandom random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (chars != null && chars.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (start == 0 && end == 0) {
            if (chars != null) {
                end = chars.length;
            } else if (!letters && !numbers) {
                end = 0x10FFFF;
            } else {
                end = 123;
                start = 32;
            }
        } else if (end <= start) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater than start (" + start + ")");
        }
        int zeroDigitAscii = 48;
        int firstLetterAscii = 65;
        if (chars == null && (numbers && end <= 48 || letters && end <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater then (48) for generating digits or greater then (65) for generating letters.");
        }
        StringBuilder builder = new StringBuilder(count);
        int gap = end - start;
        block3: while (count-- != 0) {
            int codePoint;
            if (chars == null) {
                codePoint = random.nextInt(gap) + start;
                switch (Character.getType(codePoint)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++count;
                        continue block3;
                    }
                }
            } else {
                codePoint = chars[random.nextInt(gap) + start];
            }
            int numberOfChars = Character.charCount(codePoint);
            if (count == 0 && numberOfChars > 1) {
                ++count;
                continue;
            }
            if (letters && Character.isLetter(codePoint) || numbers && Character.isDigit(codePoint) || !letters && !numbers) {
                builder.appendCodePoint(codePoint);
                if (numberOfChars != 2) continue;
                --count;
                continue;
            }
            ++count;
        }
        return builder.toString();
    }

    private SecureRandomStringUtils() {
    }
}

