/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.ArrayList;
import java.util.List;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.json.JsonMapper;
import oadd.org.apache.drill.common.util.JacksonUtils;
import oadd.org.apache.drill.exec.util.SerializationModule;

public class JsonStringArrayList<E>
extends ArrayList<E> {
    private static final ObjectMapper mapper = ((JsonMapper.Builder)JacksonUtils.createJsonMapperBuilder().addModule(SerializationModule.getModule())).build();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public final String toString() {
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize array list to JSON string", e);
        }
    }
}

