/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ssl;

import java.util.function.BiFunction;
import oadd.org.apache.drill.exec.ssl.SSLConfig;

abstract class SSLCredentialsProvider {
    SSLCredentialsProvider() {
    }

    static SSLCredentialsProvider getSSLCredentialsProvider(BiFunction<String, String, String> getPropertyMethod, BiFunction<String, String, String> getPasswordPropertyMethod, SSLConfig.Mode mode) {
        return new SSLCredentialsProviderImpl(getPropertyMethod, getPasswordPropertyMethod);
    }

    abstract String getTrustStoreType(String var1, String var2);

    abstract String getTrustStoreLocation(String var1, String var2);

    abstract String getTrustStorePassword(String var1, String var2);

    abstract String getKeyStoreType(String var1, String var2);

    abstract String getKeyStoreLocation(String var1, String var2);

    abstract String getKeyStorePassword(String var1, String var2);

    abstract String getKeyPassword(String var1, String var2);

    private static class SSLCredentialsProviderImpl
    extends SSLCredentialsProvider {
        private final BiFunction<String, String, String> getPropertyMethod;
        private final BiFunction<String, String, String> getPasswordPropertyMethod;

        private SSLCredentialsProviderImpl(BiFunction<String, String, String> getPropertyMethod, BiFunction<String, String, String> getPasswordPropertyMethod) {
            this.getPropertyMethod = getPropertyMethod;
            this.getPasswordPropertyMethod = getPasswordPropertyMethod;
        }

        @Override
        String getTrustStoreType(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getTrustStoreLocation(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getTrustStorePassword(String propertyName, String defaultValue) {
            return this.getPasswordPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyStoreType(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyStoreLocation(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyStorePassword(String propertyName, String defaultValue) {
            return this.getPasswordPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyPassword(String propertyName, String defaultValue) {
            return this.getPasswordPropertyMethod.apply(propertyName, defaultValue);
        }
    }
}

