/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.schema;

import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.exec.schema.Field;

public class DiffSchema {
    List<Field> addedFields = Lists.newArrayList();
    List<Field> removedFields = Lists.newArrayList();
    boolean changed = false;

    public void recordNewField(Field field) {
        this.addedFields.add(field);
        this.changed = true;
    }

    public void reset() {
        this.addedFields.clear();
        this.removedFields.clear();
        this.changed = false;
    }

    public void addRemovedField(Field field) {
        this.removedFields.add(field);
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public String toString() {
        return "DiffSchema{addedFields=" + String.valueOf(this.addedFields) + ", removedFields=" + String.valueOf(this.removedFields) + "}";
    }
}

