/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.List;
import oadd.com.google.protobuf.CodedOutputStream;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufOutputStream;
import oadd.io.netty.buffer.CompositeByteBuf;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.handler.codec.MessageToMessageEncoder;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcEncoder
extends MessageToMessageEncoder<OutboundRpcMessage> {
    final Logger logger;
    static final int HEADER_TAG = RpcEncoder.makeTag(1, 2);
    static final int PROTOBUF_BODY_TAG = RpcEncoder.makeTag(2, 2);
    static final int RAW_BODY_TAG = RpcEncoder.makeTag(3, 2);
    static final int HEADER_TAG_LENGTH = RpcEncoder.getRawVarintSize(HEADER_TAG);
    static final int PROTOBUF_BODY_TAG_LENGTH = RpcEncoder.getRawVarintSize(PROTOBUF_BODY_TAG);
    static final int RAW_BODY_TAG_LENGTH = RpcEncoder.getRawVarintSize(RAW_BODY_TAG);

    public RpcEncoder(String name) {
        this.logger = LoggerFactory.getLogger(RpcEncoder.class.getCanonicalName() + "-" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, OutboundRpcMessage msg, List<Object> out) throws Exception {
        if (!ctx.channel().isOpen()) {
            this.logger.debug("Channel closed, skipping encode.");
            msg.release();
            return;
        }
        boolean encodeSucess = false;
        try {
            GeneralRPCProtos.RpcHeader header = GeneralRPCProtos.RpcHeader.newBuilder().setMode(msg.mode).setCoordinationId(msg.coordinationId).setRpcType(msg.rpcType).build();
            int headerLength = header.getSerializedSize();
            int protoBodyLength = msg.pBody.getSerializedSize();
            int rawBodyLength = msg.getRawBodySize();
            int fullLength = HEADER_TAG_LENGTH + RpcEncoder.getRawVarintSize(headerLength) + headerLength + PROTOBUF_BODY_TAG_LENGTH + RpcEncoder.getRawVarintSize(protoBodyLength) + protoBodyLength;
            if (rawBodyLength > 0) {
                fullLength += RAW_BODY_TAG_LENGTH + RpcEncoder.getRawVarintSize(rawBodyLength) + rawBodyLength;
            }
            ByteBuf buf = ctx.alloc().buffer();
            ByteBufOutputStream os = new ByteBufOutputStream(buf);
            CodedOutputStream cos = CodedOutputStream.newInstance(os);
            cos.writeRawVarint32(fullLength);
            cos.writeRawVarint32(HEADER_TAG);
            cos.writeRawVarint32(headerLength);
            header.writeTo(cos);
            cos.writeRawVarint32(PROTOBUF_BODY_TAG);
            cos.writeRawVarint32(protoBodyLength);
            msg.pBody.writeTo(cos);
            if (msg.getRawBodySize() > 0) {
                cos.writeRawVarint32(RAW_BODY_TAG);
                cos.writeRawVarint32(rawBodyLength);
                cos.flush();
                CompositeByteBuf cbb = ctx.alloc().compositeBuffer(msg.dBodies.length + 1);
                cbb.addComponent(buf);
                int bufLength = buf.readableBytes();
                for (ByteBuf b : msg.dBodies) {
                    cbb.addComponent(b);
                    bufLength += b.readableBytes();
                }
                cbb.writerIndex(bufLength);
                out.add(cbb);
            } else {
                cos.flush();
                out.add(buf);
            }
            encodeSucess = true;
        }
        finally {
            if (!encodeSucess) {
                msg.release();
            }
        }
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static int getRawVarintSize(int value) {
        int count = 0;
        while ((value & 0xFFFFFF80) != 0) {
            ++count;
            value >>>= 7;
        }
        return ++count;
    }
}

