/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.com.google.protobuf.Parser;
import oadd.io.netty.bootstrap.Bootstrap;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufAllocator;
import oadd.io.netty.channel.Channel;
import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.ChannelInboundHandlerAdapter;
import oadd.io.netty.channel.ChannelInitializer;
import oadd.io.netty.channel.ChannelOption;
import oadd.io.netty.channel.ChannelPipeline;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.handler.timeout.IdleState;
import oadd.io.netty.handler.timeout.IdleStateEvent;
import oadd.io.netty.handler.timeout.IdleStateHandler;
import oadd.io.netty.util.concurrent.EventExecutor;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.io.netty.util.concurrent.Promise;
import oadd.io.netty.util.concurrent.ScheduledFuture;
import oadd.org.apache.commons.lang3.tuple.Pair;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.AbstractHandshakeHandler;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.ClientConnection;
import oadd.org.apache.drill.exec.rpc.ConnectionMultiListener;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.RpcBus;
import oadd.org.apache.drill.exec.rpc.RpcConfig;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcDecoder;
import oadd.org.apache.drill.exec.rpc.RpcEncoder;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcExceptionHandler;
import oadd.org.apache.drill.exec.rpc.RpcOutcome;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import oadd.org.apache.drill.exec.rpc.security.AuthenticationOutcomeListener;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicClient<T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite>
extends RpcBus<T, CC> {
    private static final Logger logger = LoggerFactory.getLogger(BasicClient.class);
    private static final double PERCENT_TIMEOUT_BEFORE_SENDING_PING = 0.5;
    private final Bootstrap b;
    protected CC connection;
    private final T handshakeType;
    private final Class<HR> responseClass;
    private final Parser<HR> handshakeParser;
    private HeartBeatHandler heartBeatHandler;
    private ConnectionMultiListener.SSLHandshakeListener sslHandshakeListener = null;
    private boolean authComplete = true;

    public BasicClient(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup, T handshakeType, Class<HR> responseClass, Parser<HR> handshakeParser) {
        super(rpcMapping);
        this.responseClass = responseClass;
        this.handshakeType = handshakeType;
        this.handshakeParser = handshakeParser;
        int readIdleSec = rpcMapping.hasTimeout() ? (int)((double)rpcMapping.getTimeout() * 0.5) : -1;
        final IdleStateHandler idleStateHandler = rpcMapping.hasTimeout() ? new IdleStateHandler(readIdleSec, 0, 0) : null;
        int heartbeatWaitSec = rpcMapping.hasTimeout() ? rpcMapping.getTimeout() - readIdleSec : -1;
        final HeartBeatHandler heartBeatHandler = this.heartBeatHandler = new HeartBeatHandler(heartbeatWaitSec);
        this.b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(TransportCheck.getClientSocketChannel())).option(ChannelOption.ALLOCATOR, alloc)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                BasicClient.this.connection = BasicClient.this.initRemoteConnection(ch);
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)BasicClient.this.getCloseHandler(ch, BasicClient.this.connection));
                ChannelPipeline pipe = ch.pipeline();
                if (BasicClient.this.isSslEnabled()) {
                    BasicClient.this.setupSSL(pipe, BasicClient.this.sslHandshakeListener);
                }
                if (idleStateHandler != null) {
                    pipe.addLast("idle-state-handler", (ChannelHandler)idleStateHandler);
                }
                pipe.addLast("protocol-decoder", (ChannelHandler)BasicClient.this.getDecoder(BasicClient.this.connection.getAllocator()));
                pipe.addLast("message-decoder", (ChannelHandler)new RpcDecoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast("protocol-encoder", (ChannelHandler)new RpcEncoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast("handshake-handler", (ChannelHandler)new ClientHandshakeHandler(BasicClient.this, BasicClient.this.connection));
                pipe.addLast("message-handler", (ChannelHandler)new RpcBus.InboundHandler((RpcBus)BasicClient.this, BasicClient.this.connection));
                pipe.addLast("heartbeat-handler", (ChannelHandler)heartBeatHandler);
                pipe.addLast("exception-handler", new RpcExceptionHandler(BasicClient.this.connection));
            }
        });
    }

    protected void setupSSL(ChannelPipeline pipe, ConnectionMultiListener.SSLHandshakeListener sslHandshakeListener) {
        throw new UnsupportedOperationException("SSL is implemented only by the User Client.");
    }

    protected boolean isSslEnabled() {
        return false;
    }

    protected void setAuthComplete(boolean authComplete) {
        this.authComplete = authComplete;
    }

    protected boolean isAuthComplete() {
        return this.authComplete;
    }

    public void setSslChannel(Channel c) {
    }

    @Override
    protected CC initRemoteConnection(SocketChannel channel) {
        this.local = channel.localAddress();
        this.remote = channel.remoteAddress();
        return null;
    }

    public boolean hasPing(long timeoutSec) {
        if (timeoutSec < 0L) {
            timeoutSec = 0L;
        }
        try {
            return this.heartBeatHandler.demandHeartbeat().await(timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Heartbeat wait was interrupted.");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public abstract ProtobufLengthDecoder getDecoder(BufferAllocator var1);

    public boolean isActive() {
        return this.connection != null && this.connection.isActive();
    }

    protected abstract List<String> validateHandshake(HR var1) throws RpcException;

    protected abstract void prepareSaslHandshake(RpcConnectionHandler<CC> var1, List<String> var2) throws RpcException;

    protected void startSaslHandshake(final RpcConnectionHandler<CC> connectionHandler, Map<String, ?> saslProperties, UserGroupInformation ugi, AuthenticatorFactory authFactory, T rpcType) {
        String mechanismName = authFactory.getSimpleName();
        try {
            SaslClient saslClient = authFactory.createSaslClient(ugi, saslProperties);
            if (saslClient == null) {
                SaslException ex = new SaslException(String.format("Cannot initiate authentication using %s mechanism. Insufficient credentials or selected mechanism doesn't support configured security layers?", mechanismName));
                connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, ex);
                return;
            }
            this.connection.setSaslClient(saslClient);
        }
        catch (SaslException e) {
            logger.error("Failed while creating SASL client for SASL handshake for connection: {}", (Object)this.connection.getName());
            connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, e);
            return;
        }
        logger.debug("Initiating SASL exchange.");
        new AuthenticationOutcomeListener(this, this.connection, rpcType, ugi, new RpcOutcomeListener<Void>(){

            @Override
            public void failed(RpcException ex) {
                connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, ex);
            }

            @Override
            public void success(Void value, ByteBuf buffer) {
                BasicClient.this.authComplete = true;
                connectionHandler.connectionSucceeded(BasicClient.this.connection);
            }

            @Override
            public void interrupted(InterruptedException ex) {
                connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, ex);
            }
        }).initiate(mechanismName);
    }

    protected void finalizeConnection(HR handshake, CC connection) {
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, SEND protobufBody, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, this.handshakeType, protobufBody, this.responseClass, allowInEventLoop, dataBodies);
    }

    protected void connectAsClient(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, String host, int port) {
        ConnectionMultiListener cml;
        ConnectionMultiListener.Builder builder = ConnectionMultiListener.newBuilder(connectionListener, handshakeValue, this);
        if (this.isSslEnabled()) {
            cml = builder.enableSSL().build();
            this.sslHandshakeListener = new ConnectionMultiListener.SSLHandshakeListener();
            this.sslHandshakeListener.setParent(cml);
        } else {
            cml = builder.build();
        }
        this.b.connect(host, port).addListener(cml.connectionHandler);
    }

    public void setAutoRead(boolean enableAutoRead) {
        this.connection.setAutoRead(enableAutoRead);
    }

    @Override
    public void close() {
        logger.debug("Closing client");
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private class HeartBeatHandler
    extends ChannelInboundHandlerAdapter {
        private final OutboundRpcMessage PING_MESSAGE = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PING, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);
        private final int answerWaitSec;
        private final Queue<Pair<Promise<Boolean>, ScheduledFuture>> pongFutures = new LinkedList<Pair<Promise<Boolean>, ScheduledFuture>>();
        private ChannelHandlerContext ctx;

        public HeartBeatHandler(int answerWaitSec) {
            this.answerWaitSec = answerWaitSec;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.ctx = ctx;
            super.handlerAdded(ctx);
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            GeneralRPCProtos.RpcMode rpcMode;
            if (evt instanceof IdleStateEvent) {
                IdleStateEvent idleState = (IdleStateEvent)evt;
                if (idleState.state() == IdleState.READER_IDLE) {
                    this.idleEvent();
                }
            } else if (evt instanceof GeneralRPCProtos.RpcMode && (rpcMode = (GeneralRPCProtos.RpcMode)evt) == GeneralRPCProtos.RpcMode.PONG) {
                this.pongReceived();
            }
            ctx.fireUserEventTriggered(evt);
        }

        private void idleEvent() {
            EventExecutor executor = this.ctx.executor();
            Promise pongReceived = executor.newPromise();
            ScheduledFuture<?> pongTimeoutChecker = null;
            if (this.answerWaitSec > 0) {
                pongTimeoutChecker = executor.schedule(() -> {
                    if (!pongReceived.isSuccess()) {
                        logger.error("Unable to get an answer from the server. Timeout: {} seconds. Connection: {}.  Closing connection.", (Object)this.answerWaitSec, (Object)BasicClient.this.connection.getName());
                        BasicClient.this.connection.close();
                    }
                }, (long)this.answerWaitSec, TimeUnit.SECONDS);
            }
            this.pongFutures.add(Pair.of(pongReceived, pongTimeoutChecker));
            this.sendPing();
        }

        private void sendPing() {
            this.ctx.channel().writeAndFlush(this.PING_MESSAGE).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess()) {
                    logger.error("Unable to maintain connection {}.  Closing connection.", (Object)BasicClient.this.connection.getName());
                    BasicClient.this.close();
                }
            }));
        }

        private void pongReceived() {
            Pair<Promise<Boolean>, ScheduledFuture> pongFuture = this.pongFutures.poll();
            if (pongFuture != null) {
                Promise<Boolean> pongReceived = pongFuture.getLeft();
                pongReceived.setSuccess(true);
                ScheduledFuture pongTimeoutChecker = pongFuture.getRight();
                if (pongTimeoutChecker != null) {
                    pongTimeoutChecker.cancel(false);
                }
            }
        }

        public Promise<Boolean> demandHeartbeat() {
            EventExecutor executor = this.ctx.executor();
            Promise<Boolean> pongReceived = executor.newPromise();
            this.pongFutures.add(Pair.of(pongReceived, null));
            this.sendPing();
            return pongReceived;
        }
    }

    private static class ClientHandshakeHandler
    extends AbstractHandshakeHandler<HR> {
        private final CC connection;
        final /* synthetic */ BasicClient this$0;

        ClientHandshakeHandler(CC connection) {
            this.this$0 = var1_1;
            super((Internal.EnumLite)var1_1.handshakeType, var1_1.handshakeParser);
            Preconditions.checkNotNull(connection);
            this.connection = connection;
        }

        @Override
        protected final void consumeHandshake(ChannelHandlerContext ctx, HR msg) throws Exception {
            RpcOutcome response = this.connection.getAndRemoveRpcOutcome(this.handshakeType.getNumber(), this.coordinationId, this.this$0.responseClass);
            response.set(msg, null);
        }
    }
}

