/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.selection;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.DeadBuf;

public class SelectionVector2
implements AutoCloseable {
    public static final int RECORD_SIZE = 2;
    private final BufferAllocator allocator;
    private int recordCount;
    private int batchActualRecordCount = -1;
    private DrillBuf buffer = DeadBuf.DEAD_BUFFER;

    public SelectionVector2(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public SelectionVector2(BufferAllocator allocator, DrillBuf buf, int count) {
        this.allocator = allocator;
        this.buffer = buf;
        this.buffer.retain(1);
        this.recordCount = count;
    }

    public SelectionVector2(BufferAllocator allocator, DrillBuf buf, int count, int actualRecordCount) {
        this(allocator, buf, count);
        this.batchActualRecordCount = actualRecordCount;
    }

    public int getCount() {
        return this.recordCount;
    }

    public DrillBuf getBuffer() {
        return this.getBuffer(true);
    }

    public DrillBuf getBuffer(boolean clear) {
        DrillBuf bufferHandle = this.buffer;
        if (clear) {
            bufferHandle.retain(1);
            this.clear();
        }
        return bufferHandle;
    }

    public void setBuffer(DrillBuf bufferHandle) {
        this.clear();
        this.buffer = bufferHandle;
        this.buffer.retain(1);
    }

    public char getIndex(int index) {
        return this.buffer.getChar(index * 2);
    }

    public void setIndex(int index, char value) {
        this.buffer.setChar(index * 2, value);
    }

    public long getDataAddr() {
        return this.buffer.memoryAddress();
    }

    public void setIndex(int index, int value) {
        this.buffer.setChar(index * 2, value);
    }

    public boolean allocateNewSafe(int size) {
        try {
            this.allocateNew(size);
        }
        catch (OutOfMemoryException e) {
            return false;
        }
        return true;
    }

    public void allocateNew(int size) {
        this.clear();
        this.buffer = this.allocator.buffer(size * 2);
    }

    public SelectionVector2 clone() {
        SelectionVector2 newSV = new SelectionVector2(this.allocator);
        newSV.recordCount = this.recordCount;
        newSV.batchActualRecordCount = this.batchActualRecordCount;
        newSV.buffer = this.buffer;
        newSV.buffer.retain(1);
        this.clear();
        return newSV;
    }

    public void clear() {
        if (this.buffer != null && this.buffer != DeadBuf.DEAD_BUFFER) {
            this.buffer.release();
            this.buffer = DeadBuf.DEAD_BUFFER;
            this.recordCount = 0;
            this.batchActualRecordCount = -1;
        }
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public boolean canDoFullTransfer() {
        return this.recordCount == this.batchActualRecordCount;
    }

    public void setBatchActualRecordCount(int actualRecordCount) {
        this.batchActualRecordCount = actualRecordCount;
    }

    public int getBatchActualRecordCount() {
        return this.batchActualRecordCount;
    }

    @Override
    public void close() {
        this.clear();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[SV2: recs=");
        buf.append(this.recordCount);
        buf.append(" - ");
        int n = Math.min(20, this.recordCount);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append((int)this.getIndex(i));
        }
        if (this.recordCount > n) {
            buf.append("...");
            buf.append((int)this.getIndex(this.recordCount - 1));
        }
        buf.append("]");
        return buf.toString();
    }
}

