/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.ImmutableList;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;

public class TupleNameSpace<T>
implements Iterable<T> {
    private final Map<String, Integer> nameSpace = CaseInsensitiveMap.newHashMap();
    private final List<T> entries = new ArrayList<T>();

    public int add(String key, T value) {
        if (this.indexOf(key) != -1) {
            throw new IllegalArgumentException("Duplicate entry: " + key);
        }
        int index = this.entries.size();
        this.nameSpace.put(key, index);
        this.entries.add(value);
        return index;
    }

    public T get(int index) {
        return this.entries.get(index);
    }

    public T get(String key) {
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        return this.get(index);
    }

    public int indexOf(String key) {
        Integer index = this.nameSpace.get(key);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int count() {
        return this.entries.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.entries.iterator();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public List<T> entries() {
        return ImmutableList.copyOf(this.entries);
    }

    public void replace(String key, T replaceWith) {
        int index = this.indexOf(key);
        Preconditions.checkArgument(index != -1);
        this.entries.set(index, replaceWith);
    }

    public String toString() {
        return this.entries.toString();
    }
}

