/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metrics;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import oadd.com.codahale.metrics.Gauge;
import oadd.com.codahale.metrics.Metric;
import oadd.com.codahale.metrics.MetricSet;
import oadd.com.google.common.collect.ImmutableMap;
import org.slf4j.LoggerFactory;

public class CpuGaugeSet
implements MetricSet {
    private final java.lang.management.OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private final RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();

    @Override
    public Map<String, Metric> getMetrics() {
        Gauge<Double> osLoadAvgGauge = new Gauge<Double>(){

            @Override
            public Double getValue() {
                return CpuGaugeSet.this.osMxBean.getSystemLoadAverage();
            }
        };
        Gauge<Double> procLoadAvgGauge = new Gauge<Double>(){
            private boolean canUseSunInternalBean = true;

            @Override
            public Double getValue() {
                if (!this.canUseSunInternalBean) {
                    return null;
                }
                try {
                    return ((OperatingSystemMXBean)CpuGaugeSet.this.osMxBean).getProcessCpuLoad();
                }
                catch (ClassCastException | NoClassDefFoundError e) {
                    LoggerFactory.getLogger(CpuGaugeSet.class).warn("The process load gauge is not supported on this Java runtime: {}", (Object)System.getProperty("java.vm.name"));
                    this.canUseSunInternalBean = false;
                    return null;
                }
            }
        };
        Gauge<Long> uptimeGauge = new Gauge<Long>(){

            @Override
            public Long getValue() {
                return CpuGaugeSet.this.runtimeMxBean.getUptime();
            }
        };
        return ImmutableMap.of("os.load.avg", osLoadAvgGauge, "drillbit.load.avg", procLoadAvgGauge, "drillbit.uptime", uptimeGauge);
    }
}

