/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oadd.org.apache.calcite.rel.core.TableScan;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.logical.data.NamedExpression;
import oadd.org.apache.drill.exec.metastore.ColumnNamesOptions;
import oadd.org.apache.drill.exec.metastore.analyze.AnalyzeInfoProvider;
import oadd.org.apache.drill.exec.metastore.analyze.FileMetadataInfoCollector;
import oadd.org.apache.drill.exec.metastore.analyze.MetadataInfoCollector;
import oadd.org.apache.drill.exec.planner.logical.DrillTable;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.store.ColumnExplorer;
import oadd.org.apache.drill.exec.store.dfs.FileSelection;
import oadd.org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.TableInfo;

public abstract class AnalyzeFileInfoProvider
implements AnalyzeInfoProvider {
    @Override
    public List<SchemaPath> getSegmentColumns(DrillTable table, ColumnNamesOptions columnNamesOptions) throws IOException {
        FormatSelection selection = (FormatSelection)table.getSelection();
        FileSelection fileSelection = selection.getSelection();
        if (!fileSelection.isExpandedFully()) {
            fileSelection = FileMetadataInfoCollector.getExpandedFileSelection(fileSelection);
        }
        return ColumnExplorer.getPartitionColumnNames((FileSelection)fileSelection, (ColumnNamesOptions)columnNamesOptions).stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
    }

    @Override
    public List<SchemaPath> getProjectionFields(DrillTable table, MetadataType metadataLevel, ColumnNamesOptions columnNamesOptions) throws IOException {
        ArrayList<SchemaPath> projectionList = new ArrayList<SchemaPath>(this.getSegmentColumns(table, columnNamesOptions));
        projectionList.add(SchemaPath.getSimplePath(columnNamesOptions.fullyQualifiedName()));
        projectionList.add(SchemaPath.getSimplePath(columnNamesOptions.lastModifiedTime()));
        projectionList.add(SchemaPath.getSimplePath(columnNamesOptions.projectMetadataColumn()));
        return Collections.unmodifiableList(projectionList);
    }

    @Override
    public MetadataInfoCollector getMetadataInfoCollector(BasicTablesRequests basicRequests, TableInfo tableInfo, FormatSelection selection, PlannerSettings settings, Supplier<TableScan> tableScanSupplier, List<SchemaPath> interestingColumns, MetadataType metadataLevel, int segmentColumnsCount) throws IOException {
        return new FileMetadataInfoCollector(basicRequests, tableInfo, selection, settings, tableScanSupplier, interestingColumns, metadataLevel, segmentColumnsCount);
    }

    @Override
    public SchemaPath getLocationField(ColumnNamesOptions columnNamesOptions) {
        return SchemaPath.getSimplePath(columnNamesOptions.fullyQualifiedName());
    }

    @Override
    public NamedExpression getParentLocationExpression(SchemaPath locationField) {
        return new NamedExpression(new FunctionCall("parentPath", Collections.singletonList(locationField), ExpressionPosition.UNKNOWN), FieldReference.getWithQuotedRef("location"));
    }
}

