/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.dotdrill;

import oadd.org.apache.hadoop.fs.FileStatus;
import oadd.org.apache.hadoop.fs.Path;

public enum DotDrillType {
    VIEW,
    STATS;

    private final String ending = "." + this.name().toLowerCase() + ".drill";
    public static final String DOT_DRILL_GLOB;

    public boolean matches(FileStatus status) {
        return status.getPath().getName().endsWith(this.ending);
    }

    public Path getPath(String parentDir, String name) {
        return new Path(parentDir, name + this.ending);
    }

    public String getEnding() {
        return this.ending;
    }

    public static String getDrillFileGlobPattern(DotDrillType[] types) {
        if (types.length == 1) {
            return "." + types[0].name().toLowerCase() + ".drill";
        }
        StringBuffer b = new StringBuffer();
        b.append(".{");
        for (DotDrillType d : types) {
            if (b.length() > 2) {
                b.append(',');
            }
            b.append(d.name().toLowerCase());
        }
        b.append("}.drill");
        return b.toString();
    }

    static {
        StringBuffer b = new StringBuffer();
        b.append(".{");
        for (DotDrillType d : DotDrillType.values()) {
            if (b.length() > 2) {
                b.append(',');
            }
            b.append(d.name().toLowerCase());
        }
        b.append("}.drill");
        DOT_DRILL_GLOB = b.toString();
    }
}

