/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.client;

import java.util.Map;
import java.util.Set;
import oadd.com.google.common.collect.ImmutableMap;
import oadd.com.google.common.collect.ImmutableSet;
import oadd.com.google.common.collect.Maps;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.drill.common.Version;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.user.UserRpcUtils;

public enum ServerMethod {
    RUN_QUERY(UserProtos.RpcType.RUN_QUERY, Constants.DRILL_0_0_0),
    PLAN_QUERY(UserProtos.RpcType.QUERY_PLAN_FRAGMENTS, Constants.DRILL_0_0_0),
    CANCEL_QUERY(UserProtos.RpcType.CANCEL_QUERY, Constants.DRILL_0_0_0),
    RESUME_PAUSED_QUERY(UserProtos.RpcType.RESUME_PAUSED_QUERY, Constants.DRILL_0_0_0),
    PREPARED_STATEMENT(UserProtos.RpcType.CREATE_PREPARED_STATEMENT, Constants.DRILL_1_8_0),
    GET_CATALOGS(UserProtos.RpcType.GET_CATALOGS, Constants.DRILL_1_8_0),
    GET_SCHEMAS(UserProtos.RpcType.GET_SCHEMAS, Constants.DRILL_1_8_0),
    GET_TABLES(UserProtos.RpcType.GET_TABLES, Constants.DRILL_1_8_0),
    GET_COLUMNS(UserProtos.RpcType.GET_COLUMNS, Constants.DRILL_1_8_0),
    GET_SERVER_META(UserProtos.RpcType.GET_SERVER_META, Constants.DRILL_1_10_0);

    private static final Map<UserProtos.RpcType, ServerMethod> REVERSE_MAPPING;
    private final UserProtos.RpcType rpcType;
    private final Version minVersion;

    private ServerMethod(UserProtos.RpcType rpcType, Version minVersion) {
        this.rpcType = rpcType;
        this.minVersion = minVersion;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    static final Set<ServerMethod> getSupportedMethods(Iterable<UserProtos.RpcType> supportedMethods, UserProtos.RpcEndpointInfos serverInfos) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (UserProtos.RpcType supportedMethod : supportedMethods) {
            ServerMethod method = REVERSE_MAPPING.get(supportedMethod);
            if (method == null) continue;
            builder.add((Object)method);
        }
        if (serverInfos == null) {
            return Sets.immutableEnumSet(builder.build());
        }
        Version serverVersion = UserRpcUtils.getVersion(serverInfos);
        for (ServerMethod capability : ServerMethod.values()) {
            if (serverVersion.compareTo(capability.getMinVersion()) < 0) continue;
            builder.add((Object)capability);
        }
        return Sets.immutableEnumSet(builder.build());
    }

    static {
        ImmutableMap.Builder<UserProtos.RpcType, ServerMethod> builder = ImmutableMap.builder();
        for (ServerMethod method : ServerMethod.values()) {
            builder.put(method.rpcType, method);
        }
        REVERSE_MAPPING = Maps.immutableEnumMap(builder.build());
    }

    private static class Constants {
        private static final Version DRILL_0_0_0 = new Version("0.0.0", 0, 0, 0, 0, "");
        private static final Version DRILL_1_8_0 = new Version("1.8.0", 1, 8, 0, 0, "");
        private static final Version DRILL_1_10_0 = new Version("1.10.0", 1, 10, 0, 0, "");

        private Constants() {
        }
    }
}

