/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.cache;

import oadd.com.google.protobuf.Message;
import oadd.org.apache.drill.exec.cache.Counter;
import oadd.org.apache.drill.exec.cache.DistributedMap;
import oadd.org.apache.drill.exec.cache.DistributedMultiMap;
import oadd.org.apache.drill.exec.cache.DrillSerializable;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DistributedCache
extends AutoCloseable {
    public static final Logger logger = LoggerFactory.getLogger(DistributedCache.class);

    public void run() throws DrillbitStartupException;

    public <K, V> DistributedMap<K, V> getMap(CacheConfig<K, V> var1);

    public <K, V> DistributedMultiMap<K, V> getMultiMap(CacheConfig<K, V> var1);

    public Counter getCounter(String var1);

    public static class CacheConfigBuilder<K, V> {
        private Class<K> keyClass;
        private Class<V> valueClass;
        private String name;
        private SerializationMode mode = SerializationMode.DRILL_SERIALIZIABLE;

        private CacheConfigBuilder(Class<K> keyClass, Class<V> valueClass) {
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            this.name = keyClass.getName();
        }

        public CacheConfigBuilder<K, V> mode(SerializationMode mode) {
            this.mode = mode;
            return this;
        }

        public CacheConfigBuilder<K, V> proto() {
            this.mode = SerializationMode.PROTOBUF;
            return this;
        }

        public CacheConfigBuilder<K, V> jackson() {
            this.mode = SerializationMode.JACKSON;
            return this;
        }

        public CacheConfigBuilder<K, V> drill() {
            this.mode = SerializationMode.DRILL_SERIALIZIABLE;
            return this;
        }

        public CacheConfigBuilder<K, V> name(String name) {
            this.name = name;
            return this;
        }

        public CacheConfig<K, V> build() {
            this.mode.checkClass(this.keyClass);
            this.mode.checkClass(this.valueClass);
            return new CacheConfig<K, V>(this.keyClass, this.valueClass, this.name, this.mode);
        }
    }

    public static class CacheConfig<K, V> {
        private final Class<K> keyClass;
        private final Class<V> valueClass;
        private final String name;
        private final SerializationMode mode;

        public CacheConfig(Class<K> keyClass, Class<V> valueClass, String name, SerializationMode mode) {
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            this.name = name;
            this.mode = mode;
        }

        public Class<K> getKeyClass() {
            return this.keyClass;
        }

        public Class<V> getValueClass() {
            return this.valueClass;
        }

        public SerializationMode getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyClass == null ? 0 : this.keyClass.hashCode());
            result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.valueClass == null ? 0 : this.valueClass.hashCode());
            return result;
        }

        public static <V> CacheConfigBuilder<String, V> newBuilder(Class<V> valueClass) {
            return CacheConfig.newBuilder(String.class, valueClass);
        }

        public static <K, V> CacheConfigBuilder<K, V> newBuilder(Class<K> keyClass, Class<V> valueClass) {
            return new CacheConfigBuilder<K, V>(keyClass, valueClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheConfig other = (CacheConfig)obj;
            if (this.keyClass == null ? other.keyClass != null : !this.keyClass.equals(other.keyClass)) {
                return false;
            }
            if (this.mode != other.mode) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.valueClass == null ? other.valueClass != null : !this.valueClass.equals(other.valueClass));
        }
    }

    public static enum SerializationMode {
        JACKSON(Object.class),
        DRILL_SERIALIZIABLE(String.class, DrillSerializable.class),
        PROTOBUF(String.class, Message.class);

        private final Class<?>[] classes;

        private SerializationMode(Class<?> ... classes) {
            this.classes = classes;
        }

        public void checkClass(Class<?> classToCheck) {
            for (Class<?> c : this.classes) {
                if (!c.isAssignableFrom(classToCheck)) continue;
                return;
            }
            throw new UnsupportedOperationException(String.format("You are trying to serialize the class %s using the serialization mode %s.  This is not allowed.", classToCheck.getName(), this.name()));
        }
    }
}

