/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.scanner.persistence;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.org.apache.drill.common.scanner.persistence.AnnotationDescriptor;
import oadd.org.apache.drill.common.scanner.persistence.FieldDescriptor;

public final class AnnotatedClassDescriptor {
    private final String className;
    private final List<AnnotationDescriptor> annotations;
    private final List<FieldDescriptor> fields;
    private final Map<String, AnnotationDescriptor> annotationMap;

    @JsonCreator
    public AnnotatedClassDescriptor(@JsonProperty(value="className") String className, @JsonProperty(value="annotations") List<AnnotationDescriptor> annotations, @JsonProperty(value="fields") List<FieldDescriptor> fields) {
        this.className = className;
        this.annotations = Collections.unmodifiableList(annotations);
        this.fields = Collections.unmodifiableList(fields);
        this.annotationMap = AnnotationDescriptor.buildAnnotationsMap(annotations);
    }

    public String getClassName() {
        return this.className;
    }

    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public AnnotationDescriptor getAnnotation(Class<?> clazz) {
        return this.annotationMap.get(clazz.getName());
    }

    public <T> T getAnnotationProxy(Class<T> clazz) {
        AnnotationDescriptor annotationDescriptor = this.getAnnotation(clazz);
        if (annotationDescriptor == null) {
            return null;
        }
        return annotationDescriptor.getProxy(clazz);
    }

    public String toString() {
        return "Function [className=" + this.className + ", annotations=" + String.valueOf(this.annotations) + ", fields=" + String.valueOf(this.fields) + "]";
    }
}

