/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical.data;

import java.util.Iterator;
import java.util.List;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.collect.ImmutableMap;
import oadd.com.google.common.collect.Iterators;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.calcite.rel.RelFieldCollation;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.logical.data.AbstractSingleBuilder;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.data.SingleInputOperator;
import oadd.org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="order")
public class Order
extends SingleInputOperator {
    private final List<Ordering> orderings;
    private final FieldReference within;

    @JsonCreator
    public Order(@JsonProperty(value="within") FieldReference within, @JsonProperty(value="orderings") List<Ordering> orderings) {
        this.orderings = orderings;
        this.within = within;
    }

    public List<Ordering> getOrderings() {
        return this.orderings;
    }

    public FieldReference getWithin() {
        return this.within;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitOrder(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator(this.getInput());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSingleBuilder<Order, Builder> {
        private List<Ordering> orderings = Lists.newArrayList();
        private FieldReference within;

        public Builder setWithin(FieldReference within) {
            this.within = within;
            return this;
        }

        public Builder addOrdering(RelFieldCollation.Direction direction, LogicalExpression e, RelFieldCollation.NullDirection collation) {
            this.orderings.add(new Ordering(direction, e, collation));
            return this;
        }

        @Override
        public Order internalBuild() {
            return new Order(this.within, this.orderings);
        }
    }

    public static class Ordering {
        public static final String ORDER_ASC = "ASC";
        public static final String ORDER_DESC = "DESC";
        public static final String ORDER_ASCENDING = "ASCENDING";
        public static final String ORDER_DESCENDING = "DESCENDING";
        public static final String NULLS_FIRST = "FIRST";
        public static final String NULLS_LAST = "LAST";
        public static final String NULLS_UNSPECIFIED = "UNSPECIFIED";
        private final LogicalExpression expr;
        private final RelFieldCollation.Direction direction;
        private final RelFieldCollation.NullDirection nullOrdering;
        private static ImmutableMap<String, RelFieldCollation.Direction> DRILL_TO_CALCITE_DIR_MAPPING = ImmutableMap.builder().put("ASC", RelFieldCollation.Direction.ASCENDING).put("DESC", RelFieldCollation.Direction.DESCENDING).put("ASCENDING", RelFieldCollation.Direction.ASCENDING).put("DESCENDING", RelFieldCollation.Direction.DESCENDING).build();
        private static ImmutableMap<String, RelFieldCollation.NullDirection> DRILL_TO_CALCITE_NULL_DIR_MAPPING = ImmutableMap.builder().put("FIRST", RelFieldCollation.NullDirection.FIRST).put("LAST", RelFieldCollation.NullDirection.LAST).put("UNSPECIFIED", RelFieldCollation.NullDirection.UNSPECIFIED).build();

        @JsonCreator
        public Ordering(@JsonProperty(value="order") String strOrderingSpec, @JsonProperty(value="expr") LogicalExpression expr, @JsonProperty(value="nullDirection") String strNullOrdering) {
            this.expr = expr;
            this.direction = Ordering.getOrderingSpecFromString(strOrderingSpec);
            this.nullOrdering = Ordering.getNullOrderingFromString(strNullOrdering);
        }

        public Ordering(RelFieldCollation.Direction direction, LogicalExpression e, RelFieldCollation.NullDirection nullOrdering) {
            this.expr = e;
            this.direction = Ordering.filterDrillSupportedDirections(direction);
            this.nullOrdering = nullOrdering;
        }

        public Ordering(RelFieldCollation.Direction direction, LogicalExpression e) {
            this(direction, e, RelFieldCollation.NullDirection.FIRST);
        }

        @VisibleForTesting
        public static RelFieldCollation.Direction getOrderingSpecFromString(String strDirection) {
            RelFieldCollation.Direction dir = null;
            if (strDirection != null) {
                dir = DRILL_TO_CALCITE_DIR_MAPPING.get(strDirection.toUpperCase());
            }
            if (dir != null || strDirection == null) {
                return Ordering.filterDrillSupportedDirections(dir);
            }
            throw new DrillRuntimeException("Unknown <ordering specification> string (not \"ASC\", \"DESC\", or null): \"" + strDirection + "\"");
        }

        @VisibleForTesting
        public static RelFieldCollation.NullDirection getNullOrderingFromString(String strNullOrdering) {
            RelFieldCollation.NullDirection nullDir = null;
            if (strNullOrdering != null) {
                nullDir = DRILL_TO_CALCITE_NULL_DIR_MAPPING.get(strNullOrdering.toUpperCase());
            }
            if (nullDir != null || strNullOrdering == null) {
                return Ordering.filterDrillSupportedNullDirections(nullDir);
            }
            throw new DrillRuntimeException("Internal error:  Unknown <null ordering> string (not \"FIRST\", \"LAST\", or \"UNSPECIFIED\" or null): \"" + strNullOrdering + "\"");
        }

        private static RelFieldCollation.Direction filterDrillSupportedDirections(RelFieldCollation.Direction direction) {
            if (direction == null || direction == RelFieldCollation.Direction.ASCENDING) {
                return RelFieldCollation.Direction.ASCENDING;
            }
            if (RelFieldCollation.Direction.DESCENDING.equals((Object)direction)) {
                return direction;
            }
            throw new DrillRuntimeException("Unknown <ordering specification> string (not \"ASC\", \"DESC\", or null): \"" + String.valueOf(direction) + "\"");
        }

        private static RelFieldCollation.NullDirection filterDrillSupportedNullDirections(RelFieldCollation.NullDirection nullDirection) {
            if (null == nullDirection) {
                return RelFieldCollation.NullDirection.UNSPECIFIED;
            }
            switch (nullDirection) {
                case LAST: 
                case FIRST: 
                case UNSPECIFIED: {
                    return nullDirection;
                }
            }
            throw new DrillRuntimeException("Internal error:  Unknown <null ordering> string (not \"" + RelFieldCollation.NullDirection.FIRST.name() + "\", \"" + RelFieldCollation.NullDirection.LAST.name() + "\", or \"" + RelFieldCollation.NullDirection.UNSPECIFIED.name() + "\" or null): \"" + String.valueOf(nullDirection) + "\"");
        }

        public String toString() {
            return super.toString() + "[  expr = " + String.valueOf(this.expr) + ", direction = " + String.valueOf(this.direction) + ", nullOrdering = " + String.valueOf(this.nullOrdering) + "] ";
        }

        @JsonIgnore
        public RelFieldCollation.Direction getDirection() {
            return this.direction;
        }

        public LogicalExpression getExpr() {
            return this.expr;
        }

        public String getOrder() {
            switch (this.direction) {
                case ASCENDING: {
                    return RelFieldCollation.Direction.ASCENDING.shortString;
                }
                case DESCENDING: {
                    return RelFieldCollation.Direction.DESCENDING.shortString;
                }
            }
            throw new DrillRuntimeException("Unexpected " + RelFieldCollation.Direction.class.getName() + " value other than " + String.valueOf(RelFieldCollation.Direction.ASCENDING) + " or " + String.valueOf(RelFieldCollation.Direction.DESCENDING) + ": " + String.valueOf(this.direction));
        }

        public RelFieldCollation.NullDirection getNullDirection() {
            return this.nullOrdering;
        }

        public boolean nullsSortHigh() {
            boolean nullsHigh;
            switch (this.nullOrdering) {
                case UNSPECIFIED: {
                    nullsHigh = true;
                    break;
                }
                case FIRST: {
                    nullsHigh = RelFieldCollation.Direction.DESCENDING == this.getDirection();
                    break;
                }
                case LAST: {
                    nullsHigh = RelFieldCollation.Direction.ASCENDING == this.getDirection();
                    break;
                }
                default: {
                    throw new DrillRuntimeException("Unexpected " + RelFieldCollation.NullDirection.class.getName() + " value other than " + String.valueOf(RelFieldCollation.NullDirection.FIRST) + ", " + String.valueOf(RelFieldCollation.NullDirection.LAST) + " or " + String.valueOf(RelFieldCollation.NullDirection.UNSPECIFIED) + ": " + String.valueOf(this.nullOrdering));
                }
            }
            return nullsHigh;
        }
    }
}

