/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.util.Collections;
import java.util.Iterator;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;

public class TypedFieldExpr
extends LogicalExpressionBase {
    private final TypeProtos.MajorType type;
    private final SchemaPath path;

    public TypedFieldExpr(SchemaPath path, TypeProtos.MajorType type) {
        super(path.getPosition());
        this.path = path;
        this.type = type;
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitTypedFieldExpr(this, value);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return this.type;
    }

    public String toString() {
        return this.path.getRootSegment().getPath() + "(" + String.valueOf(this.type.getMinorType()) + "_" + String.valueOf(this.type.getMode()) + ")";
    }

    public SchemaPath getPath() {
        return this.path;
    }
}

