/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.util.Collections;
import java.util.Iterator;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyValueExpression
extends LogicalExpressionBase
implements Iterable<LogicalExpression> {
    static final Logger logger = LoggerFactory.getLogger(AnyValueExpression.class);
    public static final String ANY_VALUE = "any_value";
    private final LogicalExpression input;
    private final TypeProtos.MajorType type;

    public AnyValueExpression(LogicalExpression input, ExpressionPosition pos) {
        super(pos);
        this.input = input;
        this.type = input.getMajorType();
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitAnyValueExpression(this, value);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Collections.singleton(this.input).iterator();
    }

    public LogicalExpression getInput() {
        return this.input;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return this.type;
    }

    public String toString() {
        return "AnyValueExpression [input=" + String.valueOf(this.input) + ", type=" + Types.toString(this.type) + "]";
    }
}

