/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.collections;

import java.util.Map;
import oadd.com.google.common.base.Objects;
import oadd.com.google.common.base.Preconditions;

public class ImmutableEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;

    public ImmutableEntry(K key, V value) {
        this.key = Preconditions.checkNotNull(key, "key is required");
        this.value = Preconditions.checkNotNull(value, "value is required");
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("entry is immutable");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)other;
        return Objects.equal(this.key, entry.getKey()) && Objects.equal(this.value, entry.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key, this.value);
    }

    public String toString() {
        return "(" + this.key.toString() + ", " + this.value.toString() + ")";
    }
}

