/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.x.discovery.strategies;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.org.apache.curator.x.discovery.ProviderStrategy;
import oadd.org.apache.curator.x.discovery.ServiceInstance;
import oadd.org.apache.curator.x.discovery.details.InstanceProvider;

public class RoundRobinStrategy<T>
implements ProviderStrategy<T> {
    private final AtomicInteger index = new AtomicInteger(0);

    @Override
    public ServiceInstance<T> getInstance(InstanceProvider<T> instanceProvider) throws Exception {
        List<ServiceInstance<T>> instances = instanceProvider.getInstances();
        if (instances.size() == 0) {
            return null;
        }
        int thisIndex = Math.abs(this.index.getAndIncrement());
        return instances.get(thisIndex % instances.size());
    }
}

