/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import hive.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReExecDriver
implements IDriver {
    private static final Logger LOG = LoggerFactory.getLogger(ReExecDriver.class);
    private boolean explainReOptimization;
    protected Driver coreDriver;
    private QueryState queryState;
    private String currentQuery;
    private int executionIndex;
    private ArrayList<IReExecutionPlugin> plugins;

    @Override
    public HiveConf getConf() {
        return this.queryState.getConf();
    }

    public boolean firstExecution() {
        return this.executionIndex == 0;
    }

    public ReExecDriver(QueryState queryState, String userName, QueryInfo queryInfo, ArrayList<IReExecutionPlugin> plugins) {
        this.queryState = queryState;
        this.coreDriver = new Driver(queryState, userName, queryInfo, null);
        this.coreDriver.getHookRunner().addSemanticAnalyzerHook(new HandleReOptimizationExplain());
        this.plugins = plugins;
        for (IReExecutionPlugin p : plugins) {
            p.initialize(this.coreDriver);
        }
    }

    @Override
    public int compile(String string) {
        return this.coreDriver.compile(string);
    }

    @Override
    public CommandProcessorResponse compileAndRespond(String statement) {
        this.currentQuery = statement;
        return this.coreDriver.compileAndRespond(statement);
    }

    @Override
    public QueryPlan getPlan() {
        return this.coreDriver.getPlan();
    }

    @Override
    public QueryDisplay getQueryDisplay() {
        return this.coreDriver.getQueryDisplay();
    }

    @Override
    public void setOperationId(String guid64) {
        this.coreDriver.setOperationId(guid64);
    }

    @Override
    public CommandProcessorResponse run() {
        CommandProcessorResponse cpr;
        PlanMapper newPlanMapper;
        PlanMapper oldPlanMapper;
        this.executionIndex = 0;
        int maxExecutuions = 1 + this.coreDriver.getConf().getIntVar(HiveConf.ConfVars.HIVE_QUERY_MAX_REEXECUTION_COUNT);
        do {
            ++this.executionIndex;
            for (IReExecutionPlugin p : this.plugins) {
                p.beforeExecute(this.executionIndex, this.explainReOptimization);
            }
            this.coreDriver.getContext().setExecutionIndex(this.executionIndex);
            LOG.info("Execution #{} of query", (Object)this.executionIndex);
            cpr = this.coreDriver.run();
            oldPlanMapper = this.coreDriver.getPlanMapper();
            this.afterExecute(oldPlanMapper, cpr.getResponseCode() == 0);
            boolean shouldReExecute = this.explainReOptimization && this.executionIndex == 1;
            if (this.executionIndex >= maxExecutuions || !(shouldReExecute |= cpr.getResponseCode() != 0 && this.shouldReExecute())) {
                return cpr;
            }
            LOG.info("Preparing to re-execute query");
            this.prepareToReExecute();
            CommandProcessorResponse compile_resp = this.coreDriver.compileAndRespond(this.currentQuery);
            if (compile_resp.failed()) {
                LOG.error("Recompilation of the query failed; this is unexpected.");
                return compile_resp;
            }
            newPlanMapper = this.coreDriver.getPlanMapper();
        } while (this.explainReOptimization || this.shouldReExecuteAfterCompile(oldPlanMapper, newPlanMapper));
        LOG.info("re-running the query would probably not yield better results; returning with last error");
        return cpr;
    }

    private void afterExecute(PlanMapper planMapper, boolean success) {
        for (IReExecutionPlugin p : this.plugins) {
            p.afterExecute(planMapper, success);
        }
    }

    private boolean shouldReExecuteAfterCompile(PlanMapper oldPlanMapper, PlanMapper newPlanMapper) {
        boolean ret = false;
        for (IReExecutionPlugin p : this.plugins) {
            boolean shouldReExecute = p.shouldReExecute(this.executionIndex, oldPlanMapper, newPlanMapper);
            LOG.debug("{}.shouldReExecuteAfterCompile = {}", (Object)p, (Object)shouldReExecute);
            ret |= shouldReExecute;
        }
        return ret;
    }

    private boolean shouldReExecute() {
        boolean ret = false;
        for (IReExecutionPlugin p : this.plugins) {
            boolean shouldReExecute = p.shouldReExecute(this.executionIndex);
            LOG.debug("{}.shouldReExecute = {}", (Object)p, (Object)shouldReExecute);
            ret |= shouldReExecute;
        }
        return ret;
    }

    @Override
    public CommandProcessorResponse run(String command) {
        CommandProcessorResponse r0 = this.compileAndRespond(command);
        if (r0.getResponseCode() != 0) {
            return r0;
        }
        return this.run();
    }

    protected void prepareToReExecute() {
        for (IReExecutionPlugin p : this.plugins) {
            p.prepareToReExecute();
        }
    }

    @Override
    public boolean getResults(List res) throws IOException {
        return this.coreDriver.getResults(res);
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.coreDriver.setMaxRows(maxRows);
    }

    @Override
    public FetchTask getFetchTask() {
        return this.coreDriver.getFetchTask();
    }

    @Override
    public Schema getSchema() {
        if (this.explainReOptimization) {
            return this.coreDriver.getExplainSchema();
        }
        return this.coreDriver.getSchema();
    }

    @Override
    public boolean isFetchingTable() {
        return this.coreDriver.isFetchingTable();
    }

    @Override
    public void resetFetch() throws IOException {
        this.coreDriver.resetFetch();
    }

    @Override
    public void close() {
        this.coreDriver.close();
    }

    @Override
    public void destroy() {
        this.coreDriver.destroy();
    }

    @Override
    public final Context getContext() {
        return this.coreDriver.getContext();
    }

    @VisibleForTesting
    public void setStatsSource(StatsSource statsSource) {
        this.coreDriver.setStatsSource(statsSource);
    }

    @Override
    public boolean hasResultSet() {
        return this.explainReOptimization || this.coreDriver.hasResultSet();
    }

    private class HandleReOptimizationExplain
    implements HiveSemanticAnalyzerHook {
        private HandleReOptimizationExplain() {
        }

        @Override
        public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
            if (ast.getType() == 830) {
                int childCount = ast.getChildCount();
                for (int i = 1; i < childCount; ++i) {
                    if (ast.getChild(i).getType() != 255) continue;
                    ReExecDriver.this.explainReOptimization = true;
                    ast.deleteChild(i);
                    break;
                }
                if (ReExecDriver.this.explainReOptimization && ReExecDriver.this.firstExecution()) {
                    Tree execTree = ast.getChild(0);
                    execTree.setParent(ast.getParent());
                    ast.getParent().setChild(0, execTree);
                    return (ASTNode)execTree;
                }
            }
            return ast;
        }

        @Override
        public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        }
    }
}

