/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import hive.com.fasterxml.jackson.annotation.JsonIdentityInfo;
import hive.com.fasterxml.jackson.annotation.JsonProperty;
import hive.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.signature.OpSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignatureFactory;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
public final class OpTreeSignature {
    @JsonProperty
    private int hashCode;
    @JsonProperty
    private OpSignature sig;
    @JsonProperty
    private ArrayList<OpTreeSignature> parentSig;

    private OpTreeSignature() {
    }

    OpTreeSignature(Operator<?> op, OpTreeSignatureFactory osf) {
        this.sig = OpSignature.of(op);
        this.parentSig = new ArrayList();
        for (Operator<OperatorDesc> parentOp : op.getParentOperators()) {
            this.parentSig.add(osf.getSignature(parentOp));
        }
        this.hashCode = Objects.hash(this.sig, this.parentSig);
    }

    public static OpTreeSignature of(Operator<?> root) {
        return OpTreeSignature.of(root, OpTreeSignatureFactory.DIRECT);
    }

    public static OpTreeSignature of(Operator<? extends OperatorDesc> op, OpTreeSignatureFactory osf) {
        return new OpTreeSignature(op, osf);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OpTreeSignature)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        OpTreeSignature o = (OpTreeSignature)obj;
        return this.sig.equals(o.sig) && this.parentSig.equals(o.parentSig);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pad) {
        StringBuffer sb = new StringBuffer();
        sb.append(pad + "hashcode:" + this.hashCode + "\n");
        sb.append(this.sig.toString(pad));
        for (OpTreeSignature p : this.parentSig) {
            sb.append(p.toString(pad + " "));
        }
        return sb.toString();
    }

    public OpSignature getSig() {
        return this.sig;
    }

    public ArrayList<OpTreeSignature> getParentSig() {
        return this.parentSig;
    }
}

