/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableSet;
import hive.org.apache.commons.lang.ArrayUtils;
import hive.org.apache.commons.lang3.tuple.ImmutablePair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.SparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnOutputMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSourceMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOuterFilteredOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedUDAFs;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkCommonOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkEmptyKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkObjectHashOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFArgDesc;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.NullRowsInputFormat;
import org.apache.hadoop.hive.ql.io.OneNullRowInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.VectorizerReason;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.VectorAppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorFileSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorFilterDesc;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.plan.VectorLimitDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.VectorPTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFInfo;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkInfo;
import org.apache.hadoop.hive.ql.plan.VectorSMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorSelectDesc;
import org.apache.hadoop.hive.ql.plan.VectorSparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorSparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorTableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDayOfWeek;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCharacterLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLag;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLead;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOctetLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRegExp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalDayTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalYearMonth;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.NullStructSerDe;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vectorizer
implements PhysicalPlanResolver {
    protected static final transient Logger LOG = LoggerFactory.getLogger(Vectorizer.class);
    private static final Pattern supportedDataTypesPattern;
    private Set<Class<?>> supportedGenericUDFs = new HashSet();
    private Set<String> supportedAggregationUdfs = new HashSet<String>();
    public static final ImmutableSet<VirtualColumn> vectorizableVirtualColumns;
    private HiveConf hiveConf;
    boolean isVectorizationEnabled;
    private VectorizationEnabledOverride vectorizationEnabledOverride;
    boolean isTestForcedVectorizationEnable;
    private boolean useVectorizedInputFileFormat;
    private boolean useVectorDeserialize;
    private boolean useRowDeserialize;
    private boolean isReduceVectorizationEnabled;
    private boolean isPtfVectorizationEnabled;
    private boolean isVectorizationComplexTypesEnabled;
    private boolean isVectorizationGroupByComplexTypesEnabled;
    private boolean isVectorizedRowIdentifierEnabled;
    private String vectorizedInputFormatSupportEnabled;
    private boolean isLlapIoEnabled;
    private Set<VectorizedSupport.Support> vectorizedInputFormatSupportEnabledSet;
    private Collection<Class<?>> rowDeserializeInputFormatExcludes;
    private int vectorizedPTFMaxMemoryBufferingBatchCount;
    private int vectorizedTestingReducerBatchSize;
    private boolean isTestVectorizerSuppressFatalExceptions;
    private boolean isSchemaEvolution;
    private VectorizationContext.HiveVectorAdaptorUsageMode hiveVectorAdaptorUsageMode;
    private static final Set<VectorizedSupport.Support> vectorDeserializeTextSupportSet;
    private static final Set<String> supportedAcidInputFormats;
    private boolean isTestVectorizationSuppressExplainExecutionMode;
    private BaseWork currentBaseWork;
    private Operator<? extends OperatorDesc> currentOperator;
    private Collection<Class<?>> vectorizedInputFormatExcludes;
    private Map<Operator<? extends OperatorDesc>, Set<ImmutablePair<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>>> delayedFixups = new IdentityHashMap<Operator<? extends OperatorDesc>, Set<ImmutablePair<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>>>();
    private long vectorizedVertexNum = -1L;
    private Set<VirtualColumn> availableVectorizedVirtualColumnSet = null;
    private Set<VirtualColumn> neededVirtualColumnSet = null;
    private PlanMapper planMapper;

    public void testSetCurrentBaseWork(BaseWork testBaseWork) {
        this.currentBaseWork = testBaseWork;
    }

    private void setNodeIssue(String issue) {
        this.currentBaseWork.setNotVectorizedReason(VectorizerReason.createNodeIssue(issue));
    }

    private void setOperatorIssue(String issue) {
        this.currentBaseWork.setNotVectorizedReason(VectorizerReason.createOperatorIssue(this.currentOperator, issue));
    }

    private void setExpressionIssue(String expressionTitle, String issue) {
        this.currentBaseWork.setNotVectorizedReason(VectorizerReason.createExpressionIssue(this.currentOperator, expressionTitle, issue));
    }

    private void clearNotVectorizedReason() {
        this.currentBaseWork.setNotVectorizedReason(null);
    }

    public Vectorizer() {
        this.supportedGenericUDFs.add(GenericUDFOPPlus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMinus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMultiply.class);
        this.supportedGenericUDFs.add(GenericUDFOPDivide.class);
        this.supportedGenericUDFs.add(GenericUDFOPMod.class);
        this.supportedGenericUDFs.add(GenericUDFOPNegative.class);
        this.supportedGenericUDFs.add(GenericUDFOPPositive.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPNot.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotEqual.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPOr.class);
        this.supportedGenericUDFs.add(GenericUDFOPAnd.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqual.class);
        this.supportedGenericUDFs.add(GenericUDFLength.class);
        this.supportedGenericUDFs.add(GenericUDFCharacterLength.class);
        this.supportedGenericUDFs.add(GenericUDFOctetLength.class);
        this.supportedGenericUDFs.add(UDFYear.class);
        this.supportedGenericUDFs.add(UDFMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfWeek.class);
        this.supportedGenericUDFs.add(UDFHour.class);
        this.supportedGenericUDFs.add(UDFMinute.class);
        this.supportedGenericUDFs.add(UDFSecond.class);
        this.supportedGenericUDFs.add(UDFWeekOfYear.class);
        this.supportedGenericUDFs.add(GenericUDFToUnixTimeStamp.class);
        this.supportedGenericUDFs.add(UDFFromUnixTime.class);
        this.supportedGenericUDFs.add(GenericUDFDateAdd.class);
        this.supportedGenericUDFs.add(GenericUDFDateSub.class);
        this.supportedGenericUDFs.add(GenericUDFDate.class);
        this.supportedGenericUDFs.add(GenericUDFDateDiff.class);
        this.supportedGenericUDFs.add(UDFLike.class);
        this.supportedGenericUDFs.add(GenericUDFRegExp.class);
        this.supportedGenericUDFs.add(UDFRegExpExtract.class);
        this.supportedGenericUDFs.add(UDFRegExpReplace.class);
        this.supportedGenericUDFs.add(UDFSubstr.class);
        this.supportedGenericUDFs.add(GenericUDFLTrim.class);
        this.supportedGenericUDFs.add(GenericUDFRTrim.class);
        this.supportedGenericUDFs.add(GenericUDFTrim.class);
        this.supportedGenericUDFs.add(UDFSin.class);
        this.supportedGenericUDFs.add(UDFCos.class);
        this.supportedGenericUDFs.add(UDFTan.class);
        this.supportedGenericUDFs.add(UDFAsin.class);
        this.supportedGenericUDFs.add(UDFAcos.class);
        this.supportedGenericUDFs.add(UDFAtan.class);
        this.supportedGenericUDFs.add(UDFDegrees.class);
        this.supportedGenericUDFs.add(UDFRadians.class);
        this.supportedGenericUDFs.add(GenericUDFFloor.class);
        this.supportedGenericUDFs.add(GenericUDFCeil.class);
        this.supportedGenericUDFs.add(UDFExp.class);
        this.supportedGenericUDFs.add(UDFLn.class);
        this.supportedGenericUDFs.add(UDFLog2.class);
        this.supportedGenericUDFs.add(UDFLog10.class);
        this.supportedGenericUDFs.add(UDFLog.class);
        this.supportedGenericUDFs.add(GenericUDFPower.class);
        this.supportedGenericUDFs.add(GenericUDFRound.class);
        this.supportedGenericUDFs.add(GenericUDFBRound.class);
        this.supportedGenericUDFs.add(GenericUDFPosMod.class);
        this.supportedGenericUDFs.add(UDFSqrt.class);
        this.supportedGenericUDFs.add(UDFSign.class);
        this.supportedGenericUDFs.add(UDFRand.class);
        this.supportedGenericUDFs.add(UDFBin.class);
        this.supportedGenericUDFs.add(UDFHex.class);
        this.supportedGenericUDFs.add(UDFConv.class);
        this.supportedGenericUDFs.add(GenericUDFLower.class);
        this.supportedGenericUDFs.add(GenericUDFUpper.class);
        this.supportedGenericUDFs.add(GenericUDFConcat.class);
        this.supportedGenericUDFs.add(GenericUDFAbs.class);
        this.supportedGenericUDFs.add(GenericUDFBetween.class);
        this.supportedGenericUDFs.add(GenericUDFIn.class);
        this.supportedGenericUDFs.add(GenericUDFCase.class);
        this.supportedGenericUDFs.add(GenericUDFWhen.class);
        this.supportedGenericUDFs.add(GenericUDFCoalesce.class);
        this.supportedGenericUDFs.add(GenericUDFNvl.class);
        this.supportedGenericUDFs.add(GenericUDFElt.class);
        this.supportedGenericUDFs.add(GenericUDFInitCap.class);
        this.supportedGenericUDFs.add(GenericUDFInBloomFilter.class);
        this.supportedGenericUDFs.add(UDFToLong.class);
        this.supportedGenericUDFs.add(UDFToInteger.class);
        this.supportedGenericUDFs.add(UDFToShort.class);
        this.supportedGenericUDFs.add(UDFToByte.class);
        this.supportedGenericUDFs.add(UDFToBoolean.class);
        this.supportedGenericUDFs.add(UDFToFloat.class);
        this.supportedGenericUDFs.add(UDFToDouble.class);
        this.supportedGenericUDFs.add(UDFToString.class);
        this.supportedGenericUDFs.add(GenericUDFTimestamp.class);
        this.supportedGenericUDFs.add(GenericUDFToDecimal.class);
        this.supportedGenericUDFs.add(GenericUDFToDate.class);
        this.supportedGenericUDFs.add(GenericUDFToChar.class);
        this.supportedGenericUDFs.add(GenericUDFToVarchar.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalYearMonth.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalDayTime.class);
        this.supportedGenericUDFs.add(GenericUDFIf.class);
        this.supportedAggregationUdfs.add("min");
        this.supportedAggregationUdfs.add("max");
        this.supportedAggregationUdfs.add("count");
        this.supportedAggregationUdfs.add("sum");
        this.supportedAggregationUdfs.add("avg");
        this.supportedAggregationUdfs.add("variance");
        this.supportedAggregationUdfs.add("var_pop");
        this.supportedAggregationUdfs.add("var_samp");
        this.supportedAggregationUdfs.add("std");
        this.supportedAggregationUdfs.add("stddev");
        this.supportedAggregationUdfs.add("stddev_pop");
        this.supportedAggregationUdfs.add("stddev_samp");
        this.supportedAggregationUdfs.add("bloom_filter");
    }

    private List<Operator<? extends OperatorDesc>> newOperatorList() {
        return new ArrayList<Operator<? extends OperatorDesc>>();
    }

    private Operator<? extends OperatorDesc> validateAndVectorizeOperatorTree(Operator<? extends OperatorDesc> nonVecRootOperator, boolean isReduce, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws VectorizerCannotVectorizeException {
        VectorizationContext taskVContext = new VectorizationContext("Task", vectorTaskColumnInfo.allColumnNames, vectorTaskColumnInfo.allTypeInfos, vectorTaskColumnInfo.allDataTypePhysicalVariations, this.hiveConf);
        List<Operator<? extends OperatorDesc>> currentParentList = this.newOperatorList();
        currentParentList.add(nonVecRootOperator);
        DummyVectorOperator dummyVectorOperator = new DummyVectorOperator(taskVContext);
        List<Operator<? extends OperatorDesc>> currentVectorParentList = this.newOperatorList();
        currentVectorParentList.add(dummyVectorOperator);
        this.delayedFixups.clear();
        do {
            List<Operator<? extends OperatorDesc>> nextParentList = this.newOperatorList();
            List<Operator<? extends OperatorDesc>> nextVectorParentList = this.newOperatorList();
            int count = currentParentList.size();
            for (int i = 0; i < count; ++i) {
                Operator<? extends OperatorDesc> parent = currentParentList.get(i);
                List<Operator<OperatorDesc>> childrenList = parent.getChildOperators();
                if (childrenList == null || childrenList.size() == 0) continue;
                Operator<? extends OperatorDesc> vectorParent = currentVectorParentList.get(i);
                this.doProcessChildren(parent, vectorParent, nextParentList, nextVectorParentList, isReduce, isTezOrSpark, vectorTaskColumnInfo);
            }
            currentParentList = nextParentList;
            currentVectorParentList = nextVectorParentList;
        } while (currentParentList.size() > 0);
        this.runDelayedFixups();
        return dummyVectorOperator;
    }

    private void doProcessChildren(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> vectorParent, List<Operator<? extends OperatorDesc>> nextParentList, List<Operator<? extends OperatorDesc>> nextVectorParentList, boolean isReduce, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws VectorizerCannotVectorizeException {
        List<Operator<? extends OperatorDesc>> vectorChildren = this.newOperatorList();
        List<Operator<OperatorDesc>> children = parent.getChildOperators();
        ArrayList listOfChildMultipleParents = new ArrayList();
        int childrenCount = children.size();
        for (int i = 0; i < childrenCount; ++i) {
            Operator<OperatorDesc> child = children.get(i);
            Operator<? extends OperatorDesc> vectorChild = this.doProcessChild(child, vectorParent, isReduce, isTezOrSpark, vectorTaskColumnInfo);
            this.fixupNewVectorChild(parent, vectorParent, child, vectorChild);
            nextParentList.add(child);
            nextVectorParentList.add(vectorChild);
        }
    }

    private void fixupNewVectorChild(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> vectorParent, Operator<? extends OperatorDesc> child, Operator<? extends OperatorDesc> vectorChild) {
        vectorParent.getChildOperators().add(vectorChild);
        List<Operator<? extends OperatorDesc>> childMultipleParents = this.newOperatorList();
        childMultipleParents.addAll(child.getParentOperators());
        int childMultipleParentCount = childMultipleParents.size();
        for (int i = 0; i < childMultipleParentCount; ++i) {
            Operator<? extends OperatorDesc> childMultipleParent = childMultipleParents.get(i);
            if (childMultipleParent == parent) {
                childMultipleParents.set(i, vectorParent);
                continue;
            }
            this.queueDelayedFixup(childMultipleParent, child, vectorChild);
        }
        vectorChild.setParentOperators(childMultipleParents);
    }

    private void queueDelayedFixup(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> child, Operator<? extends OperatorDesc> vectorChild) {
        if (this.delayedFixups.get(parent) == null) {
            HashSet value = new HashSet(1);
            this.delayedFixups.put(parent, value);
        }
        this.delayedFixups.get(parent).add(new ImmutablePair<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>(child, vectorChild));
    }

    private void runDelayedFixups() {
        for (Map.Entry<Operator<? extends OperatorDesc>, Set<ImmutablePair<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>>> delayed : this.delayedFixups.entrySet()) {
            Operator<? extends OperatorDesc> key = delayed.getKey();
            Set<ImmutablePair<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>> value = delayed.getValue();
            for (ImmutablePair<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>> swap : value) {
                this.fixupOtherParent(key, swap.getLeft(), swap.getRight());
            }
        }
        this.delayedFixups.clear();
    }

    private void fixupOtherParent(Operator<? extends OperatorDesc> childMultipleParent, Operator<? extends OperatorDesc> child, Operator<? extends OperatorDesc> vectorChild) {
        List<Operator<OperatorDesc>> children = childMultipleParent.getChildOperators();
        int childrenCount = children.size();
        for (int i = 0; i < childrenCount; ++i) {
            Operator<OperatorDesc> myChild = children.get(i);
            if (myChild != child) continue;
            children.set(i, vectorChild);
        }
    }

    private Operator<? extends OperatorDesc> doProcessChild(Operator<? extends OperatorDesc> child, Operator<? extends OperatorDesc> vectorParent, boolean isReduce, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws VectorizerCannotVectorizeException {
        Operator<? extends OperatorDesc> vectorChild;
        VectorizationContext vContext = vectorParent instanceof VectorizationContextRegion ? ((VectorizationContextRegion)((Object)vectorParent)).getOutputVectorizationContext() : ((VectorizationOperator)((Object)vectorParent)).getInputVectorizationContext();
        OperatorDesc desc = child.getConf();
        try {
            vectorChild = this.validateAndVectorizeOperator(child, vContext, isReduce, isTezOrSpark, vectorTaskColumnInfo);
        }
        catch (HiveException e) {
            String issue = "exception: " + VectorizationContext.getStackTraceAsSingleLine(e);
            this.setNodeIssue(issue);
            throw new VectorizerCannotVectorizeException();
        }
        return vectorChild;
    }

    @Override
    public PhysicalContext resolve(PhysicalContext physicalContext) throws SemanticException {
        boolean weCanAttemptVectorization;
        this.hiveConf = physicalContext.getConf();
        this.planMapper = physicalContext.getContext().getPlanMapper();
        String vectorizationEnabledOverrideString = HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.HIVE_TEST_VECTORIZATION_ENABLED_OVERRIDE);
        this.vectorizationEnabledOverride = VectorizationEnabledOverride.nameMap.get(vectorizationEnabledOverrideString);
        this.isVectorizationEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        this.isTestForcedVectorizationEnable = false;
        switch (this.vectorizationEnabledOverride) {
            case NONE: {
                weCanAttemptVectorization = this.isVectorizationEnabled;
                break;
            }
            case DISABLE: {
                weCanAttemptVectorization = false;
                break;
            }
            case ENABLE: {
                weCanAttemptVectorization = true;
                this.isTestForcedVectorizationEnable = !this.isVectorizationEnabled;
                HiveConf.setBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
                this.isVectorizationEnabled = true;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected vectorization enabled override " + (Object)((Object)this.vectorizationEnabledOverride));
            }
        }
        if (!weCanAttemptVectorization) {
            LOG.info("Vectorization is disabled");
            return physicalContext;
        }
        this.useVectorizedInputFileFormat = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT);
        if (this.useVectorizedInputFileFormat) {
            this.initVectorizedInputFormatExcludeClasses();
        }
        this.useVectorDeserialize = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE);
        this.useRowDeserialize = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE);
        if (this.useRowDeserialize) {
            this.initRowDeserializeExcludeClasses();
        }
        this.isReduceVectorizationEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED);
        this.isPtfVectorizationEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_PTF_ENABLED);
        this.isVectorizationComplexTypesEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_COMPLEX_TYPES_ENABLED);
        this.isVectorizationGroupByComplexTypesEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_COMPLEX_TYPES_ENABLED);
        this.isVectorizedRowIdentifierEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_ROW_IDENTIFIER_ENABLED);
        this.vectorizedPTFMaxMemoryBufferingBatchCount = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_PTF_MAX_MEMORY_BUFFERING_BATCH_COUNT);
        this.vectorizedTestingReducerBatchSize = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_TESTING_REDUCER_BATCH_SIZE);
        this.isTestVectorizerSuppressFatalExceptions = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_TEST_VECTORIZER_SUPPRESS_FATAL_EXCEPTIONS);
        this.vectorizedInputFormatSupportEnabled = HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED);
        String[] supportEnabledStrings = this.vectorizedInputFormatSupportEnabled.toLowerCase().split(",");
        this.vectorizedInputFormatSupportEnabledSet = new TreeSet<VectorizedSupport.Support>();
        for (String supportEnabledString : supportEnabledStrings) {
            VectorizedSupport.Support support = VectorizedSupport.Support.nameToSupportMap.get(supportEnabledString);
            if (support == null) continue;
            this.vectorizedInputFormatSupportEnabledSet.add(support);
        }
        this.isLlapIoEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.LLAP_IO_ENABLED, LlapProxy.isDaemon());
        this.isSchemaEvolution = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
        this.hiveVectorAdaptorUsageMode = VectorizationContext.HiveVectorAdaptorUsageMode.getHiveConfValue(this.hiveConf);
        this.isTestVectorizationSuppressExplainExecutionMode = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_TEST_VECTORIZATION_SUPPRESS_EXPLAIN_EXECUTION_MODE);
        VectorizationDispatcher disp = new VectorizationDispatcher();
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(physicalContext.getRootTasks());
        ogw.startWalking(topNodes, null);
        return physicalContext;
    }

    private void initVectorizedInputFormatExcludeClasses() {
        this.vectorizedInputFormatExcludes = Utilities.getClassNamesFromConfig(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_VECTORIZED_INPUT_FILE_FORMAT_EXCLUDES);
    }

    private void initRowDeserializeExcludeClasses() {
        this.rowDeserializeInputFormatExcludes = Utilities.getClassNamesFromConfig(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_ROW_DESERIALIZE_INPUTFORMAT_EXCLUDES);
    }

    private void setOperatorNotSupported(Operator<? extends OperatorDesc> op) {
        OperatorDesc desc = op.getConf();
        Explain note = AnnotationUtils.getAnnotation(desc.getClass(), Explain.class);
        if (note != null) {
            Explain explainNote = note;
            this.setNodeIssue(explainNote.displayName() + " (" + op.getType() + ") not supported");
        } else {
            this.setNodeIssue("Operator " + op.getType() + " not supported");
        }
    }

    private boolean validateSMBMapJoinOperator(SMBMapJoinOperator op) {
        SMBJoinDesc desc = (SMBJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateTableScanOperator(TableScanOperator op, MapWork mWork) {
        TableScanDesc desc = (TableScanDesc)op.getConf();
        if (desc.isGatherStats()) {
            this.setOperatorIssue("gather stats not supported");
            return false;
        }
        return true;
    }

    private boolean validateMapJoinOperator(MapJoinOperator op) {
        MapJoinDesc desc = (MapJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateMapJoinDesc(MapJoinDesc desc) {
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(posBigTable);
        if (!this.validateExprNodeDesc(filterExprs, "Filter", VectorExpressionDescriptor.Mode.FILTER, true)) {
            return false;
        }
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(posBigTable);
        if (!this.validateExprNodeDesc(keyExprs, "Key")) {
            return false;
        }
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(posBigTable);
        if (!this.validateExprNodeDesc(valueExprs, "Value")) {
            return false;
        }
        Byte[] order = desc.getTagOrder();
        Byte posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        List<ExprNodeDesc> smallTableExprs = desc.getExprs().get(posSingleVectorMapJoinSmallTable);
        if (!this.validateExprNodeDesc(smallTableExprs, "Small Table")) {
            return false;
        }
        if (desc.getResidualFilterExprs() != null && !desc.getResidualFilterExprs().isEmpty()) {
            this.setOperatorIssue("Non-equi joins not supported");
            return false;
        }
        return true;
    }

    private boolean validateSparkHashTableSinkOperator(SparkHashTableSinkOperator op) {
        SparkHashTableSinkDesc desc = (SparkHashTableSinkDesc)op.getConf();
        byte tag = desc.getTag();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(tag);
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(tag);
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(tag);
        return this.validateExprNodeDesc(filterExprs, "Filter", VectorExpressionDescriptor.Mode.FILTER, true) && this.validateExprNodeDesc(keyExprs, "Key") && this.validateExprNodeDesc(valueExprs, "Value");
    }

    private boolean validateReduceSinkOperator(ReduceSinkOperator op) {
        ArrayList<ExprNodeDesc> keyDescs = ((ReduceSinkDesc)op.getConf()).getKeyCols();
        ArrayList<ExprNodeDesc> partitionDescs = ((ReduceSinkDesc)op.getConf()).getPartitionCols();
        ArrayList<ExprNodeDesc> valueDesc = ((ReduceSinkDesc)op.getConf()).getValueCols();
        return this.validateExprNodeDesc(keyDescs, "Key") && this.validateExprNodeDesc(partitionDescs, "Partition") && this.validateExprNodeDesc(valueDesc, "Value");
    }

    private boolean validateSelectOperator(SelectOperator op) {
        List<ExprNodeDesc> descList = ((SelectDesc)op.getConf()).getColList();
        for (ExprNodeDesc desc : descList) {
            boolean ret = this.validateExprNodeDesc(desc, "Select", VectorExpressionDescriptor.Mode.PROJECTION, true, true);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateFilterOperator(FilterOperator op) {
        ExprNodeDesc desc = ((FilterDesc)op.getConf()).getPredicate();
        return this.validateExprNodeDesc(desc, "Predicate", VectorExpressionDescriptor.Mode.FILTER, true);
    }

    private boolean validateGroupByOperator(GroupByOperator op, boolean isReduce, boolean isTezOrSpark, VectorGroupByDesc vectorGroupByDesc) {
        GroupByDesc desc = (GroupByDesc)op.getConf();
        if (desc.getMode() != GroupByDesc.Mode.HASH && desc.isDistinct()) {
            this.setOperatorIssue("DISTINCT not supported");
            return false;
        }
        boolean ret = this.validateExprNodeDescNoComplex(desc.getKeys(), "Key");
        if (!ret) {
            return false;
        }
        boolean hasKeys = desc.getKeys().size() > 0;
        VectorGroupByDesc.ProcessingMode processingMode = VectorGroupByDesc.groupByDescModeToVectorProcessingMode(desc.getMode(), hasKeys);
        if (desc.isGroupingSetsPresent() && processingMode != VectorGroupByDesc.ProcessingMode.HASH && processingMode != VectorGroupByDesc.ProcessingMode.STREAMING) {
            this.setOperatorIssue("Vectorized GROUPING SETS only expected for HASH and STREAMING processing modes");
            return false;
        }
        if (!this.validateAggregationDescs(desc.getAggregators(), desc.getMode(), hasKeys)) {
            return false;
        }
        vectorGroupByDesc.setProcessingMode(processingMode);
        vectorGroupByDesc.setIsVectorizationComplexTypesEnabled(this.isVectorizationComplexTypesEnabled);
        vectorGroupByDesc.setIsVectorizationGroupByComplexTypesEnabled(this.isVectorizationGroupByComplexTypesEnabled);
        LOG.info("Vector GROUP BY operator will use processing mode " + processingMode.name());
        return true;
    }

    private boolean validateFileSinkOperator(FileSinkOperator op) {
        return true;
    }

    private boolean containsLeadLag(ExprNodeDesc exprNodeDesc) {
        if (exprNodeDesc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)exprNodeDesc;
            GenericUDF genFuncClass = genericFuncDesc.getGenericUDF();
            if (genFuncClass instanceof GenericUDFLag || genFuncClass instanceof GenericUDFLead) {
                return true;
            }
            return this.containsLeadLag(genericFuncDesc.getChildren());
        }
        return false;
    }

    private boolean containsLeadLag(List<ExprNodeDesc> exprNodeDescList) {
        for (ExprNodeDesc exprNodeDesc : exprNodeDescList) {
            if (!this.containsLeadLag(exprNodeDesc)) continue;
            return true;
        }
        return false;
    }

    private boolean validatePTFOperator(PTFOperator op, VectorizationContext vContext, VectorPTFDesc vectorPTFDesc) throws HiveException {
        boolean forNoop;
        Operator<OperatorDesc> ptfParent;
        if (!this.isPtfVectorizationEnabled) {
            this.setNodeIssue("Vectorization of PTF is not enabled (" + HiveConf.ConfVars.HIVE_VECTORIZATION_PTF_ENABLED.varname + " IS false)");
            return false;
        }
        PTFDesc ptfDesc = (PTFDesc)op.getConf();
        boolean isMapSide = ptfDesc.isMapSide();
        if (isMapSide) {
            this.setOperatorIssue("PTF Mapper not supported");
            return false;
        }
        List<Operator<OperatorDesc>> ptfParents = op.getParentOperators();
        if (ptfParents != null && ptfParents.size() > 0 && !((ptfParent = op.getParentOperators().get(0)) instanceof ReduceSinkOperator)) {
            boolean isReduceShufflePtf = false;
            if (ptfParent instanceof SelectOperator) {
                ptfParents = ptfParent.getParentOperators();
                if (ptfParents == null || ptfParents.size() == 0) {
                    isReduceShufflePtf = true;
                } else {
                    ptfParent = ptfParent.getParentOperators().get(0);
                    isReduceShufflePtf = ptfParent instanceof ReduceSinkOperator;
                }
            }
            if (!isReduceShufflePtf) {
                this.setOperatorIssue("Only PTF directly under reduce-shuffle is supported");
                return false;
            }
        }
        if (forNoop = ptfDesc.forNoop()) {
            this.setOperatorIssue("NOOP not supported");
            return false;
        }
        boolean forWindowing = ptfDesc.forWindowing();
        if (!forWindowing) {
            this.setOperatorIssue("Windowing required");
            return false;
        }
        PartitionedTableFunctionDef funcDef = ptfDesc.getFuncDef();
        boolean isWindowTableFunctionDef = funcDef instanceof WindowTableFunctionDef;
        if (!isWindowTableFunctionDef) {
            this.setOperatorIssue("Must be a WindowTableFunctionDef");
            return false;
        }
        try {
            Vectorizer.createVectorPTFDesc(op, ptfDesc, vContext, vectorPTFDesc, this.vectorizedPTFMaxMemoryBufferingBatchCount);
        }
        catch (HiveException e) {
            this.setOperatorIssue("exception: " + VectorizationContext.getStackTraceAsSingleLine(e));
            return false;
        }
        String[] outputColumnNames = vectorPTFDesc.getOutputColumnNames();
        TypeInfo[] outputTypeInfos = vectorPTFDesc.getOutputTypeInfos();
        int outputCount = outputColumnNames.length;
        for (int i = 0; i < outputCount; ++i) {
            String typeName = outputTypeInfos[i].getTypeName();
            boolean ret = Vectorizer.validateDataType(typeName, VectorExpressionDescriptor.Mode.PROJECTION, false);
            if (ret) continue;
            this.setExpressionIssue("PTF Output Columns", "Data type " + typeName + " of column " + outputColumnNames[i] + " not supported");
            return false;
        }
        boolean isPartitionOrderBy = vectorPTFDesc.getIsPartitionOrderBy();
        String[] evaluatorFunctionNames = vectorPTFDesc.getEvaluatorFunctionNames();
        int count = evaluatorFunctionNames.length;
        WindowFrameDef[] evaluatorWindowFrameDefs = vectorPTFDesc.getEvaluatorWindowFrameDefs();
        List<ExprNodeDesc>[] evaluatorInputExprNodeDescLists = vectorPTFDesc.getEvaluatorInputExprNodeDescLists();
        for (int i = 0; i < count; ++i) {
            boolean isSupportedType;
            List<ExprNodeDesc> exprNodeDescList;
            String functionName = evaluatorFunctionNames[i];
            VectorPTFDesc.SupportedFunctionType supportedFunctionType = VectorPTFDesc.supportedFunctionsMap.get(functionName);
            if (supportedFunctionType == null) {
                this.setOperatorIssue(functionName + " not in supported functions " + VectorPTFDesc.supportedFunctionNames);
                return false;
            }
            WindowFrameDef windowFrameDef = evaluatorWindowFrameDefs[i];
            if (!windowFrameDef.isStartUnbounded()) {
                this.setOperatorIssue(functionName + " only UNBOUNDED start frame is supported");
                return false;
            }
            switch (windowFrameDef.getWindowType()) {
                case RANGE: {
                    if (windowFrameDef.getEnd().isCurrentRow()) break;
                    this.setOperatorIssue(functionName + " only CURRENT ROW end frame is supported for RANGE");
                    return false;
                }
                case ROWS: {
                    if (windowFrameDef.isEndUnbounded()) break;
                    this.setOperatorIssue(functionName + " UNBOUNDED end frame is not supported for ROWS window type");
                    return false;
                }
                default: {
                    throw new RuntimeException("Unexpected window type " + (Object)((Object)windowFrameDef.getWindowType()));
                }
            }
            if ((exprNodeDescList = evaluatorInputExprNodeDescLists[i]) != null && exprNodeDescList.size() > 1) {
                this.setOperatorIssue("More than 1 argument expression of aggregation function " + functionName);
                return false;
            }
            if (exprNodeDescList == null) continue;
            ExprNodeDesc exprNodeDesc = exprNodeDescList.get(0);
            if (this.containsLeadLag(exprNodeDesc)) {
                this.setOperatorIssue("lead and lag function not supported in argument expression of aggregation function " + functionName);
                return false;
            }
            if (supportedFunctionType == VectorPTFDesc.SupportedFunctionType.COUNT || supportedFunctionType == VectorPTFDesc.SupportedFunctionType.DENSE_RANK || supportedFunctionType == VectorPTFDesc.SupportedFunctionType.RANK) continue;
            TypeInfo typeInfo = exprNodeDesc.getTypeInfo();
            ObjectInspector.Category category = typeInfo.getCategory();
            if (category != ObjectInspector.Category.PRIMITIVE) {
                isSupportedType = false;
            } else {
                ColumnVector.Type colVecType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
                switch (colVecType) {
                    case LONG: 
                    case DOUBLE: 
                    case DECIMAL: {
                        isSupportedType = true;
                        break;
                    }
                    default: {
                        isSupportedType = false;
                    }
                }
            }
            if (isSupportedType) continue;
            this.setOperatorIssue(typeInfo.getTypeName() + " data type not supported in argument expression of aggregation function " + functionName);
            return false;
        }
        return true;
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, String expressionTitle) {
        return this.validateExprNodeDesc(descs, expressionTitle, VectorExpressionDescriptor.Mode.PROJECTION, true);
    }

    private boolean validateExprNodeDescNoComplex(List<ExprNodeDesc> descs, String expressionTitle) {
        return this.validateExprNodeDesc(descs, expressionTitle, VectorExpressionDescriptor.Mode.PROJECTION, false);
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, String expressionTitle, VectorExpressionDescriptor.Mode mode, boolean allowComplex) {
        for (ExprNodeDesc d : descs) {
            boolean ret = this.validateExprNodeDesc(d, expressionTitle, mode, allowComplex);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateAggregationDescs(List<AggregationDesc> descs, GroupByDesc.Mode groupByMode, boolean hasKeys) {
        for (AggregationDesc d : descs) {
            if (this.validateAggregationDesc(d, groupByMode, hasKeys)) continue;
            return false;
        }
        return true;
    }

    private boolean validateExprNodeDescRecursive(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode, boolean allowComplex) {
        return this.validateExprNodeDescRecursive(desc, expressionTitle, mode, allowComplex, false);
    }

    private boolean validateExprNodeDescRecursive(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode, boolean allowComplex, boolean allowVoidProjection) {
        String typeName;
        boolean ret;
        if (desc instanceof ExprNodeColumnDesc) {
            VirtualColumn virtualColumn;
            ExprNodeColumnDesc c = (ExprNodeColumnDesc)desc;
            String columnName = c.getColumn();
            if (this.availableVectorizedVirtualColumnSet != null && (virtualColumn = VirtualColumn.VIRTUAL_COLUMN_NAME_MAP.get(columnName)) != null) {
                if (!this.availableVectorizedVirtualColumnSet.contains((Object)virtualColumn)) {
                    this.setExpressionIssue(expressionTitle, "Virtual column " + columnName + " is not supported");
                    return false;
                }
                this.neededVirtualColumnSet.add(virtualColumn);
            }
        }
        if (!(ret = Vectorizer.validateDataType(typeName = desc.getTypeInfo().getTypeName(), mode, allowComplex && this.isVectorizationComplexTypesEnabled, allowVoidProjection))) {
            this.setExpressionIssue(expressionTitle, Vectorizer.getValidateDataTypeErrorMsg(typeName, mode, allowComplex, this.isVectorizationComplexTypesEnabled));
            return false;
        }
        boolean isInExpression = false;
        if (desc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc d = (ExprNodeGenericFuncDesc)desc;
            boolean r = this.validateGenericUdf(d);
            if (!r) {
                this.setExpressionIssue(expressionTitle, "UDF " + d + " not supported");
                return false;
            }
            GenericUDF genericUDF = d.getGenericUDF();
            isInExpression = genericUDF instanceof GenericUDFIn;
        }
        if (desc.getChildren() != null) {
            if (isInExpression && desc.getChildren().get(0).getTypeInfo().getCategory() == ObjectInspector.Category.STRUCT) {
                if (!this.validateStructInExpression(desc, expressionTitle, VectorExpressionDescriptor.Mode.FILTER)) {
                    return false;
                }
            } else {
                for (ExprNodeDesc d : desc.getChildren()) {
                    if (this.validateExprNodeDescRecursive(d, expressionTitle, VectorExpressionDescriptor.Mode.FILTER, true, allowVoidProjection)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateStructInExpression(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : desc.getChildren()) {
            TypeInfo typeInfo = d.getTypeInfo();
            if (typeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                return false;
            }
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
            ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
            int fieldCount = fieldTypeInfos.size();
            for (int f = 0; f < fieldCount; ++f) {
                TypeInfo fieldTypeInfo = fieldTypeInfos.get(f);
                ObjectInspector.Category category = fieldTypeInfo.getCategory();
                if (category != ObjectInspector.Category.PRIMITIVE) {
                    this.setExpressionIssue(expressionTitle, "Cannot vectorize struct field " + fieldNames.get(f) + " of type " + fieldTypeInfo.getTypeName());
                    return false;
                }
                PrimitiveTypeInfo fieldPrimitiveTypeInfo = (PrimitiveTypeInfo)fieldTypeInfo;
                VectorizationContext.InConstantType inConstantType = VectorizationContext.getInConstantTypeFromPrimitiveCategory(fieldPrimitiveTypeInfo.getPrimitiveCategory());
                if (inConstantType == VectorizationContext.InConstantType.INT_FAMILY || inConstantType == VectorizationContext.InConstantType.FLOAT_FAMILY || inConstantType == VectorizationContext.InConstantType.STRING_FAMILY) continue;
                this.setExpressionIssue(expressionTitle, "Cannot vectorize struct field " + fieldNames.get(f) + " of type " + fieldTypeInfo.getTypeName());
                return false;
            }
        }
        return true;
    }

    private boolean validateExprNodeDesc(ExprNodeDesc desc, String expressionTitle) {
        return this.validateExprNodeDesc(desc, expressionTitle, VectorExpressionDescriptor.Mode.PROJECTION, true, false);
    }

    boolean validateExprNodeDesc(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode, boolean allowComplex) {
        return this.validateExprNodeDescRecursive(desc, expressionTitle, mode, allowComplex);
    }

    boolean validateExprNodeDesc(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode, boolean allowComplex, boolean allowVoidProjection) {
        return this.validateExprNodeDescRecursive(desc, expressionTitle, mode, allowComplex, allowVoidProjection);
    }

    private boolean validateGenericUdf(ExprNodeGenericFuncDesc genericUDFExpr) {
        if (VectorizationContext.isCustomUDF(genericUDFExpr)) {
            return true;
        }
        if (this.hiveVectorAdaptorUsageMode == VectorizationContext.HiveVectorAdaptorUsageMode.NONE || this.hiveVectorAdaptorUsageMode == VectorizationContext.HiveVectorAdaptorUsageMode.CHOSEN) {
            GenericUDF genericUDF = genericUDFExpr.getGenericUDF();
            if (genericUDF instanceof GenericUDFBridge) {
                Class<? extends UDF> udf = ((GenericUDFBridge)genericUDF).getUdfClass();
                return this.supportedGenericUDFs.contains(udf);
            }
            return this.supportedGenericUDFs.contains(genericUDF.getClass());
        }
        return true;
    }

    private boolean validateAggregationDesc(AggregationDesc aggDesc, GroupByDesc.Mode groupByMode, boolean hasKeys) {
        String udfName = aggDesc.getGenericUDAFName().toLowerCase();
        if (!this.supportedAggregationUdfs.contains(udfName)) {
            this.setExpressionIssue("Aggregation Function", "UDF " + udfName + " not supported");
            return false;
        }
        if (aggDesc.getDistinct()) {
            this.setExpressionIssue("Aggregation Function", "DISTINCT not supported");
            return false;
        }
        ArrayList<ExprNodeDesc> parameters = aggDesc.getParameters();
        return parameters == null || this.validateExprNodeDesc(parameters, "Aggregation Function UDF " + udfName + " parameter");
    }

    public static boolean validateDataType(String type, VectorExpressionDescriptor.Mode mode, boolean allowComplex) {
        return Vectorizer.validateDataType(type, mode, allowComplex, false);
    }

    public static boolean validateDataType(String type, VectorExpressionDescriptor.Mode mode, boolean allowComplex, boolean allowVoidProjection) {
        TypeInfo typeInfo;
        boolean result = supportedDataTypesPattern.matcher(type = type.toLowerCase()).matches();
        if (result && !allowVoidProjection && mode == VectorExpressionDescriptor.Mode.PROJECTION && type.equals("void")) {
            return false;
        }
        if (!result && (typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(type)).getCategory() != ObjectInspector.Category.PRIMITIVE && allowComplex) {
            return true;
        }
        return result;
    }

    public static String getValidateDataTypeErrorMsg(String type, VectorExpressionDescriptor.Mode mode, boolean allowComplex, boolean isVectorizationComplexTypesEnabled) {
        return Vectorizer.getValidateDataTypeErrorMsg(type, mode, allowComplex, isVectorizationComplexTypesEnabled, false);
    }

    public static String getValidateDataTypeErrorMsg(String type, VectorExpressionDescriptor.Mode mode, boolean allowComplex, boolean isVectorizationComplexTypesEnabled, boolean allowVoidProjection) {
        TypeInfo typeInfo;
        boolean result = supportedDataTypesPattern.matcher(type = type.toLowerCase()).matches();
        if (result && !allowVoidProjection && mode == VectorExpressionDescriptor.Mode.PROJECTION && type.equals("void")) {
            return "Vectorizing data type void not supported when mode = PROJECTION";
        }
        if (!result && (typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(type)).getCategory() != ObjectInspector.Category.PRIMITIVE) {
            if (allowComplex && isVectorizationComplexTypesEnabled) {
                return null;
            }
            if (!allowComplex) {
                return "Vectorizing complex type " + (Object)((Object)typeInfo.getCategory()) + " not supported";
            }
            return "Vectorizing complex type " + (Object)((Object)typeInfo.getCategory()) + " not enabled (" + type + ") since " + GroupByDesc.getComplexTypeEnabledCondition(isVectorizationComplexTypesEnabled);
        }
        return result ? null : "Vectorizing data type " + type + " not supported";
    }

    private VectorizationContext getVectorizationContext(String contextName, VectorTaskColumnInfo vectorTaskColumnInfo) {
        VectorizationContext vContext = new VectorizationContext(contextName, vectorTaskColumnInfo.allColumnNames, vectorTaskColumnInfo.allTypeInfos, vectorTaskColumnInfo.allDataTypePhysicalVariations, this.hiveConf);
        return vContext;
    }

    private void fixupParentChildOperators(Operator<? extends OperatorDesc> op, Operator<? extends OperatorDesc> vectorOp) {
        if (op.getParentOperators() != null) {
            vectorOp.setParentOperators(op.getParentOperators());
            for (Operator<OperatorDesc> p : op.getParentOperators()) {
                p.replaceChild(op, vectorOp);
            }
        }
        if (op.getChildOperators() != null) {
            vectorOp.setChildOperators(op.getChildOperators());
            for (Operator<OperatorDesc> c : op.getChildOperators()) {
                c.replaceParent(op, vectorOp);
            }
        }
    }

    private boolean isBigTableOnlyResults(MapJoinDesc desc) {
        int smallTableIndicesSize;
        int[] smallTableIndices;
        Byte posSingleVectorMapJoinSmallTable;
        Byte[] order = desc.getTagOrder();
        byte posBigTable = (byte)desc.getPosBigTable();
        Byte by = posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        if (desc.getValueIndices() != null && desc.getValueIndices().get(posSingleVectorMapJoinSmallTable) != null) {
            smallTableIndices = desc.getValueIndices().get(posSingleVectorMapJoinSmallTable);
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices " + Arrays.toString(smallTableIndices));
            smallTableIndicesSize = smallTableIndices.length;
        } else {
            smallTableIndices = null;
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices EMPTY");
            smallTableIndicesSize = 0;
        }
        List<Integer> smallTableRetainList = desc.getRetainList().get(posSingleVectorMapJoinSmallTable);
        LOG.info("Vectorizer isBigTableOnlyResults smallTableRetainList " + smallTableRetainList);
        int smallTableRetainSize = smallTableRetainList.size();
        if (smallTableIndicesSize > 0) {
            for (int i = 0; i < smallTableIndicesSize; ++i) {
                if (smallTableIndices[i] >= 0) continue;
                this.setOperatorIssue("Vectorizer isBigTableOnlyResults smallTableIndices[i] < 0 returning false");
                return false;
            }
        } else if (smallTableRetainSize > 0) {
            this.setOperatorIssue("Vectorizer isBigTableOnlyResults smallTableRetainSize > 0 returning false");
            return false;
        }
        LOG.info("Vectorizer isBigTableOnlyResults returning true");
        return true;
    }

    Operator<? extends OperatorDesc> specializeMapJoinOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, MapJoinDesc desc, VectorMapJoinDesc vectorDesc) throws HiveException {
        Operator<OperatorDesc> vectorOp = null;
        Class opClass = null;
        VectorMapJoinInfo vectorMapJoinInfo = vectorDesc.getVectorMapJoinInfo();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = VectorMapJoinDesc.HashTableImplementationType.NONE;
        VectorMapJoinDesc.HashTableKind hashTableKind = VectorMapJoinDesc.HashTableKind.NONE;
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.NONE;
        VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation = VectorMapJoinDesc.VectorMapJoinVariation.NONE;
        hashTableImplementationType = vectorDesc.getIsFastHashTableEnabled() ? VectorMapJoinDesc.HashTableImplementationType.FAST : VectorMapJoinDesc.HashTableImplementationType.OPTIMIZED;
        int joinType = desc.getConds()[0].getType();
        boolean isInnerBigOnly = false;
        if (joinType == 0 && this.isBigTableOnlyResults(desc)) {
            isInnerBigOnly = true;
        }
        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.MULTI_KEY;
        if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MULTIKEY_ONLY_ENABLED)) {
            byte posBigTable = (byte)desc.getPosBigTable();
            Map<Byte, List<ExprNodeDesc>> keyExprs = desc.getKeys();
            List<ExprNodeDesc> bigTableKeyExprs = keyExprs.get(posBigTable);
            if (bigTableKeyExprs.size() == 1) {
                TypeInfo typeInfo = bigTableKeyExprs.get(0).getTypeInfo();
                LOG.info("Vectorizer vectorizeOperator map join typeName " + typeInfo.getTypeName());
                switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BOOLEAN;
                        break;
                    }
                    case BYTE: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BYTE;
                        break;
                    }
                    case SHORT: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.SHORT;
                        break;
                    }
                    case INT: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.INT;
                        break;
                    }
                    case LONG: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.LONG;
                        break;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.STRING;
                    }
                }
            }
        }
        switch (joinType) {
            case 0: {
                if (!isInnerBigOnly) {
                    vectorMapJoinVariation = VectorMapJoinDesc.VectorMapJoinVariation.INNER;
                    hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                    break;
                }
                vectorMapJoinVariation = VectorMapJoinDesc.VectorMapJoinVariation.INNER_BIG_ONLY;
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MULTISET;
                break;
            }
            case 1: 
            case 2: {
                vectorMapJoinVariation = VectorMapJoinDesc.VectorMapJoinVariation.OUTER;
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                break;
            }
            case 5: {
                vectorMapJoinVariation = VectorMapJoinDesc.VectorMapJoinVariation.LEFT_SEMI;
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_SET;
                break;
            }
            default: {
                throw new HiveException("Unknown join type " + joinType);
            }
        }
        LOG.info("Vectorizer vectorizeOperator map join hashTableKind " + hashTableKind.name() + " hashTableKeyType " + hashTableKeyType.name());
        block13 : switch (hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (vectorMapJoinVariation) {
                    case INNER: {
                        opClass = VectorMapJoinInnerLongOperator.class;
                        break block13;
                    }
                    case INNER_BIG_ONLY: {
                        opClass = VectorMapJoinInnerBigOnlyLongOperator.class;
                        break block13;
                    }
                    case LEFT_SEMI: {
                        opClass = VectorMapJoinLeftSemiLongOperator.class;
                        break block13;
                    }
                    case OUTER: {
                        opClass = VectorMapJoinOuterLongOperator.class;
                        break block13;
                    }
                }
                throw new HiveException("Unknown operator variation " + (Object)((Object)vectorMapJoinVariation));
            }
            case STRING: {
                switch (vectorMapJoinVariation) {
                    case INNER: {
                        opClass = VectorMapJoinInnerStringOperator.class;
                        break block13;
                    }
                    case INNER_BIG_ONLY: {
                        opClass = VectorMapJoinInnerBigOnlyStringOperator.class;
                        break block13;
                    }
                    case LEFT_SEMI: {
                        opClass = VectorMapJoinLeftSemiStringOperator.class;
                        break block13;
                    }
                    case OUTER: {
                        opClass = VectorMapJoinOuterStringOperator.class;
                        break block13;
                    }
                }
                throw new HiveException("Unknown operator variation " + (Object)((Object)vectorMapJoinVariation));
            }
            case MULTI_KEY: {
                switch (vectorMapJoinVariation) {
                    case INNER: {
                        opClass = VectorMapJoinInnerMultiKeyOperator.class;
                        break block13;
                    }
                    case INNER_BIG_ONLY: {
                        opClass = VectorMapJoinInnerBigOnlyMultiKeyOperator.class;
                        break block13;
                    }
                    case LEFT_SEMI: {
                        opClass = VectorMapJoinLeftSemiMultiKeyOperator.class;
                        break block13;
                    }
                    case OUTER: {
                        opClass = VectorMapJoinOuterMultiKeyOperator.class;
                        break block13;
                    }
                }
                throw new HiveException("Unknown operator variation " + (Object)((Object)vectorMapJoinVariation));
            }
            default: {
                throw new RuntimeException("Unexpected hash table key type " + hashTableKeyType.name());
            }
        }
        boolean minMaxEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MINMAX_ENABLED);
        vectorDesc.setHashTableImplementationType(hashTableImplementationType);
        vectorDesc.setHashTableKind(hashTableKind);
        vectorDesc.setHashTableKeyType(hashTableKeyType);
        vectorDesc.setVectorMapJoinVariation(vectorMapJoinVariation);
        vectorDesc.setMinMaxEnabled(minMaxEnabled);
        vectorDesc.setVectorMapJoinInfo(vectorMapJoinInfo);
        vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext, vectorDesc);
        LOG.info("Vectorizer vectorizeOperator map join class " + vectorOp.getClass().getSimpleName());
        return vectorOp;
    }

    public static boolean onExpressionHasNullSafes(MapJoinDesc desc) {
        boolean[] nullSafes = desc.getNullSafes();
        if (nullSafes == null) {
            return false;
        }
        for (boolean nullSafe : nullSafes) {
            if (!nullSafe) continue;
            return true;
        }
        return false;
    }

    private boolean canSpecializeMapJoin(Operator<? extends OperatorDesc> op, MapJoinDesc desc, boolean isTezOrSpark, VectorizationContext vContext, VectorMapJoinDesc vectorDesc) throws HiveException {
        int smallTableValueIndex;
        int i;
        String[] bigTableRetainedNames;
        int smallTableIndicesSize;
        int[] smallTableIndices;
        Preconditions.checkState(op instanceof MapJoinOperator);
        VectorMapJoinInfo vectorMapJoinInfo = new VectorMapJoinInfo();
        boolean isVectorizationMapJoinNativeEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_ENABLED);
        String engine = HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        boolean oneMapJoinCondition = desc.getConds().length == 1;
        boolean hasNullSafes = Vectorizer.onExpressionHasNullSafes(desc);
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> keyDesc = desc.getKeys().get(posBigTable);
        boolean outerJoinHasNoKeys = !desc.isNoOuterJoin() && keyDesc.size() == 0;
        VectorExpression[] allBigTableKeyExpressions = vContext.getVectorExpressionsUpConvertDecimal64(keyDesc);
        int allBigTableKeyExpressionsLength = allBigTableKeyExpressions.length;
        boolean supportsKeyTypes = true;
        HashSet<String> notSupportedKeyTypes = new HashSet<String>();
        int[] bigTableKeyColumnMap = new int[allBigTableKeyExpressionsLength];
        String[] bigTableKeyColumnNames = new String[allBigTableKeyExpressionsLength];
        TypeInfo[] bigTableKeyTypeInfos = new TypeInfo[allBigTableKeyExpressionsLength];
        ArrayList<VectorExpression> bigTableKeyExpressionsList = new ArrayList<VectorExpression>();
        for (int i2 = 0; i2 < allBigTableKeyExpressionsLength; ++i2) {
            VectorExpression ve = allBigTableKeyExpressions[i2];
            if (!IdentityExpression.isColumnOnly(ve)) {
                bigTableKeyExpressionsList.add(ve);
            }
            bigTableKeyColumnMap[i2] = ve.getOutputColumnNum();
            ExprNodeDesc exprNode = keyDesc.get(i2);
            bigTableKeyColumnNames[i2] = exprNode.toString();
            TypeInfo typeInfo = exprNode.getTypeInfo();
            if (!MapJoinKey.isSupportedField(typeInfo)) {
                supportsKeyTypes = false;
                ObjectInspector.Category category = typeInfo.getCategory();
                notSupportedKeyTypes.add(category != ObjectInspector.Category.PRIMITIVE ? category.toString() : ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory().toString());
            }
            bigTableKeyTypeInfos[i2] = typeInfo;
        }
        VectorExpression[] slimmedBigTableKeyExpressions = bigTableKeyExpressionsList.size() == 0 ? null : bigTableKeyExpressionsList.toArray(new VectorExpression[0]);
        List<ExprNodeDesc> bigTableExprs = desc.getExprs().get(posBigTable);
        VectorExpression[] allBigTableValueExpressions = vContext.getVectorExpressionsUpConvertDecimal64(bigTableExprs);
        boolean isFastHashTableEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_FAST_HASHTABLE_ENABLED);
        boolean isHybridHashJoin = desc.isHybridHashJoin();
        int[] bigTableValueColumnMap = new int[allBigTableValueExpressions.length];
        String[] bigTableValueColumnNames = new String[allBigTableValueExpressions.length];
        TypeInfo[] bigTableValueTypeInfos = new TypeInfo[allBigTableValueExpressions.length];
        ArrayList<VectorExpression> bigTableValueExpressionsList = new ArrayList<VectorExpression>();
        for (int i3 = 0; i3 < bigTableValueColumnMap.length; ++i3) {
            VectorExpression ve = allBigTableValueExpressions[i3];
            if (!IdentityExpression.isColumnOnly(ve)) {
                bigTableValueExpressionsList.add(ve);
            }
            bigTableValueColumnMap[i3] = ve.getOutputColumnNum();
            ExprNodeDesc exprNode = bigTableExprs.get(i3);
            bigTableValueColumnNames[i3] = exprNode.toString();
            bigTableValueTypeInfos[i3] = exprNode.getTypeInfo();
        }
        VectorExpression[] slimmedBigTableValueExpressions = bigTableValueExpressionsList.size() == 0 ? null : bigTableValueExpressionsList.toArray(new VectorExpression[0]);
        vectorMapJoinInfo.setBigTableKeyColumnMap(bigTableKeyColumnMap);
        vectorMapJoinInfo.setBigTableKeyColumnNames(bigTableKeyColumnNames);
        vectorMapJoinInfo.setBigTableKeyTypeInfos(bigTableKeyTypeInfos);
        vectorMapJoinInfo.setSlimmedBigTableKeyExpressions(slimmedBigTableKeyExpressions);
        vectorDesc.setAllBigTableKeyExpressions(allBigTableKeyExpressions);
        vectorMapJoinInfo.setBigTableValueColumnMap(bigTableValueColumnMap);
        vectorMapJoinInfo.setBigTableValueColumnNames(bigTableValueColumnNames);
        vectorMapJoinInfo.setBigTableValueTypeInfos(bigTableValueTypeInfos);
        vectorMapJoinInfo.setSlimmedBigTableValueExpressions(slimmedBigTableValueExpressions);
        vectorDesc.setAllBigTableValueExpressions(allBigTableValueExpressions);
        VectorColumnOutputMapping bigTableRetainedMapping = new VectorColumnOutputMapping("Big Table Retained Mapping");
        VectorColumnOutputMapping bigTableOuterKeyMapping = new VectorColumnOutputMapping("Big Table Outer Key Mapping");
        VectorColumnSourceMapping smallTableMapping = new VectorColumnSourceMapping("Small Table Mapping");
        Byte[] order = desc.getTagOrder();
        Byte posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        boolean isOuterJoin = !desc.getNoOuterJoin();
        List<Integer> bigTableRetainList = desc.getRetainList().get(posBigTable);
        int bigTableRetainSize = bigTableRetainList.size();
        List<ExprNodeDesc> smallTableExprs = desc.getExprs().get(posSingleVectorMapJoinSmallTable);
        if (desc.getValueIndices() != null && desc.getValueIndices().get(posSingleVectorMapJoinSmallTable) != null) {
            smallTableIndices = desc.getValueIndices().get(posSingleVectorMapJoinSmallTable);
            smallTableIndicesSize = smallTableIndices.length;
        } else {
            smallTableIndices = null;
            smallTableIndicesSize = 0;
        }
        List<Integer> smallTableRetainList = desc.getRetainList().get(posSingleVectorMapJoinSmallTable);
        int smallTableRetainSize = smallTableRetainList.size();
        int smallTableResultSize = 0;
        if (smallTableIndicesSize > 0) {
            smallTableResultSize = smallTableIndicesSize;
        } else if (smallTableRetainSize > 0) {
            smallTableResultSize = smallTableRetainSize;
        }
        VectorColumnSourceMapping projectionMapping = new VectorColumnSourceMapping("Projection Mapping");
        int nextOutputColumn = order[0] == posBigTable ? 0 : smallTableResultSize;
        for (int i4 = 0; i4 < bigTableRetainSize; ++i4) {
            int retainColumn = bigTableRetainList.get(i4);
            int batchColumnIndex = bigTableValueColumnMap[retainColumn];
            TypeInfo typeInfo = bigTableValueTypeInfos[i4];
            projectionMapping.add(nextOutputColumn, batchColumnIndex, typeInfo);
            if (!bigTableRetainedMapping.containsOutputColumn(batchColumnIndex)) {
                bigTableRetainedMapping.add(batchColumnIndex, batchColumnIndex, typeInfo);
            }
            ++nextOutputColumn;
        }
        boolean smallTableExprVectorizes = true;
        int firstSmallTableOutputColumn = order[0] == posBigTable ? bigTableRetainSize : 0;
        int smallTableOutputCount = 0;
        nextOutputColumn = firstSmallTableOutputColumn;
        if (smallTableIndicesSize > 0) {
            smallTableOutputCount = smallTableIndicesSize;
            bigTableRetainedNames = new String[smallTableOutputCount];
            for (i = 0; i < smallTableIndicesSize; ++i) {
                int scratchColumn;
                TypeInfo typeInfo;
                if (smallTableIndices[i] >= 0) {
                    int keyIndex = smallTableIndices[i];
                    int batchKeyColumn = bigTableKeyColumnMap[keyIndex];
                    bigTableRetainedNames[i] = bigTableKeyColumnNames[keyIndex];
                    typeInfo = bigTableKeyTypeInfos[keyIndex];
                    if (!isOuterJoin) {
                        projectionMapping.add(nextOutputColumn, batchKeyColumn, typeInfo);
                        if (!bigTableRetainedMapping.containsOutputColumn(batchKeyColumn)) {
                            bigTableRetainedMapping.add(batchKeyColumn, batchKeyColumn, typeInfo);
                        }
                    } else {
                        scratchColumn = vContext.allocateScratchColumn(typeInfo);
                        projectionMapping.add(nextOutputColumn, scratchColumn, typeInfo);
                        bigTableRetainedMapping.add(batchKeyColumn, scratchColumn, typeInfo);
                        bigTableOuterKeyMapping.add(batchKeyColumn, scratchColumn, typeInfo);
                    }
                } else {
                    smallTableValueIndex = -smallTableIndices[i] - 1;
                    ExprNodeDesc smallTableExprNode = smallTableExprs.get(i);
                    if (!this.validateExprNodeDesc(smallTableExprNode, "Small Table")) {
                        this.clearNotVectorizedReason();
                        smallTableExprVectorizes = false;
                    }
                    bigTableRetainedNames[i] = smallTableExprNode.toString();
                    typeInfo = smallTableExprNode.getTypeInfo();
                    scratchColumn = vContext.allocateScratchColumn(typeInfo);
                    projectionMapping.add(nextOutputColumn, scratchColumn, typeInfo);
                    smallTableMapping.add(smallTableValueIndex, scratchColumn, typeInfo);
                }
                ++nextOutputColumn;
            }
        } else if (smallTableRetainSize > 0) {
            smallTableOutputCount = smallTableRetainSize;
            bigTableRetainedNames = new String[smallTableOutputCount];
            for (i = 0; i < smallTableRetainSize; ++i) {
                smallTableValueIndex = smallTableRetainList.get(i);
                ExprNodeDesc smallTableExprNode = smallTableExprs.get(i);
                if (!this.validateExprNodeDesc(smallTableExprNode, "Small Table")) {
                    this.clearNotVectorizedReason();
                    smallTableExprVectorizes = false;
                }
                bigTableRetainedNames[i] = smallTableExprNode.toString();
                TypeInfo typeInfo = smallTableExprNode.getTypeInfo();
                int scratchColumn = vContext.allocateScratchColumn(typeInfo);
                projectionMapping.add(nextOutputColumn, scratchColumn, typeInfo);
                smallTableMapping.add(smallTableValueIndex, scratchColumn, typeInfo);
                ++nextOutputColumn;
            }
        } else {
            bigTableRetainedNames = new String[]{};
        }
        boolean useOptimizedTable = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
        vectorDesc.setVectorMapJoinInfo(vectorMapJoinInfo);
        vectorDesc.setUseOptimizedTable(useOptimizedTable);
        vectorDesc.setIsVectorizationMapJoinNativeEnabled(isVectorizationMapJoinNativeEnabled);
        vectorDesc.setEngine(engine);
        vectorDesc.setOneMapJoinCondition(oneMapJoinCondition);
        vectorDesc.setHasNullSafes(hasNullSafes);
        vectorDesc.setSmallTableExprVectorizes(smallTableExprVectorizes);
        vectorDesc.setOuterJoinHasNoKeys(outerJoinHasNoKeys);
        vectorDesc.setIsFastHashTableEnabled(isFastHashTableEnabled);
        vectorDesc.setIsHybridHashJoin(isHybridHashJoin);
        vectorDesc.setSupportsKeyTypes(supportsKeyTypes);
        if (!supportsKeyTypes) {
            vectorDesc.setNotSupportedKeyTypes(new ArrayList<String>(notSupportedKeyTypes));
        }
        boolean result = true;
        if (!(useOptimizedTable && isVectorizationMapJoinNativeEnabled && isTezOrSpark && oneMapJoinCondition && !hasNullSafes && smallTableExprVectorizes && !outerJoinHasNoKeys)) {
            result = false;
        }
        if (!isFastHashTableEnabled) {
            if (!supportsKeyTypes) {
                result = false;
            }
        } else if (isHybridHashJoin) {
            result = false;
        }
        bigTableRetainedMapping.finalize();
        bigTableOuterKeyMapping.finalize();
        smallTableMapping.finalize();
        vectorMapJoinInfo.setBigTableRetainedMapping(bigTableRetainedMapping);
        vectorMapJoinInfo.setBigTableOuterKeyMapping(bigTableOuterKeyMapping);
        vectorMapJoinInfo.setSmallTableMapping(smallTableMapping);
        projectionMapping.finalize();
        assert (projectionMapping.isSourceSequenceGood());
        vectorMapJoinInfo.setProjectionMapping(projectionMapping);
        return result;
    }

    private Operator<? extends OperatorDesc> specializeReduceSinkOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, ReduceSinkDesc desc, VectorReduceSinkDesc vectorDesc) throws HiveException {
        Class opClass;
        VectorReduceSinkDesc.ReduceSinkKeyType reduceSinkKeyType;
        VectorReduceSinkInfo vectorReduceSinkInfo;
        block17: {
            block15: {
                block16: {
                    vectorReduceSinkInfo = vectorDesc.getVectorReduceSinkInfo();
                    ColumnVector.Type[] reduceSinkKeyColumnVectorTypes = vectorReduceSinkInfo.getReduceSinkKeyColumnVectorTypes();
                    reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.MULTI_KEY;
                    if (reduceSinkKeyColumnVectorTypes != null && reduceSinkKeyColumnVectorTypes.length == 1) {
                        LOG.info("Vectorizer vectorizeOperator groupby typeName " + vectorReduceSinkInfo.getReduceSinkKeyTypeInfos()[0]);
                        ColumnVector.Type columnVectorType = reduceSinkKeyColumnVectorTypes[0];
                        block1 : switch (columnVectorType) {
                            case LONG: {
                                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)vectorReduceSinkInfo.getReduceSinkKeyTypeInfos()[0]).getPrimitiveCategory();
                                switch (primitiveCategory) {
                                    case BOOLEAN: 
                                    case BYTE: 
                                    case SHORT: 
                                    case INT: 
                                    case LONG: {
                                        reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.LONG;
                                        break block1;
                                    }
                                }
                                break;
                            }
                            case BYTES: {
                                reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.STRING;
                            }
                        }
                    }
                    opClass = null;
                    if (!vectorReduceSinkInfo.getUseUniformHash()) break block15;
                    if (!vectorDesc.getIsEmptyKey()) break block16;
                    opClass = VectorReduceSinkEmptyKeyOperator.class;
                    break block17;
                }
                switch (reduceSinkKeyType) {
                    case LONG: {
                        opClass = VectorReduceSinkLongOperator.class;
                        break block17;
                    }
                    case STRING: {
                        opClass = VectorReduceSinkStringOperator.class;
                        break block17;
                    }
                    case MULTI_KEY: {
                        opClass = VectorReduceSinkMultiKeyOperator.class;
                        break block17;
                    }
                    default: {
                        throw new HiveException("Unknown reduce sink key type " + (Object)((Object)reduceSinkKeyType));
                    }
                }
            }
            opClass = vectorDesc.getIsEmptyKey() && vectorDesc.getIsEmptyBuckets() && vectorDesc.getIsEmptyPartitions() ? VectorReduceSinkEmptyKeyOperator.class : VectorReduceSinkObjectHashOperator.class;
        }
        vectorDesc.setReduceSinkKeyType(reduceSinkKeyType);
        vectorDesc.setVectorReduceSinkInfo(vectorReduceSinkInfo);
        LOG.info("Vectorizer vectorizeOperator reduce sink class " + opClass.getSimpleName());
        int bucketingVersion = ((ReduceSinkOperator)op).getBucketingVersion();
        Operator<OperatorDesc> vectorOp = null;
        try {
            vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext, vectorDesc);
        }
        catch (Exception e) {
            LOG.info("Vectorizer vectorizeOperator reduce sink class exception " + opClass.getSimpleName() + " exception " + e);
            throw new HiveException(e);
        }
        Preconditions.checkArgument(vectorOp instanceof VectorReduceSinkCommonOperator);
        vectorOp.setBucketingVersion(bucketingVersion);
        return vectorOp;
    }

    private boolean canSpecializeReduceSink(ReduceSinkDesc desc, boolean isTezOrSpark, VectorizationContext vContext, VectorReduceSinkDesc vectorDesc) throws HiveException {
        boolean isEmptyPartitions;
        ArrayList<ExprNodeDesc> valueDescs;
        boolean isEmptyValue;
        boolean isEmptyKey;
        VectorReduceSinkInfo vectorReduceSinkInfo = new VectorReduceSinkInfo();
        boolean isUnexpectedCondition = false;
        boolean isVectorizationReduceSinkNativeEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCESINK_NEW_ENABLED);
        String engine = HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        int limit = desc.getTopN();
        float memUsage = desc.getTopNMemoryUsage();
        boolean hasPTFTopN = limit >= 0 && memUsage > 0.0f && desc.isPTFReduceSink();
        boolean hasDistinctColumns = desc.getDistinctColumnIndices().size() > 0;
        TableDesc keyTableDesc = desc.getKeySerializeInfo();
        Class<? extends Deserializer> keySerializerClass = keyTableDesc.getDeserializerClass();
        boolean isKeyBinarySortable = keySerializerClass == BinarySortableSerDe.class;
        TableDesc valueTableDesc = desc.getValueSerializeInfo();
        Class<? extends Deserializer> valueDeserializerClass = valueTableDesc.getDeserializerClass();
        boolean isValueLazyBinary = valueDeserializerClass == LazyBinarySerDe.class;
        ArrayList<ExprNodeDesc> keysDescs = desc.getKeyCols();
        boolean bl = isEmptyKey = keysDescs.size() == 0;
        if (!isEmptyKey) {
            VectorExpression[] allKeyExpressions = vContext.getVectorExpressions(keysDescs);
            int[] reduceSinkKeyColumnMap = new int[allKeyExpressions.length];
            TypeInfo[] reduceSinkKeyTypeInfos = new TypeInfo[allKeyExpressions.length];
            ColumnVector.Type[] reduceSinkKeyColumnVectorTypes = new ColumnVector.Type[allKeyExpressions.length];
            ArrayList<VectorExpression> groupByKeyExpressionsList = new ArrayList<VectorExpression>();
            for (int i = 0; i < reduceSinkKeyColumnMap.length; ++i) {
                VectorExpression ve = allKeyExpressions[i];
                reduceSinkKeyColumnMap[i] = ve.getOutputColumnNum();
                reduceSinkKeyTypeInfos[i] = ((ExprNodeDesc)keysDescs.get(i)).getTypeInfo();
                reduceSinkKeyColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkKeyTypeInfos[i]);
                if (IdentityExpression.isColumnOnly(ve)) continue;
                groupByKeyExpressionsList.add(ve);
            }
            VectorExpression[] reduceSinkKeyExpressions = groupByKeyExpressionsList.size() == 0 ? null : groupByKeyExpressionsList.toArray(new VectorExpression[0]);
            vectorReduceSinkInfo.setReduceSinkKeyColumnMap(reduceSinkKeyColumnMap);
            vectorReduceSinkInfo.setReduceSinkKeyTypeInfos(reduceSinkKeyTypeInfos);
            vectorReduceSinkInfo.setReduceSinkKeyColumnVectorTypes(reduceSinkKeyColumnVectorTypes);
            vectorReduceSinkInfo.setReduceSinkKeyExpressions(reduceSinkKeyExpressions);
        }
        boolean bl2 = isEmptyValue = (valueDescs = desc.getValueCols()).size() == 0;
        if (!isEmptyValue) {
            VectorExpression[] allValueExpressions = vContext.getVectorExpressions(valueDescs);
            int[] reduceSinkValueColumnMap = new int[allValueExpressions.length];
            TypeInfo[] reduceSinkValueTypeInfos = new TypeInfo[allValueExpressions.length];
            ColumnVector.Type[] reduceSinkValueColumnVectorTypes = new ColumnVector.Type[allValueExpressions.length];
            ArrayList<VectorExpression> reduceSinkValueExpressionsList = new ArrayList<VectorExpression>();
            for (int i = 0; i < valueDescs.size(); ++i) {
                VectorExpression ve = allValueExpressions[i];
                reduceSinkValueColumnMap[i] = ve.getOutputColumnNum();
                reduceSinkValueTypeInfos[i] = valueDescs.get(i).getTypeInfo();
                reduceSinkValueColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkValueTypeInfos[i]);
                if (IdentityExpression.isColumnOnly(ve)) continue;
                reduceSinkValueExpressionsList.add(ve);
            }
            VectorExpression[] reduceSinkValueExpressions = reduceSinkValueExpressionsList.size() == 0 ? null : reduceSinkValueExpressionsList.toArray(new VectorExpression[0]);
            vectorReduceSinkInfo.setReduceSinkValueColumnMap(reduceSinkValueColumnMap);
            vectorReduceSinkInfo.setReduceSinkValueTypeInfos(reduceSinkValueTypeInfos);
            vectorReduceSinkInfo.setReduceSinkValueColumnVectorTypes(reduceSinkValueColumnVectorTypes);
            vectorReduceSinkInfo.setReduceSinkValueExpressions(reduceSinkValueExpressions);
        }
        boolean useUniformHash = desc.getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
        vectorReduceSinkInfo.setUseUniformHash(useUniformHash);
        List<ExprNodeDesc> bucketDescs = desc.getBucketCols();
        boolean isEmptyBuckets = bucketDescs == null || bucketDescs.size() == 0;
        ArrayList<ExprNodeDesc> partitionDescs = desc.getPartitionCols();
        boolean bl3 = isEmptyPartitions = partitionDescs == null || partitionDescs.size() == 0;
        if (!(useUniformHash || isEmptyKey && isEmptyBuckets && isEmptyPartitions)) {
            int[] reduceSinkBucketColumnMap = null;
            TypeInfo[] reduceSinkBucketTypeInfos = null;
            ColumnVector.Type[] reduceSinkBucketColumnVectorTypes = null;
            VectorExpression[] reduceSinkBucketExpressions = null;
            if (!isEmptyBuckets) {
                VectorExpression[] allBucketExpressions = vContext.getVectorExpressions(bucketDescs);
                reduceSinkBucketColumnMap = new int[bucketDescs.size()];
                reduceSinkBucketTypeInfos = new TypeInfo[bucketDescs.size()];
                reduceSinkBucketColumnVectorTypes = new ColumnVector.Type[bucketDescs.size()];
                ArrayList<VectorExpression> reduceSinkBucketExpressionsList = new ArrayList<VectorExpression>();
                for (int i = 0; i < bucketDescs.size(); ++i) {
                    VectorExpression ve = allBucketExpressions[i];
                    reduceSinkBucketColumnMap[i] = ve.getOutputColumnNum();
                    reduceSinkBucketTypeInfos[i] = bucketDescs.get(i).getTypeInfo();
                    reduceSinkBucketColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkBucketTypeInfos[i]);
                    if (IdentityExpression.isColumnOnly(ve)) continue;
                    reduceSinkBucketExpressionsList.add(ve);
                }
                reduceSinkBucketExpressions = reduceSinkBucketExpressionsList.size() == 0 ? null : reduceSinkBucketExpressionsList.toArray(new VectorExpression[0]);
            }
            int[] reduceSinkPartitionColumnMap = null;
            TypeInfo[] reduceSinkPartitionTypeInfos = null;
            ColumnVector.Type[] reduceSinkPartitionColumnVectorTypes = null;
            VectorExpression[] reduceSinkPartitionExpressions = null;
            if (!isEmptyPartitions) {
                VectorExpression[] allPartitionExpressions = vContext.getVectorExpressions(partitionDescs);
                reduceSinkPartitionColumnMap = new int[partitionDescs.size()];
                reduceSinkPartitionTypeInfos = new TypeInfo[partitionDescs.size()];
                reduceSinkPartitionColumnVectorTypes = new ColumnVector.Type[partitionDescs.size()];
                ArrayList<VectorExpression> reduceSinkPartitionExpressionsList = new ArrayList<VectorExpression>();
                for (int i = 0; i < partitionDescs.size(); ++i) {
                    VectorExpression ve = allPartitionExpressions[i];
                    reduceSinkPartitionColumnMap[i] = ve.getOutputColumnNum();
                    reduceSinkPartitionTypeInfos[i] = ((ExprNodeDesc)partitionDescs.get(i)).getTypeInfo();
                    reduceSinkPartitionColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkPartitionTypeInfos[i]);
                    if (IdentityExpression.isColumnOnly(ve)) continue;
                    reduceSinkPartitionExpressionsList.add(ve);
                }
                reduceSinkPartitionExpressions = reduceSinkPartitionExpressionsList.size() == 0 ? null : reduceSinkPartitionExpressionsList.toArray(new VectorExpression[0]);
            }
            vectorReduceSinkInfo.setReduceSinkBucketColumnMap(reduceSinkBucketColumnMap);
            vectorReduceSinkInfo.setReduceSinkBucketTypeInfos(reduceSinkBucketTypeInfos);
            vectorReduceSinkInfo.setReduceSinkBucketColumnVectorTypes(reduceSinkBucketColumnVectorTypes);
            vectorReduceSinkInfo.setReduceSinkBucketExpressions(reduceSinkBucketExpressions);
            vectorReduceSinkInfo.setReduceSinkPartitionColumnMap(reduceSinkPartitionColumnMap);
            vectorReduceSinkInfo.setReduceSinkPartitionTypeInfos(reduceSinkPartitionTypeInfos);
            vectorReduceSinkInfo.setReduceSinkPartitionColumnVectorTypes(reduceSinkPartitionColumnVectorTypes);
            vectorReduceSinkInfo.setReduceSinkPartitionExpressions(reduceSinkPartitionExpressions);
        }
        vectorDesc.setVectorReduceSinkInfo(vectorReduceSinkInfo);
        vectorDesc.setIsVectorizationReduceSinkNativeEnabled(isVectorizationReduceSinkNativeEnabled);
        vectorDesc.setEngine(engine);
        vectorDesc.setIsEmptyKey(isEmptyKey);
        vectorDesc.setIsEmptyValue(isEmptyValue);
        vectorDesc.setIsEmptyBuckets(isEmptyBuckets);
        vectorDesc.setIsEmptyPartitions(isEmptyPartitions);
        vectorDesc.setHasPTFTopN(hasPTFTopN);
        vectorDesc.setHasDistinctColumns(hasDistinctColumns);
        vectorDesc.setIsKeyBinarySortable(isKeyBinarySortable);
        vectorDesc.setIsValueLazyBinary(isValueLazyBinary);
        vectorDesc.setIsAcidChange(desc.getWriteType() == AcidUtils.Operation.DELETE || desc.getWriteType() == AcidUtils.Operation.UPDATE);
        vectorDesc.setIsUnexpectedCondition(isUnexpectedCondition);
        return isVectorizationReduceSinkNativeEnabled && isTezOrSpark && !hasPTFTopN && !hasDistinctColumns && isKeyBinarySortable && isValueLazyBinary && !isUnexpectedCondition;
    }

    private boolean usesVectorUDFAdaptor(VectorExpression vecExpr) {
        if (vecExpr == null) {
            return false;
        }
        if (vecExpr instanceof VectorUDFAdaptor) {
            return true;
        }
        return this.usesVectorUDFAdaptor(vecExpr.getChildExpressions());
    }

    private boolean usesVectorUDFAdaptor(VectorExpression[] vecExprs) {
        if (vecExprs == null) {
            return false;
        }
        for (VectorExpression vecExpr : vecExprs) {
            if (!this.usesVectorUDFAdaptor(vecExpr)) continue;
            return true;
        }
        return false;
    }

    public static Operator<? extends OperatorDesc> vectorizeFilterOperator(Operator<? extends OperatorDesc> filterOp, VectorizationContext vContext, VectorFilterDesc vectorFilterDesc) throws HiveException {
        FilterDesc filterDesc = (FilterDesc)filterOp.getConf();
        ExprNodeDesc predicateExpr = filterDesc.getPredicate();
        VectorExpression vectorPredicateExpr = vContext.getVectorExpression(predicateExpr, VectorExpressionDescriptor.Mode.FILTER);
        vectorFilterDesc.setPredicateExpression(vectorPredicateExpr);
        return OperatorFactory.getVectorOperator(filterOp.getCompilationOpContext(), filterDesc, vContext, vectorFilterDesc);
    }

    private static Class<? extends VectorAggregateExpression> findVecAggrClass(Class<? extends VectorAggregateExpression>[] vecAggrClasses, String aggregateName, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColumnVecType, GenericUDAFEvaluator.Mode udafEvaluatorMode) throws HiveException {
        for (Class<? extends VectorAggregateExpression> vecAggrClass : vecAggrClasses) {
            VectorAggregateExpression vecAggrExprCheck;
            try {
                vecAggrExprCheck = vecAggrClass.newInstance();
            }
            catch (Exception e) {
                throw new HiveException(vecAggrClass.getSimpleName() + "() failed to initialize", e);
            }
            if (!vecAggrExprCheck.matches(aggregateName, inputColVectorType, outputColumnVecType, udafEvaluatorMode)) continue;
            return vecAggrClass;
        }
        return null;
    }

    private static ImmutablePair<VectorAggregationDesc, String> getVectorAggregationDesc(AggregationDesc aggrDesc, VectorizationContext vContext) throws HiveException {
        Class<? extends VectorAggregateExpression> vecAggrClass;
        VectorExpression inputExpression;
        ColumnVector.Type inputColVectorType;
        TypeInfo inputTypeInfo;
        String aggregateName = aggrDesc.getGenericUDAFName();
        ArrayList<ExprNodeDesc> parameterList = aggrDesc.getParameters();
        int parameterCount = parameterList.size();
        GenericUDAFEvaluator.Mode udafEvaluatorMode = aggrDesc.getMode();
        GenericUDAFEvaluator evaluator = aggrDesc.getGenericUDAFEvaluator();
        ArrayList<ExprNodeDesc> parameters = aggrDesc.getParameters();
        ObjectInspector[] parameterObjectInspectors = new ObjectInspector[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            TypeInfo typeInfo = parameters.get(i).getTypeInfo();
            parameterObjectInspectors[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo);
        }
        ObjectInspector returnOI = evaluator.init(aggrDesc.getMode(), parameterObjectInspectors);
        VectorizedUDAFs annotation = AnnotationUtils.getAnnotation(evaluator.getClass(), VectorizedUDAFs.class);
        if (annotation == null) {
            String issue = "Evaluator " + evaluator.getClass().getSimpleName() + " does not have a vectorized UDAF annotation (aggregation: \"" + aggregateName + "\"). Vectorization not supported";
            return new ImmutablePair<Object, String>(null, issue);
        }
        Class<? extends VectorAggregateExpression>[] vecAggrClasses = annotation.value();
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString(returnOI.getTypeName());
        ColumnVector.Type outputColVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(outputTypeInfo);
        if (parameterCount == 0) {
            inputTypeInfo = null;
            inputColVectorType = null;
            inputExpression = null;
        } else if (parameterCount == 1) {
            ExprNodeDesc exprNodeDesc = parameterList.get(0);
            inputTypeInfo = exprNodeDesc.getTypeInfo();
            if (inputTypeInfo == null) {
                String issue = "Aggregations with null parameter type not supported " + aggregateName + "(" + parameterList.toString() + ")";
                return new ImmutablePair<Object, String>(null, issue);
            }
            inputExpression = vContext.getVectorExpression(exprNodeDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            if (inputExpression == null) {
                String issue = "Parameter expression " + exprNodeDesc.toString() + " not supported " + aggregateName + "(" + parameterList.toString() + ")";
                return new ImmutablePair<Object, String>(null, issue);
            }
            if (inputExpression.getOutputTypeInfo() == null) {
                String issue = "Parameter expression " + exprNodeDesc.toString() + " with null type not supported " + aggregateName + "(" + parameterList.toString() + ")";
                return new ImmutablePair<Object, String>(null, issue);
            }
            inputColVectorType = inputExpression.getOutputColumnVectorType();
        } else {
            String issue = "Aggregations with > 1 parameter are not supported " + aggregateName + "(" + parameterList.toString() + ")";
            return new ImmutablePair<Object, String>(null, issue);
        }
        if (inputTypeInfo != null && inputColVectorType == ColumnVector.Type.DECIMAL_64) {
            if (outputColVectorType == ColumnVector.Type.DECIMAL) {
                Class<? extends VectorAggregateExpression> vecAggrClass2;
                DecimalTypeInfo outputDecimalTypeInfo = (DecimalTypeInfo)outputTypeInfo;
                if (HiveDecimalWritable.isPrecisionDecimal64(outputDecimalTypeInfo.getPrecision()) && (vecAggrClass2 = Vectorizer.findVecAggrClass(vecAggrClasses, aggregateName, inputColVectorType, ColumnVector.Type.DECIMAL_64, udafEvaluatorMode)) != null) {
                    VectorAggregationDesc vecAggrDesc = new VectorAggregationDesc(aggrDesc, evaluator, inputTypeInfo, inputColVectorType, inputExpression, outputTypeInfo, ColumnVector.Type.DECIMAL_64, vecAggrClass2);
                    return new ImmutablePair<VectorAggregationDesc, Object>(vecAggrDesc, null);
                }
                vecAggrClass2 = Vectorizer.findVecAggrClass(vecAggrClasses, aggregateName, inputColVectorType, outputColVectorType, udafEvaluatorMode);
                if (vecAggrClass2 != null) {
                    VectorAggregationDesc vecAggrDesc = new VectorAggregationDesc(aggrDesc, evaluator, inputTypeInfo, inputColVectorType, inputExpression, outputTypeInfo, outputColVectorType, vecAggrClass2);
                    return new ImmutablePair<VectorAggregationDesc, Object>(vecAggrDesc, null);
                }
                inputExpression = vContext.wrapWithDecimal64ToDecimalConversion(inputExpression);
                inputColVectorType = ColumnVector.Type.DECIMAL;
            } else {
                vecAggrClass = Vectorizer.findVecAggrClass(vecAggrClasses, aggregateName, inputColVectorType, outputColVectorType, udafEvaluatorMode);
                if (vecAggrClass != null) {
                    if (aggregateName.equals("bloom_filter")) {
                        inputExpression = vContext.wrapWithDecimal64ToDecimalConversion(inputExpression);
                        inputColVectorType = ColumnVector.Type.DECIMAL;
                    }
                    VectorAggregationDesc vecAggrDesc = new VectorAggregationDesc(aggrDesc, evaluator, inputTypeInfo, inputColVectorType, inputExpression, outputTypeInfo, outputColVectorType, vecAggrClass);
                    return new ImmutablePair<VectorAggregationDesc, Object>(vecAggrDesc, null);
                }
                inputExpression = vContext.wrapWithDecimal64ToDecimalConversion(inputExpression);
                inputColVectorType = ColumnVector.Type.DECIMAL;
            }
        }
        if ((vecAggrClass = Vectorizer.findVecAggrClass(vecAggrClasses, aggregateName, inputColVectorType, outputColVectorType, udafEvaluatorMode)) != null) {
            VectorAggregationDesc vecAggrDesc = new VectorAggregationDesc(aggrDesc, evaluator, inputTypeInfo, inputColVectorType, inputExpression, outputTypeInfo, outputColVectorType, vecAggrClass);
            return new ImmutablePair<VectorAggregationDesc, Object>(vecAggrDesc, null);
        }
        String issue = "Vector aggregation : \"" + aggregateName + "\" for input type: " + (inputColVectorType == null ? "any" : "\"" + (Object)((Object)inputColVectorType)) + "\" and output type: \"" + (Object)((Object)outputColVectorType) + "\" and mode: " + (Object)((Object)udafEvaluatorMode) + " not supported for evaluator " + evaluator.getClass().getSimpleName();
        return new ImmutablePair<Object, String>(null, issue);
    }

    public static Operator<? extends OperatorDesc> vectorizeGroupByOperator(Operator<? extends OperatorDesc> groupByOp, VectorizationContext vContext, VectorGroupByDesc vectorGroupByDesc) throws HiveException {
        ImmutablePair<Operator<? extends OperatorDesc>, String> pair = Vectorizer.doVectorizeGroupByOperator(groupByOp, vContext, vectorGroupByDesc);
        return (Operator)pair.left;
    }

    private static ImmutablePair<Operator<? extends OperatorDesc>, String> doVectorizeGroupByOperator(Operator<? extends OperatorDesc> groupByOp, VectorizationContext vContext, VectorGroupByDesc vectorGroupByDesc) throws HiveException {
        GroupByDesc groupByDesc = (GroupByDesc)groupByOp.getConf();
        ArrayList<ExprNodeDesc> keysDesc = groupByDesc.getKeys();
        VectorExpression[] vecKeyExpressions = vContext.getVectorExpressionsUpConvertDecimal64(keysDesc);
        ArrayList<AggregationDesc> aggrDesc = groupByDesc.getAggregators();
        int size = aggrDesc.size();
        VectorAggregationDesc[] vecAggrDescs = new VectorAggregationDesc[size];
        int[] projectedOutputColumns = new int[size];
        for (int i = 0; i < size; ++i) {
            AggregationDesc aggDesc = aggrDesc.get(i);
            ImmutablePair<VectorAggregationDesc, String> pair = Vectorizer.getVectorAggregationDesc(aggDesc, vContext);
            if (pair.left == null) {
                return new ImmutablePair(null, pair.right);
            }
            vecAggrDescs[i] = (VectorAggregationDesc)pair.left;
            projectedOutputColumns[i] = i;
        }
        vectorGroupByDesc.setKeyExpressions(vecKeyExpressions);
        vectorGroupByDesc.setVecAggrDescs(vecAggrDescs);
        vectorGroupByDesc.setProjectedOutputColumns(projectedOutputColumns);
        Operator<GroupByDesc> vectorOp = OperatorFactory.getVectorOperator(groupByOp.getCompilationOpContext(), groupByDesc, vContext, vectorGroupByDesc);
        return new ImmutablePair<Operator<GroupByDesc>, Object>(vectorOp, null);
    }

    public static Operator<? extends OperatorDesc> vectorizeSelectOperator(Operator<? extends OperatorDesc> selectOp, VectorizationContext vContext, VectorSelectDesc vectorSelectDesc) throws HiveException {
        SelectDesc selectDesc = (SelectDesc)selectOp.getConf();
        List<ExprNodeDesc> colList = selectDesc.getColList();
        int index = 0;
        int size = colList.size();
        VectorExpression[] vectorSelectExprs = new VectorExpression[size];
        int[] projectedOutputColumns = new int[size];
        for (int i = 0; i < size; ++i) {
            ExprNodeDesc expr = colList.get(i);
            VectorExpression ve = vContext.getVectorExpression(expr);
            projectedOutputColumns[i] = ve.getOutputColumnNum();
            if (ve instanceof IdentityExpression) continue;
            vectorSelectExprs[index++] = ve;
        }
        if (index < size) {
            vectorSelectExprs = Arrays.copyOf(vectorSelectExprs, index);
        }
        Vectorizer.fixDecimalDataTypePhysicalVariations(vContext, vectorSelectExprs);
        vectorSelectDesc.setSelectExpressions(vectorSelectExprs);
        vectorSelectDesc.setProjectedOutputColumns(projectedOutputColumns);
        return OperatorFactory.getVectorOperator(selectOp.getCompilationOpContext(), selectDesc, vContext, vectorSelectDesc);
    }

    private static void fixDecimalDataTypePhysicalVariations(VectorizationContext vContext, VectorExpression[] vectorSelectExprs) throws HiveException {
        for (int i = 0; i < vectorSelectExprs.length; ++i) {
            VectorExpression parent = vectorSelectExprs[i];
            VectorExpression newParent = Vectorizer.fixDecimalDataTypePhysicalVariations(parent, parent.getChildExpressions(), vContext);
            if (parent.getClass() != newParent.getClass() || parent == newParent) continue;
            vectorSelectExprs[i] = newParent;
        }
    }

    private static VectorExpression fixDecimalDataTypePhysicalVariations(VectorExpression parent, VectorExpression[] children, VectorizationContext vContext) throws HiveException {
        if (children == null || children.length == 0) {
            return parent;
        }
        for (int i = 0; i < children.length; ++i) {
            VectorExpression child = children[i];
            VectorExpression newChild = Vectorizer.fixDecimalDataTypePhysicalVariations(child, child.getChildExpressions(), vContext);
            if (child.getClass() != newChild.getClass() || child == newChild) continue;
            children[i] = newChild;
        }
        if (parent.getOutputDataTypePhysicalVariation() == DataTypePhysicalVariation.NONE) {
            boolean inputArgsChanged = false;
            DataTypePhysicalVariation[] dataTypePhysicalVariations = parent.getInputDataTypePhysicalVariations();
            VectorExpression oldExpression = null;
            VectorExpression newExpression = null;
            for (int i = 0; i < children.length; ++i) {
                oldExpression = children[i];
                if (oldExpression.getOutputDataTypePhysicalVariation() != DataTypePhysicalVariation.DECIMAL_64) continue;
                children[i] = newExpression = vContext.wrapWithDecimal64ToDecimalConversion(oldExpression);
                inputArgsChanged = true;
                dataTypePhysicalVariations[i] = DataTypePhysicalVariation.NONE;
            }
            if (inputArgsChanged) {
                if (parent instanceof VectorUDFAdaptor) {
                    VectorUDFArgDesc[] argDescs;
                    VectorUDFAdaptor parentAdaptor = (VectorUDFAdaptor)parent;
                    for (VectorUDFArgDesc argDesc : argDescs = parentAdaptor.getArgDescs()) {
                        if (argDesc.getColumnNum() != oldExpression.getOutputColumnNum()) continue;
                        argDesc.setColumnNum(newExpression.getOutputColumnNum());
                        break;
                    }
                } else {
                    int argumentCount = children.length + (parent.getOutputColumnNum() == -1 ? 0 : 1);
                    Object[] arguments = new Object[argumentCount];
                    for (int i = 0; i < children.length; ++i) {
                        VectorExpression vce = children[i];
                        arguments[i] = vce.getOutputColumnNum();
                    }
                    if (parent.getOutputColumnNum() != -1) {
                        arguments[arguments.length - 1] = parent.getOutputColumnNum();
                    }
                    VectorExpression newParent = vContext.instantiateExpression(parent.getClass(), parent.getOutputTypeInfo(), parent.getOutputDataTypePhysicalVariation(), arguments);
                    newParent.setOutputTypeInfo(parent.getOutputTypeInfo());
                    newParent.setOutputDataTypePhysicalVariation(parent.getOutputDataTypePhysicalVariation());
                    newParent.setInputTypeInfos(parent.getInputTypeInfos());
                    newParent.setInputDataTypePhysicalVariations(dataTypePhysicalVariations);
                    newParent.setChildExpressions(parent.getChildExpressions());
                    return newParent;
                }
            }
        }
        return parent;
    }

    private static void fillInPTFEvaluators(List<WindowFunctionDef> windowsFunctions, String[] evaluatorFunctionNames, WindowFrameDef[] evaluatorWindowFrameDefs, List<ExprNodeDesc>[] evaluatorInputExprNodeDescLists) throws HiveException {
        int functionCount = windowsFunctions.size();
        for (int i = 0; i < functionCount; ++i) {
            WindowFunctionDef winFunc = windowsFunctions.get(i);
            evaluatorFunctionNames[i] = winFunc.getName();
            evaluatorWindowFrameDefs[i] = winFunc.getWindowFrame();
            List<PTFExpressionDef> args = winFunc.getArgs();
            if (args == null) continue;
            ArrayList<ExprNodeDesc> exprNodeDescList = new ArrayList<ExprNodeDesc>();
            for (PTFExpressionDef arg : args) {
                exprNodeDescList.add(arg.getExprNode());
            }
            evaluatorInputExprNodeDescLists[i] = exprNodeDescList;
        }
    }

    private static ExprNodeDesc[] getPartitionExprNodeDescs(List<PTFExpressionDef> partitionExpressions) {
        int size = partitionExpressions.size();
        ExprNodeDesc[] exprNodeDescs = new ExprNodeDesc[size];
        for (int i = 0; i < size; ++i) {
            exprNodeDescs[i] = partitionExpressions.get(i).getExprNode();
        }
        return exprNodeDescs;
    }

    private static ExprNodeDesc[] getOrderExprNodeDescs(List<OrderExpressionDef> orderExpressions) {
        int size = orderExpressions.size();
        ExprNodeDesc[] exprNodeDescs = new ExprNodeDesc[size];
        for (int i = 0; i < size; ++i) {
            exprNodeDescs[i] = orderExpressions.get(i).getExprNode();
        }
        return exprNodeDescs;
    }

    private static void createVectorPTFDesc(Operator<? extends OperatorDesc> ptfOp, PTFDesc ptfDesc, VectorizationContext vContext, VectorPTFDesc vectorPTFDesc, int vectorizedPTFMaxMemoryBufferingBatchCount) throws HiveException {
        ColumnInfo colInfo;
        int i;
        PartitionedTableFunctionDef funcDef = ptfDesc.getFuncDef();
        WindowTableFunctionDef windowTableFunctionDef = (WindowTableFunctionDef)funcDef;
        List<WindowFunctionDef> windowsFunctions = windowTableFunctionDef.getWindowFunctions();
        int functionCount = windowsFunctions.size();
        ArrayList<ColumnInfo> outputSignature = ptfOp.getSchema().getSignature();
        int outputSize = outputSignature.size();
        String[] outputColumnNames = new String[outputSize];
        TypeInfo[] outputTypeInfos = new TypeInfo[outputSize];
        for (i = 0; i < functionCount; ++i) {
            colInfo = outputSignature.get(i);
            TypeInfo typeInfo = colInfo.getType();
            outputColumnNames[i] = colInfo.getInternalName();
            outputTypeInfos[i] = typeInfo;
        }
        for (i = functionCount; i < outputSize; ++i) {
            colInfo = outputSignature.get(i);
            outputColumnNames[i] = colInfo.getInternalName();
            outputTypeInfos[i] = colInfo.getType();
        }
        List<PTFExpressionDef> partitionExpressions = funcDef.getPartition().getExpressions();
        int partitionKeyCount = partitionExpressions.size();
        ExprNodeDesc[] partitionExprNodeDescs = Vectorizer.getPartitionExprNodeDescs(partitionExpressions);
        List<OrderExpressionDef> orderExpressions = funcDef.getOrder().getExpressions();
        int orderKeyCount = orderExpressions.size();
        ExprNodeDesc[] orderExprNodeDescs = Vectorizer.getOrderExprNodeDescs(orderExpressions);
        boolean isPartitionOrderBy = false;
        if (partitionKeyCount != orderKeyCount) {
            isPartitionOrderBy = true;
        } else {
            for (int i2 = 0; i2 < partitionKeyCount; ++i2) {
                ExprNodeDesc.ExprNodeDescEqualityWrapper partitionExprEqualityWrapper = new ExprNodeDesc.ExprNodeDescEqualityWrapper(partitionExprNodeDescs[i2]);
                ExprNodeDesc.ExprNodeDescEqualityWrapper orderExprEqualityWrapper = new ExprNodeDesc.ExprNodeDescEqualityWrapper(orderExprNodeDescs[i2]);
                if (partitionExprEqualityWrapper.equals(orderExprEqualityWrapper)) continue;
                isPartitionOrderBy = true;
                break;
            }
        }
        String[] evaluatorFunctionNames = new String[functionCount];
        WindowFrameDef[] evaluatorWindowFrameDefs = new WindowFrameDef[functionCount];
        List[] evaluatorInputExprNodeDescLists = new List[functionCount];
        Vectorizer.fillInPTFEvaluators(windowsFunctions, evaluatorFunctionNames, evaluatorWindowFrameDefs, evaluatorInputExprNodeDescLists);
        TypeInfo[] reducerBatchTypeInfos = vContext.getAllTypeInfos();
        vectorPTFDesc.setReducerBatchTypeInfos(reducerBatchTypeInfos);
        vectorPTFDesc.setIsPartitionOrderBy(isPartitionOrderBy);
        vectorPTFDesc.setOrderExprNodeDescs(orderExprNodeDescs);
        vectorPTFDesc.setPartitionExprNodeDescs(partitionExprNodeDescs);
        vectorPTFDesc.setEvaluatorFunctionNames(evaluatorFunctionNames);
        vectorPTFDesc.setEvaluatorWindowFrameDefs(evaluatorWindowFrameDefs);
        vectorPTFDesc.setEvaluatorInputExprNodeDescLists(evaluatorInputExprNodeDescLists);
        vectorPTFDesc.setOutputColumnNames(outputColumnNames);
        vectorPTFDesc.setOutputTypeInfos(outputTypeInfos);
        vectorPTFDesc.setVectorizedPTFMaxMemoryBufferingBatchCount(vectorizedPTFMaxMemoryBufferingBatchCount);
    }

    private static void determineKeyAndNonKeyInputColumnMap(int[] outputColumnProjectionMap, boolean isPartitionOrderBy, int[] orderColumnMap, int[] partitionColumnMap, int evaluatorCount, ArrayList<Integer> keyInputColumns, ArrayList<Integer> nonKeyInputColumns) {
        int outputSize = outputColumnProjectionMap.length;
        int orderKeyCount = orderColumnMap.length;
        int partitionKeyCount = isPartitionOrderBy ? partitionColumnMap.length : 0;
        for (int i = evaluatorCount; i < outputSize; ++i) {
            int nonEvalColumnNum = outputColumnProjectionMap[i];
            boolean isKey = false;
            for (int o = 0; o < orderKeyCount; ++o) {
                if (nonEvalColumnNum != orderColumnMap[o]) continue;
                isKey = true;
                break;
            }
            if (!isKey && isPartitionOrderBy) {
                for (int p = 0; p < partitionKeyCount; ++p) {
                    if (nonEvalColumnNum != partitionColumnMap[p]) continue;
                    isKey = true;
                    break;
                }
            }
            if (isKey) {
                keyInputColumns.add(nonEvalColumnNum);
                continue;
            }
            nonKeyInputColumns.add(nonEvalColumnNum);
        }
    }

    private static VectorPTFInfo createVectorPTFInfo(Operator<? extends OperatorDesc> ptfOp, PTFDesc ptfDesc, VectorizationContext vContext, VectorPTFDesc vectorPTFDesc) throws HiveException {
        VectorExpression[] partitionExpressions;
        ColumnVector.Type[] partitionColumnVectorTypes;
        int[] partitionColumnMap;
        ColumnInfo colInfo;
        int i;
        PartitionedTableFunctionDef funcDef = ptfDesc.getFuncDef();
        ArrayList<ColumnInfo> outputSignature = ptfOp.getSchema().getSignature();
        int outputSize = outputSignature.size();
        boolean isPartitionOrderBy = vectorPTFDesc.getIsPartitionOrderBy();
        ExprNodeDesc[] orderExprNodeDescs = vectorPTFDesc.getOrderExprNodeDescs();
        ExprNodeDesc[] partitionExprNodeDescs = vectorPTFDesc.getPartitionExprNodeDescs();
        String[] evaluatorFunctionNames = vectorPTFDesc.getEvaluatorFunctionNames();
        int evaluatorCount = evaluatorFunctionNames.length;
        WindowFrameDef[] evaluatorWindowFrameDefs = vectorPTFDesc.getEvaluatorWindowFrameDefs();
        List<ExprNodeDesc>[] evaluatorInputExprNodeDescLists = vectorPTFDesc.getEvaluatorInputExprNodeDescLists();
        int[] outputColumnProjectionMap = new int[outputSize];
        for (i = 0; i < evaluatorCount; ++i) {
            int outputColumnNum;
            colInfo = outputSignature.get(i);
            TypeInfo typeInfo = colInfo.getType();
            outputColumnProjectionMap[i] = outputColumnNum = vContext.allocateScratchColumn(typeInfo);
        }
        for (i = evaluatorCount; i < outputSize; ++i) {
            colInfo = outputSignature.get(i);
            outputColumnProjectionMap[i] = vContext.getInputColumnIndex(colInfo.getInternalName());
        }
        if (!isPartitionOrderBy) {
            partitionColumnMap = null;
            partitionColumnVectorTypes = null;
            partitionExpressions = null;
        } else {
            int partitionKeyCount = partitionExprNodeDescs.length;
            partitionColumnMap = new int[partitionKeyCount];
            partitionColumnVectorTypes = new ColumnVector.Type[partitionKeyCount];
            partitionExpressions = new VectorExpression[partitionKeyCount];
            for (int i2 = 0; i2 < partitionKeyCount; ++i2) {
                ColumnVector.Type columnVectorType;
                VectorExpression partitionExpression = vContext.getVectorExpression(partitionExprNodeDescs[i2]);
                TypeInfo typeInfo = partitionExpression.getOutputTypeInfo();
                partitionColumnVectorTypes[i2] = columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
                partitionColumnMap[i2] = partitionExpression.getOutputColumnNum();
                partitionExpressions[i2] = partitionExpression;
            }
        }
        int orderKeyCount = orderExprNodeDescs.length;
        int[] orderColumnMap = new int[orderKeyCount];
        ColumnVector.Type[] orderColumnVectorTypes = new ColumnVector.Type[orderKeyCount];
        VectorExpression[] orderExpressions = new VectorExpression[orderKeyCount];
        for (int i3 = 0; i3 < orderKeyCount; ++i3) {
            ColumnVector.Type columnVectorType;
            VectorExpression orderExpression = vContext.getVectorExpression(orderExprNodeDescs[i3]);
            TypeInfo typeInfo = orderExpression.getOutputTypeInfo();
            orderColumnVectorTypes[i3] = columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
            orderColumnMap[i3] = orderExpression.getOutputColumnNum();
            orderExpressions[i3] = orderExpression;
        }
        ArrayList<Integer> keyInputColumns = new ArrayList<Integer>();
        ArrayList<Integer> nonKeyInputColumns = new ArrayList<Integer>();
        Vectorizer.determineKeyAndNonKeyInputColumnMap(outputColumnProjectionMap, isPartitionOrderBy, orderColumnMap, partitionColumnMap, evaluatorCount, keyInputColumns, nonKeyInputColumns);
        int[] keyInputColumnMap = ArrayUtils.toPrimitive(keyInputColumns.toArray(new Integer[0]));
        int[] nonKeyInputColumnMap = ArrayUtils.toPrimitive(nonKeyInputColumns.toArray(new Integer[0]));
        VectorExpression[] evaluatorInputExpressions = new VectorExpression[evaluatorCount];
        ColumnVector.Type[] evaluatorInputColumnVectorTypes = new ColumnVector.Type[evaluatorCount];
        for (int i4 = 0; i4 < evaluatorCount; ++i4) {
            ColumnVector.Type columnVectorType;
            VectorExpression inputVectorExpression;
            String functionName = evaluatorFunctionNames[i4];
            WindowFrameDef windowFrameDef = evaluatorWindowFrameDefs[i4];
            VectorPTFDesc.SupportedFunctionType functionType = VectorPTFDesc.supportedFunctionsMap.get(functionName);
            List<ExprNodeDesc> exprNodeDescList = evaluatorInputExprNodeDescLists[i4];
            if (exprNodeDescList != null) {
                ExprNodeDesc exprNodeDesc = exprNodeDescList.get(0);
                inputVectorExpression = vContext.getVectorExpression(exprNodeDesc);
                TypeInfo typeInfo = exprNodeDesc.getTypeInfo();
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
            } else {
                inputVectorExpression = null;
                columnVectorType = ColumnVector.Type.NONE;
            }
            evaluatorInputExpressions[i4] = inputVectorExpression;
            evaluatorInputColumnVectorTypes[i4] = columnVectorType;
        }
        VectorPTFInfo vectorPTFInfo = new VectorPTFInfo();
        vectorPTFInfo.setOutputColumnMap(outputColumnProjectionMap);
        vectorPTFInfo.setPartitionColumnMap(partitionColumnMap);
        vectorPTFInfo.setPartitionColumnVectorTypes(partitionColumnVectorTypes);
        vectorPTFInfo.setPartitionExpressions(partitionExpressions);
        vectorPTFInfo.setOrderColumnMap(orderColumnMap);
        vectorPTFInfo.setOrderColumnVectorTypes(orderColumnVectorTypes);
        vectorPTFInfo.setOrderExpressions(orderExpressions);
        vectorPTFInfo.setEvaluatorInputExpressions(evaluatorInputExpressions);
        vectorPTFInfo.setEvaluatorInputColumnVectorTypes(evaluatorInputColumnVectorTypes);
        vectorPTFInfo.setKeyInputColumnMap(keyInputColumnMap);
        vectorPTFInfo.setNonKeyInputColumnMap(nonKeyInputColumnMap);
        return vectorPTFInfo;
    }

    public static Operator<? extends OperatorDesc> vectorizePTFOperator(Operator<? extends OperatorDesc> ptfOp, VectorizationContext vContext, VectorPTFDesc vectorPTFDesc) throws HiveException {
        PTFDesc ptfDesc = (PTFDesc)ptfOp.getConf();
        VectorPTFInfo vectorPTFInfo = Vectorizer.createVectorPTFInfo(ptfOp, ptfDesc, vContext, vectorPTFDesc);
        vectorPTFDesc.setVectorPTFInfo(vectorPTFInfo);
        Class<VectorPTFOperator> opClass = VectorPTFOperator.class;
        return OperatorFactory.getVectorOperator(opClass, ptfOp.getCompilationOpContext(), ptfOp.getConf(), vContext, vectorPTFDesc);
    }

    public Operator<? extends OperatorDesc> vectorizeOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isReduce, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws HiveException, VectorizerCannotVectorizeException {
        Operator<? extends OperatorDesc> vectorOp = this.validateAndVectorizeOperator(op, vContext, isReduce, isTezOrSpark, vectorTaskColumnInfo);
        if (vectorOp != op) {
            this.fixupParentChildOperators(op, vectorOp);
        }
        return vectorOp;
    }

    public Operator<? extends OperatorDesc> validateAndVectorizeOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isReduce, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws HiveException, VectorizerCannotVectorizeException {
        boolean isNative;
        Operator<OperatorDesc> vectorOp = null;
        this.currentOperator = op;
        try {
            switch (op.getType()) {
                case MAPJOIN: {
                    if (op instanceof MapJoinOperator) {
                        if (!this.validateMapJoinOperator((MapJoinOperator)op)) {
                            throw new VectorizerCannotVectorizeException();
                        }
                    } else if (op instanceof SMBMapJoinOperator) {
                        if (!this.validateSMBMapJoinOperator((SMBMapJoinOperator)op)) {
                            throw new VectorizerCannotVectorizeException();
                        }
                    } else {
                        this.setOperatorNotSupported(op);
                        throw new VectorizerCannotVectorizeException();
                    }
                    if (op instanceof MapJoinOperator) {
                        VectorMapJoinDesc vectorMapJoinDesc;
                        MapJoinDesc desc = (MapJoinDesc)op.getConf();
                        boolean specialize = this.canSpecializeMapJoin(op, desc, isTezOrSpark, vContext, vectorMapJoinDesc = new VectorMapJoinDesc());
                        if (!specialize) {
                            Class opClass = null;
                            List<ExprNodeDesc> bigTableFilters = desc.getFilters().get((byte)desc.getPosBigTable());
                            boolean isOuterAndFiltered = !desc.isNoOuterJoin() && bigTableFilters.size() > 0;
                            opClass = !isOuterAndFiltered ? VectorMapJoinOperator.class : VectorMapJoinOuterFilteredOperator.class;
                            vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), desc, vContext, vectorMapJoinDesc);
                            isNative = false;
                            break;
                        }
                        vectorOp = this.specializeMapJoinOperator(op, vContext, desc, vectorMapJoinDesc);
                        isNative = true;
                        if (vectorTaskColumnInfo != null) {
                            VectorMapJoinInfo vectorMapJoinInfo = vectorMapJoinDesc.getVectorMapJoinInfo();
                            if (this.usesVectorUDFAdaptor(vectorMapJoinDesc.getAllBigTableKeyExpressions())) {
                                vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                            }
                            if (this.usesVectorUDFAdaptor(vectorMapJoinDesc.getAllBigTableValueExpressions())) {
                                vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                            }
                        }
                        break;
                    }
                    Preconditions.checkState(op instanceof SMBMapJoinOperator);
                    SMBJoinDesc smbJoinSinkDesc = (SMBJoinDesc)op.getConf();
                    if (smbJoinSinkDesc.getFilterMap() != null) {
                        this.setOperatorIssue("FilterMaps not supported for Vector Pass-Thru SMB MapJoin");
                        throw new VectorizerCannotVectorizeException();
                    }
                    VectorSMBJoinDesc vectorSMBJoinDesc = new VectorSMBJoinDesc();
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), smbJoinSinkDesc, vContext, vectorSMBJoinDesc);
                    isNative = false;
                    break;
                }
                case REDUCESINK: {
                    VectorReduceSinkDesc vectorReduceSinkDesc;
                    if (!this.validateReduceSinkOperator((ReduceSinkOperator)op)) {
                        throw new VectorizerCannotVectorizeException();
                    }
                    ReduceSinkDesc reduceDesc = (ReduceSinkDesc)op.getConf();
                    boolean specialize = this.canSpecializeReduceSink(reduceDesc, isTezOrSpark, vContext, vectorReduceSinkDesc = new VectorReduceSinkDesc());
                    if (!specialize) {
                        vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), reduceDesc, vContext, vectorReduceSinkDesc);
                        isNative = false;
                        break;
                    }
                    vectorOp = this.specializeReduceSinkOperator(op, vContext, reduceDesc, vectorReduceSinkDesc);
                    isNative = true;
                    if (vectorTaskColumnInfo != null) {
                        VectorReduceSinkInfo vectorReduceSinkInfo = vectorReduceSinkDesc.getVectorReduceSinkInfo();
                        if (this.usesVectorUDFAdaptor(vectorReduceSinkInfo.getReduceSinkKeyExpressions())) {
                            vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                        }
                        if (this.usesVectorUDFAdaptor(vectorReduceSinkInfo.getReduceSinkValueExpressions())) {
                            vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                        }
                    }
                    break;
                }
                case FILTER: {
                    VectorExpression vectorPredicateExpr;
                    if (!this.validateFilterOperator((FilterOperator)op)) {
                        throw new VectorizerCannotVectorizeException();
                    }
                    VectorFilterDesc vectorFilterDesc = new VectorFilterDesc();
                    vectorOp = Vectorizer.vectorizeFilterOperator(op, vContext, vectorFilterDesc);
                    isNative = true;
                    if (vectorTaskColumnInfo != null && this.usesVectorUDFAdaptor(vectorPredicateExpr = vectorFilterDesc.getPredicateExpression())) {
                        vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                    }
                    break;
                }
                case SELECT: {
                    VectorExpression[] vectorSelectExprs;
                    if (!this.validateSelectOperator((SelectOperator)op)) {
                        throw new VectorizerCannotVectorizeException();
                    }
                    VectorSelectDesc vectorSelectDesc = new VectorSelectDesc();
                    vectorOp = Vectorizer.vectorizeSelectOperator(op, vContext, vectorSelectDesc);
                    isNative = true;
                    if (vectorTaskColumnInfo != null && this.usesVectorUDFAdaptor(vectorSelectExprs = vectorSelectDesc.getSelectExpressions())) {
                        vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                    }
                    break;
                }
                case GROUPBY: {
                    VectorGroupByDesc vectorGroupByDesc = new VectorGroupByDesc();
                    if (!this.validateGroupByOperator((GroupByOperator)op, isReduce, isTezOrSpark, vectorGroupByDesc)) {
                        throw new VectorizerCannotVectorizeException();
                    }
                    ImmutablePair<Operator<? extends OperatorDesc>, String> pair = Vectorizer.doVectorizeGroupByOperator(op, vContext, vectorGroupByDesc);
                    if (pair.left == null) {
                        this.setOperatorIssue((String)pair.right);
                        throw new VectorizerCannotVectorizeException();
                    }
                    vectorOp = (Operator<ReduceSinkDesc>)pair.left;
                    isNative = false;
                    if (vectorTaskColumnInfo != null) {
                        VectorAggregationDesc[] vecAggrDescs;
                        VectorExpression[] vecKeyExpressions = vectorGroupByDesc.getKeyExpressions();
                        if (this.usesVectorUDFAdaptor(vecKeyExpressions)) {
                            vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                        }
                        for (VectorAggregationDesc vecAggrDesc : vecAggrDescs = vectorGroupByDesc.getVecAggrDescs()) {
                            if (!this.usesVectorUDFAdaptor(vecAggrDesc.getInputExpression())) continue;
                            vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                        }
                    }
                    break;
                }
                case FILESINK: {
                    if (!this.validateFileSinkOperator((FileSinkOperator)op)) {
                        throw new VectorizerCannotVectorizeException();
                    }
                    FileSinkDesc fileSinkDesc = (FileSinkDesc)op.getConf();
                    VectorFileSinkDesc vectorFileSinkDesc = new VectorFileSinkDesc();
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), fileSinkDesc, vContext, vectorFileSinkDesc);
                    isNative = false;
                    break;
                }
                case LIMIT: {
                    LimitDesc limitDesc = (LimitDesc)op.getConf();
                    VectorLimitDesc vectorLimitDesc = new VectorLimitDesc();
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), limitDesc, vContext, vectorLimitDesc);
                    isNative = true;
                    break;
                }
                case EVENT: {
                    AppMasterEventDesc eventDesc = (AppMasterEventDesc)op.getConf();
                    VectorAppMasterEventDesc vectorEventDesc = new VectorAppMasterEventDesc();
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), eventDesc, vContext, vectorEventDesc);
                    isNative = true;
                    break;
                }
                case PTF: {
                    VectorPTFDesc vectorPTFDesc = new VectorPTFDesc();
                    if (!this.validatePTFOperator((PTFOperator)op, vContext, vectorPTFDesc)) {
                        throw new VectorizerCannotVectorizeException();
                    }
                    vectorOp = Vectorizer.vectorizePTFOperator(op, vContext, vectorPTFDesc);
                    isNative = true;
                    break;
                }
                case HASHTABLESINK: {
                    SparkHashTableSinkDesc sparkHashTableSinkDesc = (SparkHashTableSinkDesc)op.getConf();
                    VectorSparkHashTableSinkDesc vectorSparkHashTableSinkDesc = new VectorSparkHashTableSinkDesc();
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), sparkHashTableSinkDesc, vContext, vectorSparkHashTableSinkDesc);
                    isNative = true;
                    break;
                }
                case SPARKPRUNINGSINK: {
                    SparkPartitionPruningSinkDesc sparkPartitionPruningSinkDesc = (SparkPartitionPruningSinkDesc)op.getConf();
                    VectorSparkPartitionPruningSinkDesc vectorSparkPartitionPruningSinkDesc = new VectorSparkPartitionPruningSinkDesc();
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), sparkPartitionPruningSinkDesc, vContext, vectorSparkPartitionPruningSinkDesc);
                    ((SparkPartitionPruningSinkOperator)vectorOp).setUniqueId(((SparkPartitionPruningSinkOperator)op).getUniqueId());
                    isNative = true;
                    break;
                }
                default: {
                    this.setOperatorNotSupported(op);
                    throw new VectorizerCannotVectorizeException();
                }
            }
        }
        catch (HiveException e) {
            this.setOperatorIssue(e.getMessage());
            throw new VectorizerCannotVectorizeException();
        }
        Preconditions.checkState(vectorOp != null);
        if (vectorTaskColumnInfo != null && !isNative) {
            vectorTaskColumnInfo.setAllNative(false);
        }
        LOG.debug("vectorizeOperator " + vectorOp.getClass().getName());
        LOG.debug("vectorizeOperator " + vectorOp.getConf().getClass().getName());
        this.planMapper.link(op, vectorOp);
        return vectorOp;
    }

    static {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("int");
        patternBuilder.append("|smallint");
        patternBuilder.append("|tinyint");
        patternBuilder.append("|bigint");
        patternBuilder.append("|integer");
        patternBuilder.append("|long");
        patternBuilder.append("|short");
        patternBuilder.append("|timestamp");
        patternBuilder.append("|interval_year_month");
        patternBuilder.append("|interval_day_time");
        patternBuilder.append("|boolean");
        patternBuilder.append("|binary");
        patternBuilder.append("|string");
        patternBuilder.append("|byte");
        patternBuilder.append("|float");
        patternBuilder.append("|double");
        patternBuilder.append("|date");
        patternBuilder.append("|void");
        patternBuilder.append("|decimal.*");
        patternBuilder.append("|char.*");
        patternBuilder.append("|varchar.*");
        supportedDataTypesPattern = Pattern.compile(patternBuilder.toString());
        vectorizableVirtualColumns = ImmutableSet.of(VirtualColumn.ROWID);
        vectorDeserializeTextSupportSet = new TreeSet<VectorizedSupport.Support>();
        vectorDeserializeTextSupportSet.addAll(Arrays.asList(VectorizedSupport.Support.values()));
        supportedAcidInputFormats = new TreeSet<String>();
        supportedAcidInputFormats.add(OrcInputFormat.class.getName());
        supportedAcidInputFormats.add(NullRowsInputFormat.class.getName());
        supportedAcidInputFormats.add(OneNullRowInputFormat.class.getName());
    }

    class VectorizationDispatcher
    implements Dispatcher {
        VectorizationDispatcher() {
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task currTask = (Task)nd;
            if (currTask instanceof MapRedTask) {
                MapredWork mapredWork = (MapredWork)((MapRedTask)currTask).getWork();
                MapWork mapWork = mapredWork.getMapWork();
                this.setMapWorkExplainConditions(mapWork);
                this.convertMapWork(mapredWork.getMapWork(), false);
                this.logMapWorkExplainVectorization(mapWork);
                ReduceWork reduceWork = mapredWork.getReduceWork();
                if (reduceWork != null) {
                    this.setReduceWorkExplainConditions(reduceWork);
                    this.logReduceWorkExplainVectorization(reduceWork);
                }
            } else if (currTask instanceof TezTask) {
                TezWork work = (TezWork)((TezTask)currTask).getWork();
                for (BaseWork baseWork : work.getAllWork()) {
                    if (baseWork instanceof MapWork) {
                        MapWork mapWork = (MapWork)baseWork;
                        this.setMapWorkExplainConditions(mapWork);
                        this.convertMapWork(mapWork, true);
                        this.logMapWorkExplainVectorization(mapWork);
                        continue;
                    }
                    if (!(baseWork instanceof ReduceWork)) continue;
                    ReduceWork reduceWork = (ReduceWork)baseWork;
                    this.setReduceWorkExplainConditions(reduceWork);
                    if (Vectorizer.this.isReduceVectorizationEnabled) {
                        this.convertReduceWork(reduceWork);
                    }
                    this.logReduceWorkExplainVectorization(reduceWork);
                }
            } else if (currTask instanceof SparkTask) {
                SparkWork sparkWork = (SparkWork)currTask.getWork();
                for (BaseWork baseWork : sparkWork.getAllWork()) {
                    if (baseWork instanceof MapWork) {
                        MapWork mapWork = (MapWork)baseWork;
                        this.setMapWorkExplainConditions(mapWork);
                        this.convertMapWork(mapWork, true);
                        this.logMapWorkExplainVectorization(mapWork);
                        continue;
                    }
                    if (!(baseWork instanceof ReduceWork)) continue;
                    ReduceWork reduceWork = (ReduceWork)baseWork;
                    this.setReduceWorkExplainConditions(reduceWork);
                    if (Vectorizer.this.isReduceVectorizationEnabled) {
                        this.convertReduceWork(reduceWork);
                    }
                    this.logReduceWorkExplainVectorization(reduceWork);
                }
            } else if (currTask instanceof FetchTask) {
                LOG.info("Vectorizing Fetch not supported");
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring vectorization of " + currTask.getClass().getSimpleName());
            }
            return null;
        }

        private void setExplainConditions(BaseWork baseWork) {
            Vectorizer.this.currentBaseWork = baseWork;
            baseWork.setVectorizedVertexNum(++Vectorizer.this.vectorizedVertexNum);
            baseWork.setVectorizationExamined(true);
        }

        private void setMapWorkExplainConditions(MapWork mapWork) {
            this.setExplainConditions(mapWork);
        }

        private void setReduceWorkExplainConditions(ReduceWork reduceWork) {
            this.setExplainConditions(reduceWork);
            reduceWork.setReduceVectorizationEnabled(Vectorizer.this.isReduceVectorizationEnabled);
            reduceWork.setVectorReduceEngine(HiveConf.getVar(Vectorizer.this.hiveConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE));
        }

        private boolean logExplainVectorization(BaseWork baseWork, String name) {
            VectorizerReason notVectorizedReason;
            if (!baseWork.getVectorizationExamined()) {
                return false;
            }
            LOG.info(name + " vectorization enabled: " + baseWork.getVectorizationEnabled());
            boolean isVectorized = baseWork.getVectorMode();
            LOG.info(name + " vectorized: " + isVectorized);
            if (!isVectorized && (notVectorizedReason = baseWork.getNotVectorizedReason()) != null) {
                LOG.info(name + " notVectorizedReason: " + notVectorizedReason.toString());
            }
            LOG.info(name + " vectorizedVertexNum: " + baseWork.getVectorizedVertexNum());
            if (LOG.isDebugEnabled() && isVectorized) {
                VectorizedRowBatchCtx batchContext = baseWork.getVectorizedRowBatchCtx();
                LOG.debug(name + " dataColumnCount: " + batchContext.getDataColumnCount());
                int[] dataColumnNums = batchContext.getDataColumnNums();
                if (dataColumnNums != null) {
                    LOG.debug(name + " includeColumns: " + Arrays.toString(dataColumnNums));
                }
                LOG.debug(name + " partitionColumnCount: " + batchContext.getPartitionColumnCount());
                LOG.debug(name + " dataColumns: " + BaseWork.BaseExplainVectorization.getColumns(batchContext, 0, batchContext.getDataColumnCount()));
                LOG.debug(name + " scratchColumnTypeNames: " + BaseWork.BaseExplainVectorization.getScratchColumns(batchContext));
                VirtualColumn[] neededVirtualColumns = batchContext.getNeededVirtualColumns();
                if (neededVirtualColumns != null && neededVirtualColumns.length != 0) {
                    LOG.debug(name + " neededVirtualColumns: " + Arrays.toString((Object[])neededVirtualColumns));
                }
            }
            return true;
        }

        private void logMapWorkExplainVectorization(MapWork mapWork) {
            Set<String> inputFileFormatClassNameSet;
            List<String> enabledConditionsNotMet;
            if (!this.logExplainVectorization(mapWork, "Map")) {
                return;
            }
            List<String> enabledConditionsMet = mapWork.getVectorizationEnabledConditionsMet();
            if (enabledConditionsMet != null && !enabledConditionsMet.isEmpty()) {
                LOG.info("Map enabledConditionsMet: " + enabledConditionsMet.toString());
            }
            if ((enabledConditionsNotMet = mapWork.getVectorizationEnabledConditionsNotMet()) != null && !enabledConditionsNotMet.isEmpty()) {
                LOG.info("Map enabledConditionsNotMet: " + enabledConditionsNotMet.toString());
            }
            if ((inputFileFormatClassNameSet = mapWork.getVectorizationInputFileFormatClassNameSet()) != null && !inputFileFormatClassNameSet.isEmpty()) {
                LOG.info("Map inputFileFormatClassNameSet: " + inputFileFormatClassNameSet.toString());
            }
        }

        private void logReduceWorkExplainVectorization(ReduceWork reduceWork) {
            if (!this.logExplainVectorization(reduceWork, "Reduce")) {
                return;
            }
            LOG.info("Reducer " + HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED.varname + ": " + reduceWork.getReduceVectorizationEnabled());
            LOG.info("Reducer engine: " + reduceWork.getVectorReduceEngine());
        }

        private void convertMapWork(MapWork mapWork, boolean isTezOrSpark) throws SemanticException {
            VectorTaskColumnInfo vectorTaskColumnInfo = new VectorTaskColumnInfo();
            vectorTaskColumnInfo.assume();
            this.validateAndVectorizeMapWork(mapWork, vectorTaskColumnInfo, isTezOrSpark);
        }

        private void addMapWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + ".*" + FileSinkOperator.getOperatorName()), np);
            opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + ".*" + ReduceSinkOperator.getOperatorName()), np);
        }

        private ImmutablePair<String, TableScanOperator> verifyOnlyOneTableScanOperator(MapWork mapWork) {
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = mapWork.getAliasToWork();
            if (aliasToWork == null || aliasToWork.size() == 0) {
                Vectorizer.this.setNodeIssue("Vectorized map work requires work");
                return null;
            }
            int tableScanCount = 0;
            String alias = "";
            TableScanOperator tableScanOperator = null;
            for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : aliasToWork.entrySet()) {
                Operator<? extends OperatorDesc> op = entry.getValue();
                if (op == null) {
                    Vectorizer.this.setNodeIssue("Vectorized map work requires a valid alias");
                    return null;
                }
                if (!(op instanceof TableScanOperator)) continue;
                ++tableScanCount;
                alias = entry.getKey();
                tableScanOperator = (TableScanOperator)op;
            }
            if (tableScanCount > 1) {
                Vectorizer.this.setNodeIssue("Vectorized map work only works with 1 TableScanOperator");
                return null;
            }
            return new ImmutablePair<String, Object>(alias, tableScanOperator);
        }

        private void getTableScanOperatorSchemaInfo(TableScanOperator tableScanOperator, List<String> logicalColumnNameList, List<TypeInfo> logicalTypeInfoList, List<VirtualColumn> availableVirtualColumnList) {
            RowSchema rowSchema = tableScanOperator.getSchema();
            for (ColumnInfo c : rowSchema.getSignature()) {
                String columnName = c.getInternalName();
                VirtualColumn virtualColumn = VirtualColumn.VIRTUAL_COLUMN_NAME_MAP.get(columnName);
                if (virtualColumn != null) {
                    if (!vectorizableVirtualColumns.contains((Object)virtualColumn) || virtualColumn == VirtualColumn.ROWID && !Vectorizer.this.isVectorizedRowIdentifierEnabled) continue;
                    availableVirtualColumnList.add(virtualColumn);
                }
                logicalColumnNameList.add(columnName);
                logicalTypeInfoList.add(TypeInfoUtils.getTypeInfoFromTypeString(c.getTypeName()));
            }
        }

        private void determineDataColumnNums(TableScanOperator tableScanOperator, List<String> allColumnNameList, int dataColumnCount, List<Integer> dataColumnNums) {
            HashSet<String> neededColumns = new HashSet<String>(tableScanOperator.getNeededColumns());
            for (int dataColumnNum = 0; dataColumnNum < dataColumnCount; ++dataColumnNum) {
                String columnName = allColumnNameList.get(dataColumnNum);
                if (!neededColumns.contains(columnName)) continue;
                dataColumnNums.add(dataColumnNum);
            }
        }

        private VectorizedSupport.Support[] getVectorizedInputFormatSupports(Class<? extends InputFormat> inputFileFormatClass) {
            try {
                InputFormat inputFormat = FetchOperator.getInputFormatFromCache(inputFileFormatClass, Vectorizer.this.hiveConf);
                if (inputFormat instanceof VectorizedInputFormatInterface) {
                    return ((VectorizedInputFormatInterface)inputFormat).getSupportedFeatures();
                }
            }
            catch (IOException e) {
                LOG.error("Unable to instantiate {} input format class. Cannot determine vectorization support.", (Throwable)e);
            }
            return null;
        }

        private void addVectorizedInputFileFormatSupport(Set<VectorizedSupport.Support> newSupportSet, boolean isInputFileFormatVectorized, Class<? extends InputFormat> inputFileFormatClass) {
            VectorizedSupport.Support[] supports = isInputFileFormatVectorized ? this.getVectorizedInputFormatSupports(inputFileFormatClass) : null;
            if (supports != null) {
                for (VectorizedSupport.Support support : supports) {
                    newSupportSet.add(support);
                }
            }
        }

        private void handleSupport(boolean isFirstPartition, Set<VectorizedSupport.Support> inputFormatSupportSet, Set<VectorizedSupport.Support> newSupportSet) {
            if (isFirstPartition) {
                inputFormatSupportSet.addAll(newSupportSet);
            } else if (!newSupportSet.equals(inputFormatSupportSet)) {
                inputFormatSupportSet.retainAll(newSupportSet);
            }
        }

        private void addVectorPartitionDesc(PartitionDesc pd, VectorPartitionDesc vpd, Map<VectorPartitionDesc, VectorPartitionDesc> vectorPartitionDescMap) {
            VectorPartitionDesc existingEle = vectorPartitionDescMap.get(vpd);
            if (existingEle != null) {
                vpd = existingEle;
            } else {
                vectorPartitionDescMap.put(vpd, vpd);
            }
            pd.setVectorPartitionDesc(vpd);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean verifyAndSetVectorPartDesc(PartitionDesc pd, boolean isFullAcidTable, List<TypeInfo> allTypeInfoList, Set<String> inputFileFormatClassNameSet, Map<VectorPartitionDesc, VectorPartitionDesc> vectorPartitionDescMap, Set<String> enabledConditionsMetSet, ArrayList<String> enabledConditionsNotMetList, Set<VectorizedSupport.Support> newSupportSet) {
            boolean isVectorDeserializeEligable;
            Class<? extends InputFormat> inputFileFormatClass = pd.getInputFileFormatClass();
            String inputFileFormatClassName = inputFileFormatClass.getName();
            inputFileFormatClassNameSet.add(inputFileFormatClassName);
            boolean isInputFileFormatVectorized = Utilities.isInputFileFormatVectorized(pd);
            if (isFullAcidTable) {
                Preconditions.checkState(isInputFileFormatVectorized);
                Preconditions.checkState(supportedAcidInputFormats.contains(inputFileFormatClassName));
                if (!Vectorizer.this.useVectorizedInputFileFormat) {
                    enabledConditionsNotMetList.add("Vectorizing ACID tables requires " + HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                    return false;
                }
                this.addVectorizedInputFileFormatSupport(newSupportSet, isInputFileFormatVectorized, inputFileFormatClass);
                this.addVectorPartitionDesc(pd, VectorPartitionDesc.createVectorizedInputFileFormat(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd)), vectorPartitionDescMap);
                enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return true;
            }
            if (Vectorizer.this.useVectorizedInputFileFormat && isInputFileFormatVectorized && !this.isInputFormatExcluded(inputFileFormatClassName, Vectorizer.this.vectorizedInputFormatExcludes) && !this.hasUnsupportedVectorizedParquetDataType(inputFileFormatClass, allTypeInfoList)) {
                this.addVectorizedInputFileFormatSupport(newSupportSet, isInputFileFormatVectorized, inputFileFormatClass);
                this.addVectorPartitionDesc(pd, VectorPartitionDesc.createVectorizedInputFileFormat(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd)), vectorPartitionDescMap);
                enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return true;
            }
            if (!Vectorizer.this.isSchemaEvolution) {
                enabledConditionsNotMetList.add("Vectorizing tables without Schema Evolution requires " + HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return false;
            }
            String deserializerClassName = pd.getDeserializerClassName();
            boolean isTextFormat = inputFileFormatClassName.equals(TextInputFormat.class.getName()) && deserializerClassName.equals(LazySimpleSerDe.class.getName());
            boolean isSequenceFormat = inputFileFormatClassName.equals(SequenceFileInputFormat.class.getName()) && deserializerClassName.equals(LazyBinarySerDe.class.getName());
            boolean bl = isVectorDeserializeEligable = isTextFormat || isSequenceFormat;
            if (Vectorizer.this.useVectorDeserialize) {
                if (isTextFormat) {
                    boolean lastColumnTakesRest;
                    Properties properties = pd.getTableDesc().getProperties();
                    String lastColumnTakesRestString = properties.getProperty("serialization.last.column.takes.rest");
                    boolean bl2 = lastColumnTakesRest = lastColumnTakesRestString != null && lastColumnTakesRestString.equalsIgnoreCase("true");
                    if (!lastColumnTakesRest) {
                        newSupportSet.addAll(vectorDeserializeTextSupportSet);
                        this.addVectorPartitionDesc(pd, VectorPartitionDesc.createVectorDeserialize(inputFileFormatClassName, VectorPartitionDesc.VectorDeserializeType.LAZY_SIMPLE), vectorPartitionDescMap);
                        enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE.varname);
                        return true;
                    }
                    if (Vectorizer.this.useRowDeserialize && !this.isInputFormatExcluded(inputFileFormatClassName, Vectorizer.this.rowDeserializeInputFormatExcludes)) {
                        enabledConditionsNotMetList.add(inputFileFormatClassName + " " + "serialization.last.column.takes.rest" + " must be disabled ");
                        return false;
                    }
                } else if (isSequenceFormat) {
                    this.addVectorPartitionDesc(pd, VectorPartitionDesc.createVectorDeserialize(inputFileFormatClassName, VectorPartitionDesc.VectorDeserializeType.LAZY_BINARY), vectorPartitionDescMap);
                    enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE.varname);
                    return true;
                }
            }
            if (Vectorizer.this.useRowDeserialize) {
                boolean isRowDeserializeExcluded = this.isInputFormatExcluded(inputFileFormatClassName, Vectorizer.this.rowDeserializeInputFormatExcludes);
                if (!isRowDeserializeExcluded && !isInputFileFormatVectorized) {
                    this.addVectorPartitionDesc(pd, VectorPartitionDesc.createRowDeserialize(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd), deserializerClassName), vectorPartitionDescMap);
                    enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE.varname);
                    return true;
                }
                if (isInputFileFormatVectorized) {
                    enabledConditionsNotMetList.add("Row deserialization of vectorized input format not supported");
                } else {
                    enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE.varname + " IS true AND " + HiveConf.ConfVars.HIVE_VECTORIZATION_ROW_DESERIALIZE_INPUTFORMAT_EXCLUDES.varname + " NOT CONTAINS " + inputFileFormatClassName);
                }
            }
            if (isInputFileFormatVectorized) {
                if (Vectorizer.this.useVectorizedInputFileFormat) {
                    enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname + " IS true AND " + HiveConf.ConfVars.HIVE_VECTORIZATION_VECTORIZED_INPUT_FILE_FORMAT_EXCLUDES.varname + " NOT CONTAINS " + inputFileFormatClassName);
                    return false;
                }
                enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return false;
            }
            if (!isVectorDeserializeEligable) {
                enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE.varname);
                return false;
            }
            Preconditions.checkState(!Vectorizer.this.useVectorDeserialize);
            enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE.varname);
            return false;
        }

        private boolean shouldUseVectorizedInputFormat(Set<String> inputFileFormatClassNames) {
            if (inputFileFormatClassNames == null || inputFileFormatClassNames.isEmpty() || !Vectorizer.this.useVectorizedInputFileFormat) {
                return Vectorizer.this.useVectorizedInputFileFormat;
            }
            for (String inputFormat : inputFileFormatClassNames) {
                if (!this.isInputFormatExcluded(inputFormat, Vectorizer.this.vectorizedInputFormatExcludes)) continue;
                return false;
            }
            return true;
        }

        private boolean isInputFormatExcluded(String inputFileFormatClassName, Collection<Class<?>> excludes) {
            Class<?> ifClass = null;
            try {
                ifClass = Class.forName(inputFileFormatClassName);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot verify class for " + inputFileFormatClassName, (Throwable)e);
                return true;
            }
            if (excludes == null || excludes.isEmpty()) {
                return false;
            }
            for (Class<?> badClass : excludes) {
                if (!badClass.isAssignableFrom(ifClass)) continue;
                return true;
            }
            return false;
        }

        private boolean hasUnsupportedVectorizedParquetDataType(Class<? extends InputFormat> inputFileFormatClass, List<TypeInfo> allTypeInfoList) {
            if (!inputFileFormatClass.equals(MapredParquetInputFormat.class)) {
                return false;
            }
            block6: for (TypeInfo typeInfo : allTypeInfoList) {
                if (typeInfo instanceof PrimitiveTypeInfo) continue;
                switch (typeInfo.getCategory()) {
                    case LIST: {
                        if (((ListTypeInfo)typeInfo).getListElementTypeInfo() instanceof PrimitiveTypeInfo) continue block6;
                        return true;
                    }
                    case MAP: {
                        MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                        if (!(mapTypeInfo.getMapKeyTypeInfo() instanceof PrimitiveTypeInfo)) {
                            return true;
                        }
                        if (mapTypeInfo.getMapValueTypeInfo() instanceof PrimitiveTypeInfo) continue block6;
                        return true;
                    }
                    case STRUCT: {
                        StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                        ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                        for (TypeInfo fieldTypeInfo : fieldTypeInfos) {
                            if (fieldTypeInfo instanceof PrimitiveTypeInfo) continue;
                            return true;
                        }
                        continue block6;
                    }
                    case UNION: {
                        return false;
                    }
                    default: {
                        throw new RuntimeException("Unsupported complex type category " + (Object)((Object)typeInfo.getCategory()));
                    }
                }
            }
            return false;
        }

        private void setValidateInputFormatAndSchemaEvolutionExplain(MapWork mapWork, Set<String> inputFileFormatClassNameSet, Map<VectorPartitionDesc, VectorPartitionDesc> vectorPartitionDescMap, Set<String> enabledConditionsMetSet, ArrayList<String> enabledConditionsNotMetList) {
            mapWork.setVectorizationInputFileFormatClassNameSet(inputFileFormatClassNameSet);
            ArrayList<VectorPartitionDesc> vectorPartitionDescList = new ArrayList<VectorPartitionDesc>();
            vectorPartitionDescList.addAll(vectorPartitionDescMap.keySet());
            mapWork.setVectorPartitionDescList(vectorPartitionDescList);
            mapWork.setVectorizationEnabledConditionsMet(new ArrayList<String>(enabledConditionsMetSet));
            mapWork.setVectorizationEnabledConditionsNotMet(enabledConditionsNotMetList);
        }

        private ImmutablePair<Boolean, Boolean> validateInputFormatAndSchemaEvolution(MapWork mapWork, String alias, TableScanOperator tableScanOperator, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            boolean isFullAcidTable = ((TableScanDesc)tableScanOperator.getConf()).isFullAcidTable();
            ArrayList<String> allColumnNameList = new ArrayList<String>();
            ArrayList<TypeInfo> allTypeInfoList = new ArrayList<TypeInfo>();
            ArrayList<VirtualColumn> availableVirtualColumnList = new ArrayList<VirtualColumn>();
            this.getTableScanOperatorSchemaInfo(tableScanOperator, allColumnNameList, allTypeInfoList, availableVirtualColumnList);
            int virtualColumnCount = availableVirtualColumnList.size();
            ArrayList<Integer> dataColumnNums = new ArrayList<Integer>();
            int dataAndPartColumnCount = allColumnNameList.size() - virtualColumnCount;
            boolean isFirst = true;
            int dataColumnCount = 0;
            int partitionColumnCount = 0;
            List tableDataColumnList = null;
            List<TypeInfo> tableDataTypeInfoList = null;
            LinkedHashMap<Path, ArrayList<String>> pathToAliases = mapWork.getPathToAliases();
            LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
            HashSet<String> inputFileFormatClassNameSet = new HashSet<String>();
            LinkedHashMap<VectorPartitionDesc, VectorPartitionDesc> vectorPartitionDescMap = new LinkedHashMap<VectorPartitionDesc, VectorPartitionDesc>();
            HashSet<String> enabledConditionsMetSet = new HashSet<String>();
            ArrayList<String> enabledConditionsNotMetList = new ArrayList<String>();
            TreeSet<VectorizedSupport.Support> inputFormatSupportSet = new TreeSet<VectorizedSupport.Support>();
            boolean outsideLoopIsFirstPartition = true;
            for (Map.Entry<Path, ArrayList<String>> entry : pathToAliases.entrySet()) {
                List<TypeInfo> nextDataTypeInfoList;
                StructObjectInspector partObjectInspector;
                Deserializer deserializer;
                boolean isPresent;
                boolean isFirstPartition = outsideLoopIsFirstPartition;
                outsideLoopIsFirstPartition = false;
                Path path = entry.getKey();
                List aliases = entry.getValue();
                boolean bl = isPresent = aliases != null && aliases.indexOf(alias) != -1;
                if (!isPresent) {
                    Vectorizer.this.setOperatorIssue("Alias " + alias + " not present in aliases " + aliases);
                    return new ImmutablePair<Boolean, Boolean>(false, false);
                }
                PartitionDesc partDesc = pathToPartitionInfo.get(path);
                if (partDesc.getVectorPartitionDesc() != null) continue;
                TreeSet<VectorizedSupport.Support> newSupportSet = new TreeSet<VectorizedSupport.Support>();
                boolean isVerifiedVectorPartDesc = this.verifyAndSetVectorPartDesc(partDesc, isFullAcidTable, allTypeInfoList, inputFileFormatClassNameSet, vectorPartitionDescMap, enabledConditionsMetSet, enabledConditionsNotMetList, newSupportSet);
                if (!isVerifiedVectorPartDesc) {
                    this.setValidateInputFormatAndSchemaEvolutionExplain(mapWork, inputFileFormatClassNameSet, vectorPartitionDescMap, enabledConditionsMetSet, enabledConditionsNotMetList);
                    return new ImmutablePair<Boolean, Boolean>(false, true);
                }
                this.handleSupport(isFirstPartition, inputFormatSupportSet, newSupportSet);
                VectorPartitionDesc vectorPartDesc = partDesc.getVectorPartitionDesc();
                if (isFirst) {
                    LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
                    if (partSpec != null && partSpec.size() > 0) {
                        partitionColumnCount = partSpec.size();
                        dataColumnCount = dataAndPartColumnCount - partitionColumnCount;
                    } else {
                        partitionColumnCount = 0;
                        dataColumnCount = dataAndPartColumnCount;
                    }
                    this.determineDataColumnNums(tableScanOperator, allColumnNameList, dataColumnCount, dataColumnNums);
                    tableDataColumnList = allColumnNameList.subList(0, dataColumnCount);
                    tableDataTypeInfoList = allTypeInfoList.subList(0, dataColumnCount);
                    isFirst = false;
                }
                try {
                    deserializer = partDesc.getDeserializer(Vectorizer.this.hiveConf);
                    partObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
                }
                catch (Exception e) {
                    throw new SemanticException(e);
                }
                String nextDataColumnsString = ObjectInspectorUtils.getFieldNames(partObjectInspector);
                String[] nextDataColumns = nextDataColumnsString.split(",");
                List<String> nextDataColumnList = Arrays.asList(nextDataColumns);
                if (nextDataColumnList.size() > tableDataColumnList.size()) {
                    enabledConditionsNotMetList.add(String.format("Could not enable vectorization due to partition column names size %d is greater than the number of table column names size %d", nextDataColumnList.size(), tableDataColumnList.size()));
                    this.setValidateInputFormatAndSchemaEvolutionExplain(mapWork, inputFileFormatClassNameSet, vectorPartitionDescMap, enabledConditionsMetSet, enabledConditionsNotMetList);
                    return new ImmutablePair<Boolean, Boolean>(false, true);
                }
                if (!(deserializer instanceof NullStructSerDe)) {
                    for (int i = 0; i < nextDataColumnList.size(); ++i) {
                        String tableColumnName;
                        String nextColumnName = nextDataColumnList.get(i);
                        if (nextColumnName.equals(tableColumnName = (String)tableDataColumnList.get(i))) continue;
                        enabledConditionsNotMetList.add(String.format("Could not enable vectorization due to partition column name %s does not match table column name %s", nextColumnName, tableColumnName));
                        this.setValidateInputFormatAndSchemaEvolutionExplain(mapWork, inputFileFormatClassNameSet, vectorPartitionDescMap, enabledConditionsMetSet, enabledConditionsNotMetList);
                        return new ImmutablePair<Boolean, Boolean>(false, true);
                    }
                }
                boolean isPartitionRowConversion = false;
                if (vectorPartDesc.getIsInputFileFormatSelfDescribing()) {
                    nextDataTypeInfoList = tableDataTypeInfoList;
                } else {
                    String nextDataTypesString = ObjectInspectorUtils.getFieldTypes(partObjectInspector);
                    nextDataTypeInfoList = TypeInfoUtils.getTypeInfosFromTypeString(nextDataTypesString);
                    int nextDataTypeInfoSize = nextDataTypeInfoList.size();
                    if (nextDataTypeInfoSize > tableDataTypeInfoList.size()) {
                        enabledConditionsNotMetList.add(String.format("Could not enable vectorization due to partition column types size %d is greater than the number of table column types size %d", nextDataTypeInfoSize, tableDataTypeInfoList.size()));
                        this.setValidateInputFormatAndSchemaEvolutionExplain(mapWork, inputFileFormatClassNameSet, vectorPartitionDescMap, enabledConditionsMetSet, enabledConditionsNotMetList);
                        return new ImmutablePair<Boolean, Boolean>(false, true);
                    }
                    for (int i = 0; i < nextDataTypeInfoSize; ++i) {
                        TypeInfo nextDataTypeInfo;
                        TypeInfo tableDataTypeInfo = tableDataTypeInfoList.get(i);
                        if (tableDataTypeInfo.equals(nextDataTypeInfo = nextDataTypeInfoList.get(i))) continue;
                        isPartitionRowConversion = true;
                        break;
                    }
                }
                if (isPartitionRowConversion && Vectorizer.this.isLlapIoEnabled) {
                    enabledConditionsNotMetList.add("Could not enable vectorization. LLAP I/O is enabled wbich automatically deserializes into VECTORIZED_INPUT_FILE_FORMAT. A partition requires data type conversion and that is not supported");
                    this.setValidateInputFormatAndSchemaEvolutionExplain(mapWork, inputFileFormatClassNameSet, vectorPartitionDescMap, enabledConditionsMetSet, enabledConditionsNotMetList);
                    return new ImmutablePair<Boolean, Boolean>(false, true);
                }
                vectorPartDesc.setDataTypeInfos(nextDataTypeInfoList);
            }
            vectorTaskColumnInfo.setAllColumnNames(allColumnNameList);
            vectorTaskColumnInfo.setAllTypeInfos(allTypeInfoList);
            vectorTaskColumnInfo.setDataColumnNums(dataColumnNums);
            vectorTaskColumnInfo.setPartitionColumnCount(partitionColumnCount);
            vectorTaskColumnInfo.setAvailableVirtualColumnList(availableVirtualColumnList);
            vectorTaskColumnInfo.setUseVectorizedInputFileFormat(this.shouldUseVectorizedInputFormat(inputFileFormatClassNameSet));
            vectorTaskColumnInfo.setInputFormatSupportSet(inputFormatSupportSet);
            mapWork.setVectorizationInputFileFormatClassNameSet(inputFileFormatClassNameSet);
            ArrayList<VectorPartitionDesc> vectorPartitionDescList = new ArrayList<VectorPartitionDesc>();
            vectorPartitionDescList.addAll(vectorPartitionDescMap.keySet());
            mapWork.setVectorPartitionDescList(vectorPartitionDescList);
            mapWork.setVectorizationEnabledConditionsMet(new ArrayList<String>(enabledConditionsMetSet));
            mapWork.setVectorizationEnabledConditionsNotMet(enabledConditionsNotMetList);
            return new ImmutablePair<Boolean, Boolean>(true, false);
        }

        private void validateAndVectorizeMapWork(MapWork mapWork, VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTezOrSpark) throws SemanticException {
            int i;
            LOG.info("Examining input format to see if vectorization is enabled.");
            ImmutablePair<String, TableScanOperator> onlyOneTableScanPair = this.verifyOnlyOneTableScanOperator(mapWork);
            if (onlyOneTableScanPair == null) {
                VectorizerReason notVectorizedReason = Vectorizer.this.currentBaseWork.getNotVectorizedReason();
                Preconditions.checkState(notVectorizedReason != null);
                mapWork.setVectorizationEnabledConditionsNotMet(Arrays.asList(notVectorizedReason.toString()));
                return;
            }
            String alias = (String)onlyOneTableScanPair.left;
            TableScanOperator tableScanOperator = (TableScanOperator)onlyOneTableScanPair.right;
            Vectorizer.this.currentOperator = tableScanOperator;
            ImmutablePair<Boolean, Boolean> validateInputFormatAndSchemaEvolutionPair = this.validateInputFormatAndSchemaEvolution(mapWork, alias, tableScanOperator, vectorTaskColumnInfo);
            if (!((Boolean)validateInputFormatAndSchemaEvolutionPair.left).booleanValue()) {
                if (!((Boolean)validateInputFormatAndSchemaEvolutionPair.right).booleanValue()) {
                    VectorizerReason notVectorizedReason = Vectorizer.this.currentBaseWork.getNotVectorizedReason();
                    Preconditions.checkState(notVectorizedReason != null);
                    mapWork.setVectorizationEnabledConditionsNotMet(Arrays.asList(notVectorizedReason.toString()));
                }
                return;
            }
            int dataColumnCount = vectorTaskColumnInfo.allColumnNames.size() - vectorTaskColumnInfo.partitionColumnCount;
            ArrayList<String> supportRemovedReasons = new ArrayList<String>();
            TreeSet<VectorizedSupport.Support> supportSet = new TreeSet<VectorizedSupport.Support>();
            if (vectorTaskColumnInfo.inputFormatSupportSet != null) {
                supportSet.addAll(vectorTaskColumnInfo.inputFormatSupportSet);
            }
            supportSet.retainAll(Vectorizer.this.vectorizedInputFormatSupportEnabledSet);
            if (!supportSet.equals(vectorTaskColumnInfo.inputFormatSupportSet)) {
                TreeSet removedSet = new TreeSet();
                removedSet.addAll(Vectorizer.this.vectorizedInputFormatSupportEnabledSet);
                removedSet.removeAll(supportSet);
                String removeString = ((Object)removedSet).toString() + " is disabled because it is not in " + HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED.varname + " " + Vectorizer.this.vectorizedInputFormatSupportEnabledSet.toString();
                supportRemovedReasons.add(removeString);
            }
            vectorTaskColumnInfo.setSupportSetInUse(supportSet);
            vectorTaskColumnInfo.setSupportRemovedReasons(supportRemovedReasons);
            boolean isSupportDecimal64 = supportSet.contains((Object)VectorizedSupport.Support.DECIMAL_64);
            ArrayList<DataTypePhysicalVariation> dataTypePhysicalVariations = new ArrayList<DataTypePhysicalVariation>();
            for (i = 0; i < dataColumnCount; ++i) {
                DecimalTypeInfo decimalTypeInfo;
                TypeInfo typeInfo;
                DataTypePhysicalVariation dataTypePhysicalVariation = DataTypePhysicalVariation.NONE;
                if (isSupportDecimal64 && (typeInfo = vectorTaskColumnInfo.allTypeInfos.get(i)) instanceof DecimalTypeInfo && HiveDecimalWritable.isPrecisionDecimal64((decimalTypeInfo = (DecimalTypeInfo)typeInfo).precision())) {
                    dataTypePhysicalVariation = DataTypePhysicalVariation.DECIMAL_64;
                }
                dataTypePhysicalVariations.add(dataTypePhysicalVariation);
            }
            for (i = 0; i < vectorTaskColumnInfo.partitionColumnCount; ++i) {
                dataTypePhysicalVariations.add(DataTypePhysicalVariation.NONE);
            }
            vectorTaskColumnInfo.setAlldataTypePhysicalVariations(dataTypePhysicalVariations);
            Vectorizer.this.availableVectorizedVirtualColumnSet = new HashSet();
            Vectorizer.this.availableVectorizedVirtualColumnSet.addAll(vectorTaskColumnInfo.availableVirtualColumnList);
            Vectorizer.this.neededVirtualColumnSet = new HashSet();
            mapWork.setVectorizationEnabled(true);
            LOG.info("Vectorization is enabled for input format(s) " + mapWork.getVectorizationInputFileFormatClassNameSet().toString());
            if (!this.validateAndVectorizeMapOperators(mapWork, tableScanOperator, isTezOrSpark, vectorTaskColumnInfo)) {
                return;
            }
            vectorTaskColumnInfo.transferToBaseWork(mapWork);
            mapWork.setVectorMode(true);
        }

        private boolean validateAndVectorizeMapOperators(MapWork mapWork, TableScanOperator tableScanOperator, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            LOG.info("Validating and vectorizing MapWork... (vectorizedVertexNum " + Vectorizer.this.vectorizedVertexNum + ")");
            Vectorizer.this.currentBaseWork = mapWork;
            if (!Vectorizer.this.validateTableScanOperator(tableScanOperator, mapWork)) {
                return false;
            }
            try {
                this.validateAndVectorizeMapOperators(tableScanOperator, isTezOrSpark, vectorTaskColumnInfo);
            }
            catch (VectorizerCannotVectorizeException e) {
                return false;
            }
            catch (NullPointerException e) {
                if (!Vectorizer.this.isTestVectorizerSuppressFatalExceptions) {
                    throw e;
                }
                Vectorizer.this.setNodeIssue("exception: " + VectorizationContext.getStackTraceAsSingleLine(e));
                return false;
            }
            catch (ClassCastException e) {
                if (!Vectorizer.this.isTestVectorizerSuppressFatalExceptions) {
                    throw e;
                }
                Vectorizer.this.setNodeIssue("exception: " + VectorizationContext.getStackTraceAsSingleLine(e));
                return false;
            }
            catch (RuntimeException e) {
                if (!Vectorizer.this.isTestVectorizerSuppressFatalExceptions) {
                    throw e;
                }
                Vectorizer.this.setNodeIssue("exception: " + VectorizationContext.getStackTraceAsSingleLine(e));
                return false;
            }
            vectorTaskColumnInfo.setNeededVirtualColumnList(new ArrayList<VirtualColumn>(Vectorizer.this.neededVirtualColumnSet));
            VectorizationContext vContext = tableScanOperator.getOutputVectorizationContext();
            vectorTaskColumnInfo.setScratchTypeNameArray(vContext.getScratchColumnTypeNames());
            vectorTaskColumnInfo.setScratchdataTypePhysicalVariationsArray(vContext.getScratchDataTypePhysicalVariations());
            return true;
        }

        private void validateAndVectorizeMapOperators(TableScanOperator tableScanOperator, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws VectorizerCannotVectorizeException {
            Operator dummyVectorOperator = Vectorizer.this.validateAndVectorizeOperatorTree(tableScanOperator, false, isTezOrSpark, vectorTaskColumnInfo);
            List<Operator<? extends OperatorDesc>> vectorChildren = dummyVectorOperator.getChildOperators();
            tableScanOperator.setChildOperators(vectorChildren);
            int vectorChildCount = vectorChildren.size();
            for (int i = 0; i < vectorChildCount; ++i) {
                Operator<? extends OperatorDesc> vectorChild = vectorChildren.get(i);
                List<Operator<OperatorDesc>> vectorChildParents = vectorChild.getParentOperators();
                int vectorChildParentCount = vectorChildParents.size();
                for (int p = 0; p < vectorChildParentCount; ++p) {
                    Operator<OperatorDesc> vectorChildParent = vectorChildParents.get(p);
                    if (vectorChildParent != dummyVectorOperator) continue;
                    vectorChildParents.set(p, tableScanOperator);
                }
            }
            tableScanOperator.setTaskVectorizationContext(((VectorizationOperator)((Object)dummyVectorOperator)).getInputVectorizationContext());
            this.vectorizeTableScanOperatorInPlace(tableScanOperator, vectorTaskColumnInfo);
        }

        private void vectorizeTableScanOperatorInPlace(TableScanOperator tableScanOperator, VectorTaskColumnInfo vectorTaskColumnInfo) {
            TableScanDesc tableScanDesc = (TableScanDesc)tableScanOperator.getConf();
            VectorTableScanDesc vectorTableScanDesc = new VectorTableScanDesc();
            tableScanDesc.setVectorDesc(vectorTableScanDesc);
            VectorizationContext vContext = tableScanOperator.getOutputVectorizationContext();
            List<Integer> projectedColumns = vContext.getProjectedColumns();
            vectorTableScanDesc.setProjectedColumns(ArrayUtils.toPrimitive(projectedColumns.toArray(new Integer[0])));
            List<String> allColumnNameList = vectorTaskColumnInfo.allColumnNames;
            List<TypeInfo> allTypeInfoList = vectorTaskColumnInfo.allTypeInfos;
            List<DataTypePhysicalVariation> allDataTypePhysicalVariationList = vectorTaskColumnInfo.allDataTypePhysicalVariations;
            int projectedColumnCount = projectedColumns.size();
            String[] projectedDataColumnNames = new String[projectedColumnCount];
            TypeInfo[] projectedDataColumnTypeInfos = new TypeInfo[projectedColumnCount];
            DataTypePhysicalVariation[] projectedDataColumnDataTypePhysicalVariation = new DataTypePhysicalVariation[projectedColumnCount];
            for (int i = 0; i < projectedColumnCount; ++i) {
                int projectedColumnNum = projectedColumns.get(i);
                projectedDataColumnNames[i] = allColumnNameList.get(projectedColumnNum);
                projectedDataColumnTypeInfos[i] = allTypeInfoList.get(projectedColumnNum);
                projectedDataColumnDataTypePhysicalVariation[i] = allDataTypePhysicalVariationList.get(projectedColumnNum);
            }
            vectorTableScanDesc.setProjectedColumnNames(projectedDataColumnNames);
            vectorTableScanDesc.setProjectedColumnTypeInfos(projectedDataColumnTypeInfos);
            vectorTableScanDesc.setProjectedColumnDataTypePhysicalVariations(projectedDataColumnDataTypePhysicalVariation);
            ((TableScanDesc)tableScanOperator.getConf()).setVectorized(true);
            List<Operator<? extends OperatorDesc>> children = tableScanOperator.getChildOperators();
            while (children.size() > 0) {
                children = this.dosetVectorDesc(children);
            }
        }

        private List<Operator<? extends OperatorDesc>> dosetVectorDesc(List<Operator<? extends OperatorDesc>> children) {
            ArrayList<Operator<? extends OperatorDesc>> newChildren = new ArrayList<Operator<? extends OperatorDesc>>();
            for (Operator<? extends OperatorDesc> child : children) {
                VectorDesc vectorDesc = ((VectorizationOperator)((Object)child)).getVectorDesc();
                AbstractOperatorDesc desc = (AbstractOperatorDesc)child.getConf();
                desc.setVectorDesc(vectorDesc);
                List<Operator<OperatorDesc>> childChildren = child.getChildOperators();
                if (childChildren == null) continue;
                newChildren.addAll(childChildren);
            }
            return newChildren;
        }

        private void convertReduceWork(ReduceWork reduceWork) throws SemanticException {
            reduceWork.setVectorizationEnabled(true);
            VectorTaskColumnInfo vectorTaskColumnInfo = new VectorTaskColumnInfo();
            vectorTaskColumnInfo.assume();
            reduceWork.setVectorizedTestingReducerBatchSize(Vectorizer.this.vectorizedTestingReducerBatchSize);
            this.validateAndVectorizeReduceWork(reduceWork, vectorTaskColumnInfo);
        }

        private void validateAndVectorizeReduceWork(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            Operator<?> reducer = reduceWork.getReducer();
            if (!this.getOnlyStructObjectInspectors(reduceWork, vectorTaskColumnInfo)) {
                return;
            }
            if (!this.validateAndVectorizeReduceOperators(reduceWork, vectorTaskColumnInfo)) {
                return;
            }
            vectorTaskColumnInfo.transferToBaseWork(reduceWork);
            reduceWork.setVectorMode(true);
        }

        private boolean validateAndVectorizeReduceOperators(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            Operator<? extends OperatorDesc> newVectorReducer;
            LOG.info("Validating and vectorizing ReduceWork... (vectorizedVertexNum " + Vectorizer.this.vectorizedVertexNum + ")");
            try {
                newVectorReducer = this.validateAndVectorizeReduceOperators(reduceWork.getReducer(), vectorTaskColumnInfo);
            }
            catch (VectorizerCannotVectorizeException e) {
                return false;
            }
            catch (NullPointerException e) {
                if (!Vectorizer.this.isTestVectorizerSuppressFatalExceptions) {
                    throw e;
                }
                Vectorizer.this.setNodeIssue("exception: " + VectorizationContext.getStackTraceAsSingleLine(e));
                return false;
            }
            catch (ClassCastException e) {
                if (!Vectorizer.this.isTestVectorizerSuppressFatalExceptions) {
                    throw e;
                }
                Vectorizer.this.setNodeIssue("exception: " + VectorizationContext.getStackTraceAsSingleLine(e));
                return false;
            }
            catch (RuntimeException e) {
                if (!Vectorizer.this.isTestVectorizerSuppressFatalExceptions) {
                    throw e;
                }
                Vectorizer.this.setNodeIssue("exception: " + VectorizationContext.getStackTraceAsSingleLine(e));
                return false;
            }
            VectorizationContext vContext = ((VectorizationOperator)((Object)newVectorReducer)).getInputVectorizationContext();
            vectorTaskColumnInfo.setScratchTypeNameArray(vContext.getScratchColumnTypeNames());
            vectorTaskColumnInfo.setScratchdataTypePhysicalVariationsArray(vContext.getScratchDataTypePhysicalVariations());
            reduceWork.setReducer(newVectorReducer);
            return true;
        }

        private Operator<? extends OperatorDesc> validateAndVectorizeReduceOperators(Operator<? extends OperatorDesc> reducerOperator, VectorTaskColumnInfo vectorTaskColumnInfo) throws VectorizerCannotVectorizeException {
            DummyOperator dummyOperator = new DummyOperator();
            dummyOperator.getChildOperators().add(reducerOperator);
            Operator dummyVectorOperator = Vectorizer.this.validateAndVectorizeOperatorTree(dummyOperator, true, true, vectorTaskColumnInfo);
            Operator<OperatorDesc> newVectorReducer = dummyVectorOperator.getChildOperators().get(0);
            List<Operator<? extends OperatorDesc>> children = new ArrayList<Operator<? extends OperatorDesc>>();
            children.add(newVectorReducer);
            while (children.size() > 0) {
                children = this.dosetVectorDesc(children);
            }
            return newVectorReducer;
        }

        private boolean getOnlyStructObjectInspectors(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            String columnNullOrder;
            String columnSortOrder;
            ArrayList<String> reduceColumnNames = new ArrayList<String>();
            ArrayList<TypeInfo> reduceTypeInfos = new ArrayList<TypeInfo>();
            if (reduceWork.getNeedsTagging()) {
                Vectorizer.this.setNodeIssue("Tagging not supported");
                return false;
            }
            try {
                TableDesc keyTableDesc = reduceWork.getKeyDesc();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using reduce tag " + reduceWork.getTag());
                }
                TableDesc valueTableDesc = reduceWork.getTagToValueDesc().get(reduceWork.getTag());
                Properties keyTableProperties = keyTableDesc.getProperties();
                Deserializer keyDeserializer = (Deserializer)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe(keyDeserializer, null, keyTableProperties, null);
                ObjectInspector keyObjectInspector = keyDeserializer.getObjectInspector();
                if (keyObjectInspector == null) {
                    Vectorizer.this.setNodeIssue("Key object inspector null");
                    return false;
                }
                if (!(keyObjectInspector instanceof StructObjectInspector)) {
                    Vectorizer.this.setNodeIssue("Key object inspector not StructObjectInspector");
                    return false;
                }
                StructObjectInspector keyStructObjectInspector = (StructObjectInspector)keyObjectInspector;
                List<? extends StructField> keyFields = keyStructObjectInspector.getAllStructFieldRefs();
                for (StructField structField : keyFields) {
                    reduceColumnNames.add(Utilities.ReduceField.KEY.toString() + "." + structField.getFieldName());
                    reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                }
                columnSortOrder = keyTableProperties.getProperty("serialization.sort.order");
                columnNullOrder = keyTableProperties.getProperty("serialization.sort.order.null");
                Deserializer valueDeserializer = (Deserializer)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe(valueDeserializer, null, valueTableDesc.getProperties(), null);
                ObjectInspector objectInspector = valueDeserializer.getObjectInspector();
                if (objectInspector != null) {
                    if (!(objectInspector instanceof StructObjectInspector)) {
                        Vectorizer.this.setNodeIssue("Value object inspector not StructObjectInspector");
                        return false;
                    }
                    StructObjectInspector valueStructObjectInspector = (StructObjectInspector)objectInspector;
                    List<? extends StructField> valueFields = valueStructObjectInspector.getAllStructFieldRefs();
                    for (StructField structField : valueFields) {
                        reduceColumnNames.add(Utilities.ReduceField.VALUE.toString() + "." + structField.getFieldName());
                        reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                    }
                }
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
            vectorTaskColumnInfo.setAllColumnNames(reduceColumnNames);
            vectorTaskColumnInfo.setAllTypeInfos(reduceTypeInfos);
            vectorTaskColumnInfo.setReduceColumnSortOrder(columnSortOrder);
            vectorTaskColumnInfo.setReduceColumnNullOrder(columnNullOrder);
            return true;
        }
    }

    private static class DummyVectorOperator
    extends DummyOperator
    implements VectorizationOperator {
        private VectorizationContext vContext;

        public DummyVectorOperator(VectorizationContext vContext) {
            this.conf = new DummyRootVectorDesc();
            this.vContext = vContext;
        }

        @Override
        public VectorizationContext getInputVectorizationContext() {
            return this.vContext;
        }

        @Override
        public VectorDesc getVectorDesc() {
            return null;
        }
    }

    private static class DummyOperator
    extends Operator<DummyRootVectorDesc> {
        public DummyOperator() {
            super(new CompilationOpContext());
        }

        @Override
        public void process(Object row, int tag) throws HiveException {
            throw new RuntimeException("Not used");
        }

        @Override
        public String getName() {
            return "DUMMY";
        }

        @Override
        public OperatorType getType() {
            return null;
        }
    }

    private static class DummyRootVectorDesc
    extends AbstractOperatorDesc {
    }

    private class VectorTaskColumnInfo {
        List<String> allColumnNames;
        List<TypeInfo> allTypeInfos;
        List<Integer> dataColumnNums;
        int partitionColumnCount = 0;
        List<VirtualColumn> availableVirtualColumnList;
        List<VirtualColumn> neededVirtualColumnList;
        private boolean useVectorizedInputFileFormat;
        Set<VectorizedSupport.Support> inputFormatSupportSet;
        Set<VectorizedSupport.Support> supportSetInUse;
        List<String> supportRemovedReasons;
        List<DataTypePhysicalVariation> allDataTypePhysicalVariations;
        boolean allNative;
        boolean usesVectorUDFAdaptor;
        String[] scratchTypeNameArray;
        DataTypePhysicalVariation[] scratchdataTypePhysicalVariations;
        String reduceColumnSortOrder;
        String reduceColumnNullOrder;

        VectorTaskColumnInfo() {
        }

        public void assume() {
            this.allNative = true;
            this.usesVectorUDFAdaptor = false;
        }

        public void setAllColumnNames(List<String> allColumnNames) {
            this.allColumnNames = allColumnNames;
        }

        public void setAllTypeInfos(List<TypeInfo> allTypeInfos) {
            this.allTypeInfos = allTypeInfos;
        }

        public void setDataColumnNums(List<Integer> dataColumnNums) {
            this.dataColumnNums = dataColumnNums;
        }

        public void setPartitionColumnCount(int partitionColumnCount) {
            this.partitionColumnCount = partitionColumnCount;
        }

        public void setAvailableVirtualColumnList(List<VirtualColumn> availableVirtualColumnList) {
            this.availableVirtualColumnList = availableVirtualColumnList;
        }

        public void setNeededVirtualColumnList(List<VirtualColumn> neededVirtualColumnList) {
            this.neededVirtualColumnList = neededVirtualColumnList;
        }

        public void setSupportSetInUse(Set<VectorizedSupport.Support> supportSetInUse) {
            this.supportSetInUse = supportSetInUse;
        }

        public void setSupportRemovedReasons(List<String> supportRemovedReasons) {
            this.supportRemovedReasons = supportRemovedReasons;
        }

        public void setAlldataTypePhysicalVariations(List<DataTypePhysicalVariation> allDataTypePhysicalVariations) {
            this.allDataTypePhysicalVariations = allDataTypePhysicalVariations;
        }

        public void setScratchTypeNameArray(String[] scratchTypeNameArray) {
            this.scratchTypeNameArray = scratchTypeNameArray;
        }

        public void setScratchdataTypePhysicalVariationsArray(DataTypePhysicalVariation[] scratchdataTypePhysicalVariations) {
            this.scratchdataTypePhysicalVariations = scratchdataTypePhysicalVariations;
        }

        public void setAllNative(boolean allNative) {
            this.allNative = allNative;
        }

        public void setUsesVectorUDFAdaptor(boolean usesVectorUDFAdaptor) {
            this.usesVectorUDFAdaptor = usesVectorUDFAdaptor;
        }

        public void setUseVectorizedInputFileFormat(boolean useVectorizedInputFileFormat) {
            this.useVectorizedInputFileFormat = useVectorizedInputFileFormat;
        }

        public void setInputFormatSupportSet(Set<VectorizedSupport.Support> inputFormatSupportSet) {
            this.inputFormatSupportSet = inputFormatSupportSet;
        }

        public void setReduceColumnSortOrder(String reduceColumnSortOrder) {
            this.reduceColumnSortOrder = reduceColumnSortOrder;
        }

        public void setReduceColumnNullOrder(String reduceColumnNullOrder) {
            this.reduceColumnNullOrder = reduceColumnNullOrder;
        }

        public void transferToBaseWork(BaseWork baseWork) {
            DataTypePhysicalVariation[] allDataTypePhysicalVariationArray;
            int virtualColumnCount = this.availableVirtualColumnList == null ? 0 : this.availableVirtualColumnList.size();
            VirtualColumn[] neededVirtualColumns = this.neededVirtualColumnList != null && this.neededVirtualColumnList.size() > 0 ? this.neededVirtualColumnList.toArray(new VirtualColumn[0]) : new VirtualColumn[]{};
            String[] allColumnNameArray = this.allColumnNames.toArray(new String[0]);
            TypeInfo[] allTypeInfoArray = this.allTypeInfos.toArray(new TypeInfo[0]);
            int[] dataColumnNumsArray = this.dataColumnNums != null ? ArrayUtils.toPrimitive(this.dataColumnNums.toArray(new Integer[0])) : null;
            if (this.allDataTypePhysicalVariations == null) {
                allDataTypePhysicalVariationArray = new DataTypePhysicalVariation[allTypeInfoArray.length];
                Arrays.fill((Object[])allDataTypePhysicalVariationArray, (Object)DataTypePhysicalVariation.NONE);
            } else {
                allDataTypePhysicalVariationArray = this.allDataTypePhysicalVariations.toArray(new DataTypePhysicalVariation[0]);
            }
            VectorizedRowBatchCtx vectorizedRowBatchCtx = new VectorizedRowBatchCtx(allColumnNameArray, allTypeInfoArray, allDataTypePhysicalVariationArray, dataColumnNumsArray, this.partitionColumnCount, virtualColumnCount, neededVirtualColumns, this.scratchTypeNameArray, this.scratchdataTypePhysicalVariations);
            baseWork.setVectorizedRowBatchCtx(vectorizedRowBatchCtx);
            if (baseWork instanceof MapWork) {
                MapWork mapWork = (MapWork)baseWork;
                mapWork.setUseVectorizedInputFileFormat(this.useVectorizedInputFileFormat);
                mapWork.setInputFormatSupportSet(this.inputFormatSupportSet);
                mapWork.setSupportSetInUse(this.supportSetInUse);
                mapWork.setSupportRemovedReasons(this.supportRemovedReasons);
            }
            if (baseWork instanceof ReduceWork) {
                ReduceWork reduceWork = (ReduceWork)baseWork;
                reduceWork.setVectorReduceColumnSortOrder(this.reduceColumnSortOrder);
                reduceWork.setVectorReduceColumnNullOrder(this.reduceColumnNullOrder);
            }
            baseWork.setAllNative(this.allNative);
            baseWork.setUsesVectorUDFAdaptor(this.usesVectorUDFAdaptor);
            baseWork.setIsTestForcedVectorizationEnable(Vectorizer.this.isTestForcedVectorizationEnable);
            baseWork.setIsTestVectorizationSuppressExplainExecutionMode(Vectorizer.this.isTestVectorizationSuppressExplainExecutionMode);
        }
    }

    public class VectorizerCannotVectorizeException
    extends Exception {
    }

    public static enum VectorizationEnabledOverride {
        NONE,
        DISABLE,
        ENABLE;

        public static final Map<String, VectorizationEnabledOverride> nameMap;

        static {
            nameMap = new HashMap<String, VectorizationEnabledOverride>();
            for (VectorizationEnabledOverride vectorizationEnabledOverride : VectorizationEnabledOverride.values()) {
                nameMap.put(vectorizationEnabledOverride.name().toLowerCase(), vectorizationEnabledOverride);
            }
        }
    }
}

