/*
 * Decompiled with CFR 0.152.
 */
package hive.shaded.parquet.org.apache.thrift.transport;

import hive.shaded.parquet.org.apache.thrift.TByteArrayOutputStream;
import hive.shaded.parquet.org.apache.thrift.TConfiguration;
import hive.shaded.parquet.org.apache.thrift.transport.TEndpointTransport;
import hive.shaded.parquet.org.apache.thrift.transport.TTransportException;
import java.nio.charset.Charset;

public class TMemoryBuffer
extends TEndpointTransport {
    private TByteArrayOutputStream arr_;
    private int pos_;

    public TMemoryBuffer(int size) throws TTransportException {
        super(new TConfiguration());
        this.arr_ = new TByteArrayOutputStream(size);
        this.updateKnownMessageSize(size);
    }

    public TMemoryBuffer(TConfiguration config, int size) throws TTransportException {
        super(config);
        this.arr_ = new TByteArrayOutputStream(size);
        this.updateKnownMessageSize(size);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int amtToRead;
        this.checkReadBytesAvailable(len);
        byte[] src = this.arr_.get();
        int n = amtToRead = len > this.arr_.len() - this.pos_ ? this.arr_.len() - this.pos_ : len;
        if (amtToRead > 0) {
            System.arraycopy(src, this.pos_, buf, off, amtToRead);
            this.pos_ += amtToRead;
        }
        return amtToRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.arr_.write(buf, off, len);
    }

    public String toString(Charset charset) {
        return this.arr_.toString(charset);
    }

    public String inspect() {
        StringBuilder buf = new StringBuilder();
        byte[] bytes = this.arr_.toByteArray();
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(this.pos_ == i ? "==>" : "").append(Integer.toHexString(bytes[i] & 0xFF)).append(" ");
        }
        return buf.toString();
    }

    public int length() {
        return this.arr_.size();
    }

    public byte[] getArray() {
        return this.arr_.get();
    }
}

