/*
 * Decompiled with CFR 0.152.
 */
package hive.shaded.parquet.net.openhft.hashing;

import hive.shaded.parquet.net.openhft.hashing.Access;
import hive.shaded.parquet.net.openhft.hashing.LongHashFunction;
import hive.shaded.parquet.net.openhft.hashing.Maths;
import hive.shaded.parquet.net.openhft.hashing.Primitives;
import java.nio.ByteOrder;

class WyHash {
    public static final long _wyp0 = -6884282663029611473L;
    public static final long _wyp1 = -1800455987208640293L;
    public static final long _wyp2 = -8161530843051276573L;
    public static final long _wyp3 = 6384245875588680899L;
    public static final long _wyp4 = 2129725606500045391L;

    WyHash() {
    }

    private static long _wymum(long lhs, long rhs) {
        return Maths.unsignedLongMulXorFold(lhs, rhs);
    }

    private static <T> long _wyr3(Access<T> access, T in, long index, long k) {
        return (long)access.u8(in, index) << 16 | (long)access.u8(in, index + (k >>> 1)) << 8 | (long)access.u8(in, index + k - 1L);
    }

    private static <T> long u64Rorate32(Access<T> access, T in, long index) {
        return access.u32(in, index) << 32 | access.u32(in, index + 4L);
    }

    static <T> long wyHash64(long seed, T input, Access<T> access, long off, long length) {
        if (length <= 0L) {
            return 0L;
        }
        if (length < 4L) {
            return WyHash._wymum(WyHash._wymum(WyHash._wyr3(access, input, off, length) ^ seed ^ 0xA0761D6478BD642FL, seed ^ 0xE7037ED1A0B428DBL) ^ seed, length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 8L) {
            return WyHash._wymum(WyHash._wymum(access.u32(input, off) ^ seed ^ 0xA0761D6478BD642FL, access.u32(input, off + length - 4L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ seed, length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 16L) {
            return WyHash._wymum(WyHash._wymum(WyHash.u64Rorate32(access, input, off) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(access, input, off + length - 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ seed, length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 24L) {
            return WyHash._wymum(WyHash._wymum(WyHash.u64Rorate32(access, input, off) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(access, input, off + 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(WyHash.u64Rorate32(access, input, off + length - 8L) ^ seed ^ 0x8EBC6AF09C88C6E3L, seed ^ 0x589965CC75374CC3L), length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 32L) {
            return WyHash._wymum(WyHash._wymum(WyHash.u64Rorate32(access, input, off) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(access, input, off + 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(WyHash.u64Rorate32(access, input, off + 16L) ^ seed ^ 0x8EBC6AF09C88C6E3L, WyHash.u64Rorate32(access, input, off + length - 8L) ^ seed ^ 0x589965CC75374CC3L), length ^ 0x1D8E4E27C47D124FL);
        }
        long see1 = seed;
        long i = length;
        long p = off;
        while (i > 256L) {
            seed = WyHash._wymum(access.i64(input, p) ^ seed ^ 0xA0761D6478BD642FL, access.i64(input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(access.i64(input, p + 16L) ^ seed ^ 0x8EBC6AF09C88C6E3L, access.i64(input, p + 24L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(access.i64(input, p + 32L) ^ see1 ^ 0xE7037ED1A0B428DBL, access.i64(input, p + 40L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(access.i64(input, p + 48L) ^ see1 ^ 0x589965CC75374CC3L, access.i64(input, p + 56L) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash._wymum(access.i64(input, p + 64L) ^ seed ^ 0xA0761D6478BD642FL, access.i64(input, p + 72L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(access.i64(input, p + 80L) ^ seed ^ 0x8EBC6AF09C88C6E3L, access.i64(input, p + 88L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(access.i64(input, p + 96L) ^ see1 ^ 0xE7037ED1A0B428DBL, access.i64(input, p + 104L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(access.i64(input, p + 112L) ^ see1 ^ 0x589965CC75374CC3L, access.i64(input, p + 120L) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash._wymum(access.i64(input, p + 128L) ^ seed ^ 0xA0761D6478BD642FL, access.i64(input, p + 136L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(access.i64(input, p + 144L) ^ seed ^ 0x8EBC6AF09C88C6E3L, access.i64(input, p + 152L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(access.i64(input, p + 160L) ^ see1 ^ 0xE7037ED1A0B428DBL, access.i64(input, p + 168L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(access.i64(input, p + 176L) ^ see1 ^ 0x589965CC75374CC3L, access.i64(input, p + 184L) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash._wymum(access.i64(input, p + 192L) ^ seed ^ 0xA0761D6478BD642FL, access.i64(input, p + 200L) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash._wymum(access.i64(input, p + 208L) ^ seed ^ 0x8EBC6AF09C88C6E3L, access.i64(input, p + 216L) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash._wymum(access.i64(input, p + 224L) ^ see1 ^ 0xE7037ED1A0B428DBL, access.i64(input, p + 232L) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash._wymum(access.i64(input, p + 240L) ^ see1 ^ 0x589965CC75374CC3L, access.i64(input, p + 248L) ^ see1 ^ 0xA0761D6478BD642FL);
            i -= 256L;
            p += 256L;
        }
        while (i > 32L) {
            seed = WyHash._wymum(access.i64(input, p) ^ seed ^ 0xA0761D6478BD642FL, access.i64(input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash._wymum(access.i64(input, p + 16L) ^ see1 ^ 0x8EBC6AF09C88C6E3L, access.i64(input, p + 24L) ^ see1 ^ 0x589965CC75374CC3L);
            i -= 32L;
            p += 32L;
        }
        if (i < 4L) {
            seed = WyHash._wymum(WyHash._wyr3(access, input, p, i) ^ seed ^ 0xA0761D6478BD642FL, seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 8L) {
            seed = WyHash._wymum(access.u32(input, p) ^ seed ^ 0xA0761D6478BD642FL, access.u32(input, p + i - 4L) ^ seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 16L) {
            seed = WyHash._wymum(WyHash.u64Rorate32(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(access, input, p + i - 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 24L) {
            seed = WyHash._wymum(WyHash.u64Rorate32(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(access, input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash._wymum(WyHash.u64Rorate32(access, input, p + i - 8L) ^ see1 ^ 0x8EBC6AF09C88C6E3L, see1 ^ 0x589965CC75374CC3L);
        } else {
            seed = WyHash._wymum(WyHash.u64Rorate32(access, input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(access, input, p + 8L) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash._wymum(WyHash.u64Rorate32(access, input, p + 16L) ^ see1 ^ 0x8EBC6AF09C88C6E3L, WyHash.u64Rorate32(access, input, p + i - 8L) ^ see1 ^ 0x589965CC75374CC3L);
        }
        return WyHash._wymum(seed ^ see1, length ^ 0x1D8E4E27C47D124FL);
    }

    static LongHashFunction asLongHashFunctionWithoutSeed() {
        return AsLongHashFunction.SEEDLESS_INSTANCE;
    }

    static LongHashFunction asLongHashFunctionWithSeed(long seed) {
        return new AsLongHashFunctionSeeded(seed);
    }

    private static class AsLongHashFunctionSeeded
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        private final long seed;

        private AsLongHashFunctionSeeded(long seed) {
            this.seed = seed;
        }

        @Override
        public long seed() {
            return this.seed;
        }
    }

    private static class AsLongHashFunction
    extends LongHashFunction {
        private static final long serialVersionUID = 0L;
        static final AsLongHashFunction SEEDLESS_INSTANCE = new AsLongHashFunction();

        private AsLongHashFunction() {
        }

        private Object readResolve() {
            return SEEDLESS_INSTANCE;
        }

        public long seed() {
            return 0L;
        }

        @Override
        public long hashLong(long input) {
            input = Primitives.nativeToLittleEndian(input);
            long hi = input & 0xFFFFFFFFL;
            long lo = input >>> 32 & 0xFFFFFFFFL;
            return WyHash._wymum(WyHash._wymum(hi ^ this.seed() ^ 0xA0761D6478BD642FL, lo ^ this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045383L);
        }

        @Override
        public long hashInt(int input) {
            input = Primitives.nativeToLittleEndian(input);
            long longInput = (long)input & 0xFFFFFFFFL;
            return WyHash._wymum(WyHash._wymum(longInput ^ this.seed() ^ 0xA0761D6478BD642FL, longInput ^ this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045387L);
        }

        @Override
        public long hashShort(short input) {
            input = Primitives.nativeToLittleEndian(input);
            long hi = (long)(input >>> 8) & 0xFFL;
            long wyr3 = hi | hi << 8 | ((long)input & 0xFFL) << 16;
            return WyHash._wymum(WyHash._wymum(wyr3 ^ this.seed() ^ 0xA0761D6478BD642FL, this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045389L);
        }

        @Override
        public long hashChar(char input) {
            return this.hashShort((short)input);
        }

        @Override
        public long hashByte(byte input) {
            long hi = (long)input & 0xFFL;
            long wyr3 = hi | hi << 8 | hi << 16;
            return WyHash._wymum(WyHash._wymum(wyr3 ^ this.seed() ^ 0xA0761D6478BD642FL, this.seed() ^ 0xE7037ED1A0B428DBL) ^ this.seed(), 2129725606500045390L);
        }

        @Override
        public long hashVoid() {
            return 0L;
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            long seed = this.seed();
            return WyHash.wyHash64(seed, input, access.byteOrder(input, ByteOrder.LITTLE_ENDIAN), off, len);
        }
    }
}

