/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.filter2.predicate;

import hive.org.apache.parquet.filter2.predicate.FilterPredicate;
import hive.org.apache.parquet.filter2.predicate.Operators;
import hive.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import java.util.Objects;

public final class ContainsRewriter
implements FilterPredicate.Visitor<FilterPredicate> {
    private static final ContainsRewriter INSTANCE = new ContainsRewriter();

    public static FilterPredicate rewrite(FilterPredicate pred) {
        Objects.requireNonNull(pred, "pred cannot be null");
        return pred.accept(INSTANCE);
    }

    private ContainsRewriter() {
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Eq<T> eq) {
        return eq;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.NotEq<T> notEq) {
        return notEq;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Lt<T> lt) {
        return lt;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.LtEq<T> ltEq) {
        return ltEq;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Gt<T> gt) {
        return gt;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.GtEq<T> gtEq) {
        return gtEq;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.In<T> in) {
        return in;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.NotIn<T> notIn) {
        return notIn;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Contains<T> contains) {
        return contains;
    }

    @Override
    public FilterPredicate visit(Operators.And and) {
        FilterPredicate left = and.getLeft() instanceof Operators.And ? this.visit((Operators.And)and.getLeft()) : (and.getLeft() instanceof Operators.Or ? this.visit((Operators.Or)and.getLeft()) : (and.getLeft() instanceof Operators.Contains ? and.getLeft() : and.getLeft()));
        FilterPredicate right = and.getRight() instanceof Operators.And ? this.visit((Operators.And)and.getRight()) : (and.getRight() instanceof Operators.Or ? this.visit((Operators.Or)and.getRight()) : (and.getRight() instanceof Operators.Contains ? and.getRight() : and.getRight()));
        if (left instanceof Operators.Contains && right instanceof Operators.Contains && ((Operators.Contains)left).getColumn().getColumnPath().equals(((Operators.Contains)right).getColumn().getColumnPath())) {
            return ((Operators.Contains)left).and(right);
        }
        if (left != and.getLeft() || right != and.getRight()) {
            return new Operators.And(left, right);
        }
        return and;
    }

    @Override
    public FilterPredicate visit(Operators.Or or) {
        FilterPredicate left = or.getLeft() instanceof Operators.And ? this.visit((Operators.And)or.getLeft()) : (or.getLeft() instanceof Operators.Or ? this.visit((Operators.Or)or.getLeft()) : (or.getLeft() instanceof Operators.Contains ? or.getLeft() : or.getLeft()));
        FilterPredicate right = or.getRight() instanceof Operators.And ? this.visit((Operators.And)or.getRight()) : (or.getRight() instanceof Operators.Or ? this.visit((Operators.Or)or.getRight()) : (or.getRight() instanceof Operators.Contains ? or.getRight() : or.getRight()));
        if (left instanceof Operators.Contains && right instanceof Operators.Contains && ((Operators.Contains)left).getColumn().getColumnPath().equals(((Operators.Contains)right).getColumn().getColumnPath())) {
            return ((Operators.Contains)left).or(right);
        }
        if (left != or.getLeft() || right != or.getRight()) {
            return new Operators.Or(left, right);
        }
        return or;
    }

    @Override
    public FilterPredicate visit(Operators.Not not) {
        throw new IllegalStateException("Not predicate should be rewritten before being evaluated by ContainsRewriter");
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> FilterPredicate visit(Operators.UserDefined<T, U> udp) {
        return udp;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> FilterPredicate visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return udp;
    }
}

