/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.bytes;

import hive.org.apache.parquet.OutputStreamCloseException;
import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.bytes.ByteBufferAllocator;
import hive.org.apache.parquet.bytes.HeapByteBufferAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityByteArrayOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityByteArrayOutputStream.class);
    private static final ByteBuffer EMPTY_SLAB = ByteBuffer.wrap(new byte[0]);
    private int initialSlabSize;
    private final int maxCapacityHint;
    private final List<ByteBuffer> slabs = new ArrayList<ByteBuffer>();
    private ByteBuffer currentSlab;
    private int bytesAllocated = 0;
    private int bytesUsed = 0;
    private ByteBufferAllocator allocator;

    public static int initialSlabSizeHeuristic(int minSlabSize, int targetCapacity, int targetNumSlabs) {
        return Math.max(minSlabSize, (int)((double)targetCapacity / Math.pow(2.0, targetNumSlabs)));
    }

    public static CapacityByteArrayOutputStream withTargetNumSlabs(int minSlabSize, int maxCapacityHint, int targetNumSlabs) {
        return CapacityByteArrayOutputStream.withTargetNumSlabs(minSlabSize, maxCapacityHint, targetNumSlabs, new HeapByteBufferAllocator());
    }

    public static CapacityByteArrayOutputStream withTargetNumSlabs(int minSlabSize, int maxCapacityHint, int targetNumSlabs, ByteBufferAllocator allocator) {
        return new CapacityByteArrayOutputStream(CapacityByteArrayOutputStream.initialSlabSizeHeuristic(minSlabSize, maxCapacityHint, targetNumSlabs), maxCapacityHint, allocator);
    }

    @Deprecated
    public CapacityByteArrayOutputStream(int initialSlabSize) {
        this(initialSlabSize, 0x100000, new HeapByteBufferAllocator());
    }

    @Deprecated
    public CapacityByteArrayOutputStream(int initialSlabSize, ByteBufferAllocator allocator) {
        this(initialSlabSize, 0x100000, allocator);
    }

    @Deprecated
    public CapacityByteArrayOutputStream(int initialSlabSize, int maxCapacityHint) {
        this(initialSlabSize, maxCapacityHint, new HeapByteBufferAllocator());
    }

    public CapacityByteArrayOutputStream(int initialSlabSize, int maxCapacityHint, ByteBufferAllocator allocator) {
        Preconditions.checkArgument(initialSlabSize > 0, "initialSlabSize must be > 0");
        Preconditions.checkArgument(maxCapacityHint > 0, "maxCapacityHint must be > 0");
        Preconditions.checkArgument(maxCapacityHint >= initialSlabSize, "maxCapacityHint can't be less than initialSlabSize %s %s", (Object)initialSlabSize, (Object)maxCapacityHint);
        this.initialSlabSize = initialSlabSize;
        this.maxCapacityHint = maxCapacityHint;
        this.allocator = allocator;
        this.reset();
    }

    private void addSlab(int minimumSize) {
        try {
            Math.addExact(this.bytesUsed, minimumSize);
        }
        catch (ArithmeticException e) {
            throw new OutOfMemoryError("Size of data exceeded Integer.MAX_VALUE (" + e.getMessage() + ")");
        }
        int nextSlabSize = this.bytesUsed == 0 ? this.initialSlabSize : (this.bytesUsed > this.maxCapacityHint / 5 ? this.maxCapacityHint / 5 : this.bytesUsed);
        if (nextSlabSize < minimumSize) {
            LOG.debug("slab size {} too small for value of size {}. Bumping up slab size", (Object)nextSlabSize, (Object)minimumSize);
            nextSlabSize = minimumSize;
        }
        LOG.debug("used {} slabs, adding new slab of size {}", (Object)this.slabs.size(), (Object)nextSlabSize);
        this.currentSlab = this.allocator.allocate(nextSlabSize);
        this.slabs.add(this.currentSlab);
        this.bytesAllocated = Math.addExact(this.bytesAllocated, nextSlabSize);
    }

    @Override
    public void write(int b) {
        if (!this.currentSlab.hasRemaining()) {
            this.addSlab(1);
        }
        this.currentSlab.put((byte)b);
        this.bytesUsed = Math.addExact(this.bytesUsed, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException(String.format("Given byte array of size %d, with requested length(%d) and offset(%d)", b.length, len, off));
        }
        if (len > this.currentSlab.remaining()) {
            int length1 = this.currentSlab.remaining();
            this.currentSlab.put(b, off, length1);
            int length2 = len - length1;
            this.addSlab(length2);
            this.currentSlab.put(b, off + length1, length2);
        } else {
            this.currentSlab.put(b, off, len);
        }
        this.bytesUsed = Math.addExact(this.bytesUsed, len);
    }

    private void writeToOutput(OutputStream out, ByteBuffer buf, int len) throws IOException {
        if (buf.hasArray()) {
            out.write(buf.array(), buf.arrayOffset(), len);
        } else {
            byte[] copy = new byte[len];
            buf.flip();
            buf.get(copy);
            out.write(copy);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        for (ByteBuffer slab : this.slabs) {
            this.writeToOutput(out, slab, slab.position());
        }
    }

    void writeInto(ByteBuffer buffer) {
        for (ByteBuffer slab : this.slabs) {
            slab.flip();
            buffer.put(slab);
        }
    }

    public long size() {
        return this.bytesUsed;
    }

    public int getCapacity() {
        return this.bytesAllocated;
    }

    public void reset() {
        this.initialSlabSize = Math.max(this.bytesUsed / 7, this.initialSlabSize);
        LOG.debug("initial slab of size {}", (Object)this.initialSlabSize);
        for (ByteBuffer slab : this.slabs) {
            this.allocator.release(slab);
        }
        this.slabs.clear();
        this.bytesAllocated = 0;
        this.bytesUsed = 0;
        this.currentSlab = EMPTY_SLAB;
    }

    public long getCurrentIndex() {
        Preconditions.checkArgument(this.bytesUsed > 0, "This is an empty stream");
        return this.bytesUsed - 1;
    }

    public void setByte(long index, byte value) {
        Preconditions.checkArgument(index < (long)this.bytesUsed, "Index: %d is >= the current size of: %d", (Object)index, (Object)this.bytesUsed);
        long seen = 0L;
        for (int i = 0; i < this.slabs.size(); ++i) {
            ByteBuffer slab = this.slabs.get(i);
            if (index < seen + (long)slab.limit()) {
                slab.put((int)(index - seen), value);
                break;
            }
            seen += (long)slab.limit();
        }
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s %d slabs, %,d bytes", prefix, this.getClass().getSimpleName(), this.slabs.size(), this.getCapacity());
    }

    int getSlabCount() {
        return this.slabs.size();
    }

    ByteBuffer getInternalByteBuffer() {
        if (this.slabs.size() == 1) {
            ByteBuffer buf = this.slabs.get(0).duplicate();
            buf.flip();
            return buf.slice();
        }
        return null;
    }

    @Override
    public void close() {
        for (ByteBuffer slab : this.slabs) {
            this.allocator.release(slab);
        }
        this.slabs.clear();
        try {
            super.close();
        }
        catch (IOException e) {
            throw new OutputStreamCloseException(e);
        }
    }
}

