/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapred;

import hive.org.apache.avro.mapred.AvroCollector;
import hive.org.apache.avro.mapred.AvroReducer;
import hive.org.apache.avro.mapred.AvroWrapper;
import hive.org.apache.avro.mapred.HadoopReducerBase;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.util.ReflectionUtils;

class HadoopReducer<K, V, OUT>
extends HadoopReducerBase<K, V, OUT, AvroWrapper<OUT>, NullWritable> {
    HadoopReducer() {
    }

    @Override
    protected AvroReducer<K, V, OUT> getReducer(JobConf conf) {
        return (AvroReducer)ReflectionUtils.newInstance((Class)conf.getClass("avro.reducer", AvroReducer.class, AvroReducer.class), (Configuration)conf);
    }

    @Override
    protected AvroCollector<OUT> getCollector(OutputCollector<AvroWrapper<OUT>, NullWritable> collector) {
        return new ReduceCollector(collector);
    }

    private class ReduceCollector
    extends AvroCollector<OUT> {
        private final AvroWrapper<OUT> wrapper = new AvroWrapper<Object>(null);
        private OutputCollector<AvroWrapper<OUT>, NullWritable> out;

        public ReduceCollector(OutputCollector<AvroWrapper<OUT>, NullWritable> out) {
            this.out = out;
        }

        @Override
        public void collect(OUT datum) throws IOException {
            this.wrapper.datum(datum);
            this.out.collect(this.wrapper, (Object)NullWritable.get());
        }
    }
}

