/*
 * Decompiled with CFR 0.152.
 */
package hive.com.google.common.collect;

import hive.com.google.common.annotations.GwtCompatible;
import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.AbstractIterator;
import hive.com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Queue;

@GwtCompatible
class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(T ... elements) {
        this.queue = Lists.newLinkedList();
        Collections.addAll(this.queue, elements);
    }

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    public T computeNext() {
        return this.queue.isEmpty() ? this.endOfData() : this.queue.remove();
    }
}

