/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SSECustomerKeyDetails {
    @JsonProperty(value="algorithm")
    private final Algorithm algorithm;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="keySha256")
    private final String keySha256;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().algorithm(this.algorithm).key(this.key).keySha256(this.keySha256);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeySha256() {
        return this.keySha256;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSECustomerKeyDetails)) {
            return false;
        }
        SSECustomerKeyDetails other = (SSECustomerKeyDetails)o;
        Algorithm this$algorithm = this.getAlgorithm();
        Algorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$keySha256 = this.getKeySha256();
        String other$keySha256 = other.getKeySha256();
        if (this$keySha256 == null ? other$keySha256 != null : !this$keySha256.equals(other$keySha256)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Algorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $keySha256 = this.getKeySha256();
        result = result * 59 + ($keySha256 == null ? 43 : $keySha256.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "SSECustomerKeyDetails(algorithm=" + (Object)((Object)this.getAlgorithm()) + ", key=" + this.getKey() + ", keySha256=" + this.getKeySha256() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"algorithm", "key", "keySha256"})
    @Deprecated
    public SSECustomerKeyDetails(Algorithm algorithm, String key, String keySha256) {
        this.algorithm = algorithm;
        this.key = key;
        this.keySha256 = keySha256;
    }

    public static enum Algorithm {
        Aes256("AES256");

        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Algorithm: " + key);
        }

        static {
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="algorithm")
        private Algorithm algorithm;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="keySha256")
        private String keySha256;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder keySha256(String keySha256) {
            this.keySha256 = keySha256;
            this.__explicitlySet__.add("keySha256");
            return this;
        }

        public SSECustomerKeyDetails build() {
            SSECustomerKeyDetails __instance__ = new SSECustomerKeyDetails(this.algorithm, this.key, this.keySha256);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(SSECustomerKeyDetails o) {
            Builder copiedBuilder = this.algorithm(o.getAlgorithm()).key(o.getKey()).keySha256(o.getKeySha256());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "SSECustomerKeyDetails.Builder(algorithm=" + (Object)((Object)this.algorithm) + ", key=" + this.key + ", keySha256=" + this.keySha256 + ")";
        }
    }
}

