/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.components.tables;

import java.util.Arrays;
import java.util.List;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.components.tables.TablesMetadataTypeValidator;
import org.apache.drill.metastore.iceberg.IcebergMetastoreContext;
import org.apache.drill.metastore.iceberg.components.tables.TablesTransformer;
import org.apache.drill.metastore.iceberg.operate.ExpirationHandler;
import org.apache.drill.metastore.iceberg.operate.IcebergMetadata;
import org.apache.drill.metastore.iceberg.operate.IcebergModify;
import org.apache.drill.metastore.iceberg.operate.IcebergRead;
import org.apache.drill.metastore.iceberg.schema.IcebergTableSchema;
import org.apache.drill.metastore.iceberg.transform.Transformer;
import org.apache.drill.metastore.iceberg.write.FileWriter;
import org.apache.drill.metastore.iceberg.write.ParquetFileWriter;
import org.apache.drill.metastore.operate.Metadata;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.drill.metastore.operate.Modify;
import org.apache.drill.metastore.operate.Read;
import org.apache.iceberg.Table;

public class IcebergTables
implements Tables,
IcebergMetastoreContext<TableMetadataUnit> {
    private static final List<MetastoreColumn> PARTITION_KEYS = Arrays.asList(MetastoreColumn.STORAGE_PLUGIN, MetastoreColumn.WORKSPACE, MetastoreColumn.TABLE_NAME, MetastoreColumn.METADATA_KEY);
    public static IcebergTableSchema SCHEMA = IcebergTableSchema.of(TableMetadataUnit.class, PARTITION_KEYS);
    private final Table table;
    private final ExpirationHandler expirationHandler;

    public IcebergTables(Table table) {
        this.table = table;
        this.expirationHandler = new ExpirationHandler(table);
    }

    public IcebergMetastoreContext<TableMetadataUnit> context() {
        return this;
    }

    public Metadata metadata() {
        return new IcebergMetadata(this.table);
    }

    public Read<TableMetadataUnit> read() {
        return new IcebergRead<TableMetadataUnit>((MetadataTypeValidator)TablesMetadataTypeValidator.INSTANCE, this.context());
    }

    public Modify<TableMetadataUnit> modify() {
        return new IcebergModify<TableMetadataUnit>((MetadataTypeValidator)TablesMetadataTypeValidator.INSTANCE, this.context());
    }

    @Override
    public Table table() {
        return this.table;
    }

    @Override
    public FileWriter fileWriter() {
        return new ParquetFileWriter(this.table);
    }

    @Override
    public Transformer<TableMetadataUnit> transformer() {
        return new TablesTransformer(this.context());
    }

    @Override
    public ExpirationHandler expirationHandler() {
        return this.expirationHandler;
    }
}

