/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster.http;

import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.drill.yarn.appMaster.AMYarnFacade;
import org.apache.drill.yarn.appMaster.ClusterController;
import org.apache.drill.yarn.appMaster.ClusterControllerImpl;
import org.apache.drill.yarn.appMaster.ControllerVisitor;
import org.apache.drill.yarn.appMaster.Scheduler;
import org.apache.drill.yarn.appMaster.SchedulerStateActions;
import org.apache.drill.yarn.core.ContainerRequestSpec;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.zk.ZKRegistry;

@XmlRootElement
public class ControllerModel
implements ControllerVisitor {
    protected String zkConnectStr;
    protected String zkRoot;
    protected String zkClusterId;
    protected ClusterControllerImpl.State state;
    protected String stateHint;
    protected boolean supportsDisks;
    protected int yarnMemory;
    protected int yarnVcores;
    protected int yarnNodeCount;
    protected int taskCount;
    protected int liveCount;
    protected int unmanagedCount;
    protected int targetCount;
    protected int totalDrillMemory;
    protected int totalDrillVcores;
    protected double totalDrillDisks;
    protected int blacklistCount;
    protected int freeNodeCount;
    protected AMYarnFacade.YarnAppHostReport appRpt;
    protected int refreshSecs;
    protected List<ClusterGroupModel> groups = new ArrayList<ClusterGroupModel>();
    private static Map<ClusterControllerImpl.State, String> stateHints = ControllerModel.makeStateHints();

    public boolean supportsDiskResource() {
        return this.supportsDisks;
    }

    public int getRefreshSecs() {
        return this.refreshSecs;
    }

    public String getZkConnectionStr() {
        return this.zkConnectStr;
    }

    public String getZkRoot() {
        return this.zkRoot;
    }

    public String getZkClusterId() {
        return this.zkClusterId;
    }

    public String getAppId() {
        return this.appRpt.appId;
    }

    public String getRmHost() {
        return this.appRpt.rmHost;
    }

    public String getRmLink() {
        return this.appRpt.rmUrl;
    }

    public String getNmHost() {
        return this.appRpt.nmHost;
    }

    public String getNmLink() {
        return this.appRpt.nmUrl;
    }

    public String getRmAppLink() {
        return this.appRpt.rmAppUrl;
    }

    public String getNmAppLink() {
        return this.appRpt.nmAppUrl;
    }

    public String getState() {
        return this.state.toString();
    }

    public String getStateHint() {
        return this.stateHint;
    }

    public int getYarnMemory() {
        return this.yarnMemory;
    }

    public int getYarnVcores() {
        return this.yarnVcores;
    }

    public int getDrillTotalMemory() {
        return this.totalDrillMemory;
    }

    public int getDrillTotalVcores() {
        return this.totalDrillVcores;
    }

    public String getDrillTotalDisks() {
        return String.format("%.2f", this.totalDrillDisks);
    }

    public int getYarnNodeCount() {
        return this.yarnNodeCount;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public int getLiveCount() {
        return this.liveCount;
    }

    public int getUnmanagedCount() {
        return this.unmanagedCount;
    }

    public int getTargetCount() {
        return this.targetCount;
    }

    public List<ClusterGroupModel> getGroups() {
        return this.groups;
    }

    public int getBlacklistCount() {
        return this.blacklistCount;
    }

    public int getFreeNodeCount() {
        return this.freeNodeCount;
    }

    @Override
    public void visit(ClusterController controller) {
        Config config = DrillOnYarnConfig.config();
        this.refreshSecs = config.getInt(DrillOnYarnConfig.HTTP_REFRESH_SECS);
        this.zkConnectStr = config.getString("drill.exec.zk.connect");
        this.zkRoot = config.getString("drill.exec.zk.root");
        this.zkClusterId = config.getString("drill.exec.cluster-id");
        ClusterControllerImpl impl = (ClusterControllerImpl)controller;
        this.appRpt = impl.getYarn().getAppHostReport();
        this.state = impl.getState();
        this.stateHint = stateHints.get((Object)this.state);
        this.capturePools(impl);
        this.supportsDisks = impl.supportsDiskResource();
        this.blacklistCount = impl.getNodeInventory().getBlacklist().size();
        this.freeNodeCount = impl.getFreeNodeCount();
    }

    private void capturePools(ClusterControllerImpl impl) {
        for (SchedulerStateActions pool : impl.getPools()) {
            ClusterGroupModel poolModel = new ClusterGroupModel();
            Scheduler sched = pool.getScheduler();
            ContainerRequestSpec containerSpec = sched.getResource();
            poolModel.name = sched.getName();
            poolModel.type = sched.getType();
            poolModel.targetCount = sched.getTarget();
            poolModel.memory = containerSpec.memoryMb;
            poolModel.vcores = containerSpec.vCores;
            poolModel.disks = containerSpec.disks;
            poolModel.taskCount = pool.getTaskCount();
            poolModel.liveCount = pool.getLiveCount();
            this.targetCount += poolModel.targetCount;
            this.taskCount += poolModel.taskCount;
            this.liveCount += poolModel.liveCount;
            this.totalDrillMemory += poolModel.liveCount * poolModel.memory;
            this.totalDrillVcores += poolModel.liveCount * poolModel.vcores;
            this.totalDrillDisks += (double)poolModel.liveCount * poolModel.disks;
            this.groups.add(poolModel);
        }
        if (this.state != ClusterControllerImpl.State.LIVE) {
            this.targetCount = 0;
        }
    }

    public void countStrayDrillbits(ClusterController controller) {
        ZKRegistry zkRegistry = (ZKRegistry)controller.getProperty("zk");
        if (zkRegistry != null) {
            this.unmanagedCount = zkRegistry.listUnmanagedDrillits().size();
        }
    }

    private static Map<ClusterControllerImpl.State, String> makeStateHints() {
        HashMap<ClusterControllerImpl.State, String> hints = new HashMap<ClusterControllerImpl.State, String>();
        hints.put(ClusterControllerImpl.State.START, "AM is starting up.");
        hints.put(ClusterControllerImpl.State.LIVE, "AM is operating normally.");
        hints.put(ClusterControllerImpl.State.ENDING, "AM is shutting down.");
        hints.put(ClusterControllerImpl.State.ENDED, "AM is about to exit.");
        hints.put(ClusterControllerImpl.State.FAILED, "AM failed to start and is about to exit.");
        return hints;
    }

    public static class ClusterGroupModel {
        protected String name;
        protected String type;
        protected int targetCount;
        protected int taskCount;
        protected int liveCount;
        protected int memory;
        protected int vcores;
        protected double disks;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getTargetCount() {
            return this.targetCount;
        }

        public int getTaskCount() {
            return this.taskCount;
        }

        public int getLiveCount() {
            return this.liveCount;
        }

        public int getMemory() {
            return this.memory;
        }

        public int getVcores() {
            return this.vcores;
        }

        public String getDisks() {
            return String.format("%.02f", this.disks);
        }
    }
}

