/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.caching.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.oracle.bmc.hdfs.caching.Cache;
import com.oracle.bmc.hdfs.caching.CacheBuilderWithWeight;
import com.oracle.bmc.hdfs.caching.internal.GuavaCache;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaCacheBuilder<K, V>
implements CacheBuilderWithWeight<K, V, GuavaCacheBuilder<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaCacheBuilder.class);
    private int initialCapacity = 16;
    private boolean recordStats = false;
    private Integer maximumSize = null;
    private Long maximumWeightInBytes = null;
    private Integer concurrencyLevel = 1;
    private Duration expireAfterAccess = null;
    private Duration expireAfterWrite = null;
    private Cache.Weigher<K, V> weigher;
    private Cache.RemovalListener<K, V> removalListener;

    public GuavaCacheBuilder<K, V> initialCapacity(Integer initialCapacity) {
        this.initialCapacity = initialCapacity;
        return this;
    }

    public GuavaCacheBuilder<K, V> recordStats(boolean recordStats) {
        this.recordStats = recordStats;
        return this;
    }

    public GuavaCacheBuilder<K, V> maximumSize(Integer maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    @Override
    public GuavaCacheBuilder<K, V> maximumWeight(Long maximumWeightInBytes) {
        this.maximumWeightInBytes = maximumWeightInBytes;
        return this;
    }

    @Override
    public Long getMaximumWeight() {
        return this.maximumWeightInBytes;
    }

    public GuavaCacheBuilder<K, V> concurrencyLevel(Integer concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    public GuavaCacheBuilder<K, V> expireAfterAccess(Duration expireAfterAccess) {
        this.expireAfterAccess = expireAfterAccess;
        return this;
    }

    public GuavaCacheBuilder<K, V> expireAfterWrite(Duration expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
        return this;
    }

    @Override
    public GuavaCacheBuilder<K, V> weigher(Cache.Weigher<K, V> weigher) {
        this.weigher = weigher;
        return this;
    }

    @Override
    public GuavaCacheBuilder<K, V> removalListener(Cache.RemovalListener<K, V> removalListener) {
        this.removalListener = removalListener;
        return this;
    }

    @Override
    public GuavaCache<K, V> build() {
        Objects.requireNonNull(this.removalListener, "removalListener may not be null");
        CacheBuilder guavaCacheBuilder = CacheBuilder.newBuilder().initialCapacity(this.initialCapacity).concurrencyLevel(this.concurrencyLevel.intValue()).removalListener(notification -> this.removalListener.onRemoval(new GuavaRemovalNotification<Object, Object>(notification.getKey(), notification.getValue(), notification.getCause())));
        if (this.maximumSize != null) {
            guavaCacheBuilder = guavaCacheBuilder.maximumSize((long)this.maximumSize.intValue());
        }
        if (this.maximumWeightInBytes != null) {
            guavaCacheBuilder = guavaCacheBuilder.maximumWeight(this.maximumWeightInBytes.longValue());
        }
        if (this.weigher != null && this.maximumSize == null) {
            guavaCacheBuilder = guavaCacheBuilder.weigher((key, value) -> this.weigher.weigh(key, value));
        }
        if (this.recordStats) {
            guavaCacheBuilder = guavaCacheBuilder.recordStats();
        }
        if (this.expireAfterAccess != null) {
            guavaCacheBuilder = guavaCacheBuilder.expireAfterAccess(this.expireAfterAccess);
        }
        if (this.expireAfterWrite != null) {
            guavaCacheBuilder = guavaCacheBuilder.expireAfterWrite(this.expireAfterWrite);
        }
        LOG.debug("Creating cache with spec {}", (Object)guavaCacheBuilder);
        Cache guavaCache = guavaCacheBuilder.build();
        return new GuavaCache(guavaCache);
    }

    public static class GuavaRemovalNotification<KK, VV>
    extends Cache.RemovalNotification<KK, VV> {
        private final RemovalCause cause;

        public GuavaRemovalNotification(KK key, VV value, RemovalCause cause) {
            super(key, value);
            this.cause = cause;
        }

        @Override
        public String toString() {
            return "GuavaRemovalNotification{key=" + this.getKey() + ", value=" + this.getValue() + ", cause=" + this.cause + "}";
        }

        public RemovalCause getCause() {
            return this.cause;
        }
    }
}

