/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.caching;

import java.util.AbstractMap;
import java.util.concurrent.ConcurrentMap;

public interface Cache<K, V> {
    public V getIfPresent(K var1);

    public void put(K var1, V var2);

    public void invalidateAll();

    public void invalidate(K var1);

    public void cleanUp();

    public ConcurrentMap<K, V> asMap();

    public Statistics getStatistics();

    public static interface Statistics {
        public long requestCount();

        public long hitCount();

        public double hitRate();

        public long missCount();

        public double missRate();

        public long evictionCount();
    }

    public static interface Weigher<KK, VV> {
        public int weigh(KK var1, VV var2);
    }

    public static interface Loader<KK, VV> {
        public VV load(KK var1) throws Exception;
    }

    public static interface RemovalListener<KK, VV> {
        public void onRemoval(RemovalNotification<KK, VV> var1);
    }

    public static class RemovalNotification<KK, VV>
    extends AbstractMap.SimpleEntry<KK, VV> {
        public RemovalNotification(KK key, VV value) {
            super(key, value);
        }
    }

    public static class UncheckedExecutionException
    extends RuntimeException {
        public UncheckedExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

